/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutViewRoot;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.descriptors.Resource;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.jsftemplating.layout.descriptors.handler.IODescriptor;
import com.sun.jsftemplating.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayoutDefinitionManager {
    private Map<String, Object> _attributes = new HashMap<String, Object>();
    private static Map<String, LayoutDefinitionManager> _instances = new HashMap<String, LayoutDefinitionManager>(4);
    private static Map<String, LayoutDefinition> _layoutDefinitions = new HashMap<String, LayoutDefinition>();
    private static Map<String, ComponentType> _globalComponentTypes = null;
    private static Map<String, HandlerDefinition> _globalHandlerDefs = null;
    private static List<Resource> _globalResources = null;
    private static List<String> _ldmKeys = null;
    public static final String DEFAULT_TYPE = "Object";
    public static final String LAYOUT_DEFINITION_MANAGER_KEY = "LayoutDefinitionManagerImpl";
    public static final String DEBUG_FLAG = "com.sun.jsftemplating.DEBUG";
    private static Boolean _debug = null;
    public static final boolean DEBUG = LayoutDefinitionManager.isDebug();

    protected LayoutDefinitionManager() {
    }

    public abstract LayoutDefinition getLayoutDefinition(String var1) throws LayoutDefinitionException;

    public abstract boolean accepts(String var1);

    public static LayoutDefinition getLayoutDefinition(FacesContext ctx, String key) throws LayoutDefinitionException {
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        LayoutDefinition def = LayoutDefinitionManager.getCachedLayoutDefinition(key);
        if (def == null) {
            def = LayoutDefinitionManager.getLayoutDefinitionManager(ctx, key).getLayoutDefinition(key);
        } else {
            def.dispatchInitPageHandlers(ctx, def);
        }
        return def;
    }

    public static LayoutComponent getLayoutComponent(FacesContext ctx, String ldKey, String clientId) throws LayoutDefinitionException {
        LayoutElementBase layElt = null;
        if (ldKey != null) {
            layElt = LayoutDefinitionManager.getLayoutDefinition(ctx, ldKey);
            if (layElt == null) {
                throw new LayoutDefinitionException("Unable to find LayoutDefinition ('" + ldKey + "')");
            }
        } else {
            layElt = ((LayoutViewRoot)ctx.getViewRoot()).getLayoutDefinition(ctx);
        }
        StringTokenizer tok = new StringTokenizer(clientId, ":");
        String id = null;
        LayoutComponent match = null;
        while (tok.hasMoreTokens() && (match = LayoutDefinitionManager.findById(ctx, layElt, id = tok.nextToken())) != null) {
            layElt = match;
        }
        if (layElt instanceof LayoutDefinition) {
            layElt = null;
        }
        return (LayoutComponent)layElt;
    }

    private static LayoutComponent findById(FacesContext ctx, LayoutElement elt, String id) {
        LayoutElement child;
        for (LayoutElement child2 : elt.getChildLayoutElements()) {
            if (!child2.getId(ctx, null).equals(id) || !(child2 instanceof LayoutComponent)) continue;
            return (LayoutComponent)child2;
        }
        LayoutComponent comp = null;
        Iterator<LayoutElement> i$ = elt.getChildLayoutElements().iterator();
        while (i$.hasNext() && (comp = LayoutDefinitionManager.findById(ctx, child = i$.next(), id)) == null) {
        }
        return comp;
    }

    public static LayoutDefinitionManager getLayoutDefinitionManager(FacesContext ctx, String key) throws LayoutDefinitionException {
        List<String> ldms = LayoutDefinitionManager.getLayoutDefinitionManagers(ctx);
        LayoutDefinitionManager mgr = null;
        for (String className : ldms) {
            mgr = LayoutDefinitionManager.getLayoutDefinitionManager(className);
            if (!mgr.accepts(key)) continue;
            return mgr;
        }
        throw new LayoutDefinitionException("No LayoutDefinitionManager available for '" + key + "'.  This may mean the file cannot " + "be found, or is unrecognizable.");
    }

    public static List<String> getLayoutDefinitionManagers(FacesContext ctx) {
        if (_ldmKeys == null) {
            Map initParams;
            ArrayList<String> keys = new ArrayList<String>();
            String def = "";
            if (ctx != null && (initParams = ctx.getExternalContext().getInitParameterMap()).containsKey(LAYOUT_DEFINITION_MANAGER_KEY)) {
                def = ((String)initParams.get(LAYOUT_DEFINITION_MANAGER_KEY)).trim();
                keys.add(def);
            }
            try {
                BufferedReader rdr = null;
                String line = null;
                Enumeration<URL> urls = Util.getClassLoader(ctx).getResources("META-INF/jsftemplating/FormatDefinition.map");
                while (urls.hasMoreElements()) {
                    rdr = new BufferedReader(new InputStreamReader(urls.nextElement().openStream()));
                    line = rdr.readLine();
                    while (line != null) {
                        if ((line = line.trim()).equals("") || line.startsWith("#") || line.equals(def)) continue;
                        keys.add(line);
                        line = rdr.readLine();
                    }
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            _ldmKeys = keys;
        }
        return _ldmKeys;
    }

    public static LayoutDefinitionManager getLayoutDefinitionManager(String className) {
        LayoutDefinitionManager ldm = _instances.get(className);
        if (ldm == null) {
            try {
                ClassLoader loader = Util.getClassLoader(className);
                ldm = (LayoutDefinitionManager)loader.loadClass(className).getMethod("getInstance", null).invoke((Object)null, (Object[])null);
            }
            catch (ClassNotFoundException ex) {
                throw new LayoutDefinitionException("Unable to find LDM: '" + className + "'.", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new LayoutDefinitionException("LDM '" + className + "' does not have a 'getInstance()' method!", ex);
            }
            catch (IllegalAccessException ex) {
                throw new LayoutDefinitionException("Unable to access LDM: '" + className + "'!", ex);
            }
            catch (InvocationTargetException ex) {
                throw new LayoutDefinitionException("Error while attempting to get LDM: '" + className + "'!", ex);
            }
            catch (ClassCastException ex) {
                throw new LayoutDefinitionException("LDM '" + className + "' must extend from '" + LayoutDefinitionManager.class.getName() + " and must " + "be loaded from the same ClassLoader!", ex);
            }
            catch (NullPointerException ex) {
                throw new LayoutDefinitionException(ex);
            }
            _instances.put(className, ldm);
        }
        return ldm;
    }

    public static LayoutDefinition getCachedLayoutDefinition(String key) {
        if (LayoutDefinitionManager.isDebug()) {
            return null;
        }
        return _layoutDefinitions.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putCachedLayoutDefinition(String key, LayoutDefinition value) {
        Map<String, LayoutDefinition> map = _layoutDefinitions;
        synchronized (map) {
            _layoutDefinitions.put(key, value);
        }
    }

    public Object getAttribute(String key) {
        return this._attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this._attributes.put(key, value);
    }

    public static Map<String, ComponentType> getGlobalComponentTypes() {
        if (_globalComponentTypes == null) {
            HashMap<String, ComponentType> types = new HashMap<String, ComponentType>();
            try {
                Properties props = null;
                URL url = null;
                String id = null;
                Enumeration<URL> urls = Util.getClassLoader(types).getResources("META-INF/jsftemplating/UIComponentFactory.map");
                while (urls.hasMoreElements()) {
                    url = urls.nextElement();
                    props = new Properties();
                    props.load(url.openStream());
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        id = (String)entry.getKey();
                        types.put(id, new ComponentType(id, (String)entry.getValue()));
                    }
                }
                _globalComponentTypes = types;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return _globalComponentTypes;
    }

    public static ComponentType getGlobalComponentType(String typeID) {
        return LayoutDefinitionManager.getGlobalComponentTypes().get(typeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalComponentType(ComponentType type) {
        Class<LayoutDefinitionManager> clazz = LayoutDefinitionManager.class;
        synchronized (LayoutDefinitionManager.class) {
            LayoutDefinitionManager.getGlobalComponentTypes().put(type.getId(), type);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void clearGlobalComponentTypes() {
        _globalComponentTypes = null;
    }

    public static Map<String, HandlerDefinition> getGlobalHandlerDefinitions() {
        if (_globalHandlerDefs != null) {
            return _globalHandlerDefs;
        }
        _globalHandlerDefs = new HashMap<String, HandlerDefinition>();
        Properties props = null;
        URL url = null;
        try {
            Enumeration<URL> urls = Util.getClassLoader(_globalHandlerDefs).getResources("META-INF/jsftemplating/Handler.map");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                props = new Properties();
                props.load(url.openStream());
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    if (!((String)entry.getKey()).endsWith(".class")) continue;
                    LayoutDefinitionManager.readGlobalHandlerDefinition(props, entry);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return _globalHandlerDefs;
    }

    private static void readGlobalHandlerDefinition(Map<String, String> map, Map.Entry<Object, Object> entry) {
        String key = (String)entry.getKey();
        key = key.substring(0, key.lastIndexOf(46));
        HandlerDefinition def = new HandlerDefinition(key);
        String value = map.get(key + '.' + "method");
        def.setHandlerMethod((String)entry.getValue(), value);
        def.setInputDefs(LayoutDefinitionManager.readIODefs(map, key, true));
        def.setOutputDefs(LayoutDefinitionManager.readIODefs(map, key, false));
        _globalHandlerDefs.put(key, def);
    }

    private static Map<String, IODescriptor> readIODefs(Map<String, String> map, String key, boolean input) {
        String inOrOut = input ? "input" : "output";
        int count = 0;
        IODescriptor desc = null;
        HashMap<String, IODescriptor> defs = new HashMap<String, IODescriptor>(5);
        String value = map.get(key + "." + inOrOut + "[" + count + "].name");
        while (value != null) {
            String type = map.get(key + "." + inOrOut + "[" + count + "].type");
            if (type == null) {
                type = DEFAULT_TYPE;
            }
            desc = new IODescriptor(value, type);
            defs.put(value, desc);
            if (input) {
                value = map.get(key + "." + inOrOut + "[" + count + "].required");
                if (value != null && Boolean.valueOf(value).booleanValue()) {
                    desc.setRequired(true);
                }
                if ((value = map.get(key + "." + inOrOut + "[" + count + "].defaultValue")) != null && !value.equals("jsfTempNULLString")) {
                    desc.setDefault(value);
                }
            }
            value = map.get(key + "." + inOrOut + "[" + ++count + "].name");
        }
        return defs;
    }

    public static HandlerDefinition getGlobalHandlerDefinition(String id) {
        return LayoutDefinitionManager.getGlobalHandlerDefinitions().get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalHandlerDefinition(HandlerDefinition def) {
        Class<LayoutDefinitionManager> clazz = LayoutDefinitionManager.class;
        synchronized (LayoutDefinitionManager.class) {
            LayoutDefinitionManager.getGlobalHandlerDefinitions().put(def.getId(), def);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void clearGlobalHandlerDefinitions() {
        _globalHandlerDefs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalResource(Resource res) {
        Class<LayoutDefinitionManager> clazz = LayoutDefinitionManager.class;
        synchronized (LayoutDefinitionManager.class) {
            LayoutDefinitionManager.getGlobalResources().add(res);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static List<Resource> getGlobalResources() {
        if (_globalResources == null) {
            _globalResources = new ArrayList<Resource>();
        }
        return _globalResources;
    }

    public static void clearGlobalResources() {
        _globalResources = null;
    }

    public static boolean isDebug() {
        String initParam;
        FacesContext ctx;
        if (_debug != null) {
            return _debug;
        }
        boolean flag = Boolean.getBoolean(DEBUG_FLAG);
        if (!flag && (ctx = FacesContext.getCurrentInstance()) != null && (initParam = ctx.getExternalContext().getInitParameter(DEBUG_FLAG)) != null) {
            flag = Boolean.parseBoolean(initParam);
        }
        _debug = flag;
        return flag;
    }

    public static void setDebug(boolean flag) {
        _debug = flag;
    }
}

