/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.facelets;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutComposition;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.descriptors.LayoutStaticText;
import com.sun.jsftemplating.layout.facelets.ParsingErrorHandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FaceletsLayoutDefinitionReader {
    private URL url;
    private String key;
    private Document document;

    public FaceletsLayoutDefinitionReader(String key, URL url) {
        try {
            this.url = url;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(false);
            dbf.setCoalescing(false);
            dbf.setExpandEntityReferences(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            builder.setErrorHandler(new ParsingErrorHandler());
            BufferedInputStream is = new BufferedInputStream(this.url.openStream());
            this.document = builder.parse(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            throw new LayoutDefinitionException(e);
        }
    }

    public LayoutDefinition read() throws IOException {
        LayoutDefinition ld = new LayoutDefinition(this.key);
        NodeList nodeList = this.document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.process(ld, nodeList.item(i));
        }
        return ld;
    }

    public LayoutElement process(LayoutElement parent, Node node) throws IOException {
        LayoutElement element = null;
        String value = node.getNodeValue();
        if (value != null) {
            value = value.trim();
        }
        System.out.println(node.getNodeName() + ":  '" + node.getNodeType() + "' = '" + value + "'");
        switch (node.getNodeType()) {
            case 3: {
                element = new LayoutStaticText(parent, "", node.getNodeValue());
                break;
            }
            case 1: {
                element = this.createComponent(parent, node);
                break;
            }
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.process(element, nodeList.item(i));
        }
        if (parent != null) {
            parent.addChildLayoutElement(element);
        }
        return element;
    }

    private LayoutElement createComponent(LayoutElement parent, Node node) {
        LayoutElementBase element = null;
        String nodeName = node.getNodeName();
        if ("ui:composition".equals(nodeName)) {
            LayoutComposition lc = new LayoutComposition(parent, "");
            NamedNodeMap attrs = node.getAttributes();
            String template = attrs.getNamedItem("template").getNodeValue();
            lc.setTemplate(template);
            element = lc;
        } else {
            ComponentType componentType = LayoutDefinitionManager.getGlobalComponentType(nodeName);
            element = new LayoutComponent(parent, "", componentType);
        }
        return element;
    }
}

