/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util;

import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutFacet;

public class LayoutElementUtil {
    public static int MAX_ID = 65536;
    private static int _idNum = 1;
    public static final String DEFAULT_ID_BASE = "id";

    public static boolean isNestedLayoutComponent(LayoutElement elt) {
        return LayoutElementUtil.getParentLayoutComponent(elt) != null;
    }

    public static LayoutComponent getParentLayoutComponent(LayoutElement elt) {
        for (elt = elt.getParent(); elt != null; elt = elt.getParent()) {
            if (!(elt instanceof LayoutComponent)) continue;
            return (LayoutComponent)elt;
        }
        return null;
    }

    public static boolean isLayoutComponentChild(LayoutElement elt) {
        for (elt = elt.getParent(); elt != null; elt = elt.getParent()) {
            if (elt instanceof LayoutComponent) {
                if (elt.getClass().getName().equals(LayoutComponent.CLASS_NAME)) {
                    return true;
                }
                return LayoutElementUtil.isNestedLayoutComponent(elt);
            }
            if (!(elt instanceof LayoutFacet)) continue;
            return false;
        }
        return false;
    }

    public static String getGeneratedId(String base) {
        return LayoutElementUtil.getGeneratedId(base, _idNum++ % MAX_ID);
    }

    public static String getGeneratedId(String base, int num) {
        if (base == null) {
            base = DEFAULT_ID_BASE;
        } else if ((base = base.trim()).equals("")) {
            base = DEFAULT_ID_BASE;
        } else {
            StringBuffer buf = new StringBuffer();
            for (char ch : base.toCharArray()) {
                int lowch = ch | 0x20;
                if (lowch >= 97 && lowch <= 122) {
                    buf.append(ch);
                    continue;
                }
                buf.append('_');
            }
            base = buf.toString();
        }
        return base + num;
    }
}

