/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jmaki.runtime.AjaxContext;
import jmaki.runtime.AjaxException;
import jmaki.runtime.AjaxWriter;
import jmaki.runtime.IOUtil;
import jmaki.runtime.LocalizedMessage;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.WidgetPropertyHolder;
import jmaki.runtime.WidgetResourceException;
import jmaki.runtime.config.ApiKey;
import jmaki.runtime.config.Config;
import jmaki.runtime.config.GlobalConfig;

public class WidgetCommonRenderer {
    private Config widgetConfig;
    private AjaxContext ajx;
    private ResourceManager resourceManager;
    private GlobalConfig globalConfig;
    private String args;
    private String name;
    private String script;
    private String publish;
    private String subscribe;
    private String service;
    private String style;
    private String template;
    private String uuid;
    private Object value;
    private String absoluteWidgetPath;
    private boolean isWidgetWebAppResource;

    /*
     * Enabled aggressive block sorting
     */
    public void init(AjaxContext ajx, WidgetPropertyHolder widget) throws AjaxException {
        String widgetDir;
        block14: {
            block15: {
                String tmpScript;
                this.ajx = ajx;
                this.resourceManager = ajx.getResourceHandler();
                this.globalConfig = ajx.getGlobalConfig();
                this.args = widget.getArgs();
                this.publish = widget.getPublish();
                this.subscribe = widget.getSubscribe();
                this.service = widget.getService();
                this.value = widget.getValue();
                this.name = widget.getName();
                String widgetPath = this.resourceManager.getWidgetDir(this.name);
                widgetDir = null;
                this.script = widget.getScript();
                if (this.script == null) {
                    this.script = "component.js";
                }
                if (this.resourceManager.isWebAppResource(tmpScript = IOUtil.resolvePath(widgetDir = ajx.getWorkingDir() + widgetPath, this.script))) {
                    this.script = tmpScript;
                    this.isWidgetWebAppResource = true;
                } else {
                    widgetDir = this.resourceManager.getWebResourcePath() + widgetPath;
                    tmpScript = IOUtil.resolvePath(widgetDir, this.script);
                    if (this.resourceManager.isWebAppResource(tmpScript)) {
                        this.script = tmpScript;
                        this.isWidgetWebAppResource = true;
                    } else {
                        widgetDir = this.resourceManager.getResourcesDir() + widgetPath;
                        tmpScript = IOUtil.resolvePath(widgetDir, this.script);
                        if (!this.resourceManager.isClassPathResource(tmpScript)) {
                            String[] parameter = new String[]{this.script, ajx.getWorkingDir() + widgetPath + "', '" + this.resourceManager.getWebResourcePath() + widgetPath, "META-INF" + this.resourceManager.getResourcesDir() + widgetPath};
                            throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_IN", parameter));
                        }
                        this.script = tmpScript;
                        this.isWidgetWebAppResource = false;
                    }
                }
                this.uuid = widget.getUuid();
                if (this.uuid == null) {
                    this.uuid = this.name + "" + ajx.getUniqueId();
                    this.uuid = this.uuid.replace('.', '_');
                }
                if ((this.style = widget.getStyle()) == null) {
                    String stylePath = widgetDir + "/component.css";
                    if (this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(stylePath) : this.resourceManager.isClassPathResource(stylePath)) {
                        this.style = stylePath;
                    }
                } else {
                    this.style = IOUtil.resolvePath(widgetDir, this.style);
                }
                this.template = widget.getTemplate();
                if (this.template != null) break block15;
                String templatePath = widgetDir + "/component.htm";
                if (this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(templatePath) : this.resourceManager.isClassPathResource(templatePath)) {
                    this.template = templatePath;
                    break block14;
                } else {
                    templatePath = templatePath + "l";
                    if (this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(templatePath) : this.resourceManager.isClassPathResource(templatePath)) {
                        this.template = templatePath;
                        break block14;
                    } else {
                        String[] parameter = new String[]{templatePath, this.name};
                        throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_FOR_WIDGET", parameter));
                    }
                }
            }
            this.template = IOUtil.resolvePath(widgetDir, this.template);
        }
        this.widgetConfig = this.globalConfig.getConfig(this.name, widgetDir);
        this.absoluteWidgetPath = this.isWidgetWebAppResource ? ajx.buildWebAppResourceReference(widgetDir) : ajx.buildClassPathResourceReference(widgetDir);
        AjaxContext.getLogger().finest("uuid: '" + this.uuid + "', widgettype: '" + this.name + "', widgetdir: '" + widgetDir + "', absoluteWidgetPath: '" + this.absoluteWidgetPath + "', template: '" + this.template + "', style: '" + this.style + "', script: '" + this.script);
    }

    public void writeResources(AjaxWriter out) throws IOException {
        String widgetId = this.widgetConfig.getId();
        if (widgetId != null && !this.ajx.isTypeWritten(widgetId)) {
            this.writeTypeLibs(out);
            this.writeTypeStyles(out);
            this.ajx.setTypeWritten(widgetId);
        }
        this.writeStyle(out);
        this.writeScript(out);
        this.writeAddWidget(out);
    }

    public void writeMarkup(AjaxWriter out) throws IOException {
        this.writeTemplate(out);
    }

    private void writeTypeLibs(AjaxWriter out) throws IOException {
        String preload = null;
        preload = this.widgetConfig.getPreLoad();
        if (preload != null) {
            out.writeScript(preload);
        }
        Iterator libs = this.widgetConfig.getLibs();
        while (libs.hasNext()) {
            String lib = (String)libs.next();
            Iterator apiKeys = this.widgetConfig.getApiKeys();
            while (apiKeys.hasNext()) {
                ApiKey apiKey = (ApiKey)apiKeys.next();
                String targetURL = apiKey.getUrl();
                if ((targetURL == null || !targetURL.equals(this.ajx.getWebRoot() + "/")) && !targetURL.equals(this.ajx.getGlobalWebRoot() + "/") && !targetURL.equals("*")) continue;
                lib = lib + apiKey.getKey();
                break;
            }
            if (this.ajx.isLibraryWritten(lib)) continue;
            if (this.widgetConfig.isDynamicallyLoadable()) {
                out.writeLib(this.ajx.buildResourceReference(lib));
            } else {
                out.writeScript("jmaki.writeScript('" + this.ajx.buildResourceReference(lib) + "', '" + this.uuid + "');");
            }
            this.ajx.setLibraryWritten(lib);
        }
        String postload = null;
        postload = this.widgetConfig.getPostLoad();
        if (postload != null) {
            out.writeScript(postload);
        }
    }

    private void writeTypeStyles(AjaxWriter out) throws IOException {
        if (this.widgetConfig.getThemes() != null) {
            Map themes = this.widgetConfig.getThemes();
            String key = this.widgetConfig.getGlobalTheme();
            String defaultTheme = this.widgetConfig.getDefaultTheme();
            String theme = null;
            if (themes.get(key) != null) {
                theme = (String)themes.get(key);
            } else if (defaultTheme != null) {
                theme = (String)themes.get(defaultTheme);
            }
            if (theme != null && !this.ajx.isStyleWritten(theme)) {
                out.writeStyle(this.ajx.buildResourceReference(theme));
                this.ajx.setStyleWritten(theme);
            }
        }
        Iterator styles = this.widgetConfig.getStyles();
        while (styles.hasNext()) {
            String style = (String)styles.next();
            if (this.ajx.isStyleWritten(style)) continue;
            out.writeStyle(this.ajx.buildResourceReference(style));
            this.ajx.setStyleWritten(style);
        }
    }

    private void writeStyle(AjaxWriter out) throws IOException {
        if (this.style != null && !this.ajx.isStyleWritten(this.style)) {
            out.writeStyle(this.ajx.buildResourceReference(this.style, this.isWidgetWebAppResource));
            this.ajx.setStyleWritten(this.style);
        }
    }

    private void writeScript(AjaxWriter out) throws IOException {
        if (!this.ajx.isLibraryWritten(this.script)) {
            out.writeLib(this.ajx.buildResourceReference(this.script, this.isWidgetWebAppResource));
            this.ajx.setLibraryWritten(this.script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAddWidget(AjaxWriter out) throws IOException {
        HashMap<String, Object> widgetProperties = new HashMap<String, Object>();
        try {
            widgetProperties.put("uuid", this.uuid);
            widgetProperties.put("name", this.name);
            widgetProperties.put("sourceURL", this.ajx.getSourceURL());
            widgetProperties.put("widgetDir", this.absoluteWidgetPath);
            if (this.service != null) {
                widgetProperties.put("service", this.service);
            }
            if (this.publish != null) {
                widgetProperties.put("publish", this.publish);
            }
            if (this.subscribe != null) {
                widgetProperties.put("subscribe", this.subscribe);
            }
            if (this.value != null) {
                widgetProperties.put("value", this.value);
            }
            if (this.args != null) {
                widgetProperties.put("args", this.args);
            }
            out.writeScript("jmaki.addWidget(" + IOUtil.createJavaScriptObject(widgetProperties) + ");");
        }
        finally {
            widgetProperties.clear();
        }
    }

    private void writeTemplate(AjaxWriter out) throws IOException {
        URL templateURL = this.isWidgetWebAppResource ? this.resourceManager.locateWebAppResource(this.template) : this.resourceManager.locateClassPathResource(this.template);
        StringBuffer templateBuffer = null;
        try {
            templateBuffer = IOUtil.loadResource(templateURL.openStream(), "UTF-8");
        }
        catch (Exception ioe) {
            String[] parameter = new String[]{this.template, this.name};
            throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_FOR_WIDGET", parameter), (Throwable)ioe);
        }
        IOUtil.replace(templateBuffer, "${uuid}", this.uuid);
        if (this.service != null) {
            IOUtil.replace(templateBuffer, "${service}", this.service);
        }
        if (this.args != null) {
            IOUtil.replace(templateBuffer, "${args}", this.args);
        }
        if (this.value != null && this.value instanceof String) {
            if (((String)this.value).startsWith("@{")) {
                IOUtil.replace(templateBuffer, "${value}", "");
            } else {
                IOUtil.replace(templateBuffer, "${value}", this.value.toString());
            }
        }
        IOUtil.replace(templateBuffer, "${webRoot}", this.ajx.getGlobalWebRoot());
        IOUtil.replace(templateBuffer, "${widgetDir}", this.absoluteWidgetPath);
        IOUtil.replace(templateBuffer, "${contextPath}", this.ajx.getRequest().getContextPath());
        out.write(templateBuffer.toString());
    }

    public void cleanup() {
        this.widgetConfig = null;
        this.ajx = null;
        this.resourceManager = null;
        this.globalConfig = null;
        this.args = null;
        this.name = null;
        this.publish = null;
        this.script = null;
        this.subscribe = null;
        this.service = null;
        this.style = null;
        this.template = null;
        this.value = null;
        this.uuid = null;
        this.absoluteWidgetPath = null;
    }
}

