/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.transaction.base;

import oracle.toplink.essentials.exceptions.TransactionException;
import oracle.toplink.essentials.internal.ejb.cmp3.base.EntityManagerImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.base.RepeatableWriteUnitOfWork;
import oracle.toplink.essentials.internal.ejb.cmp3.transaction.base.TransactionWrapperImpl;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.transaction.AbstractTransactionController;

public class JTATransactionWrapper
extends TransactionWrapperImpl {
    protected AbstractTransactionController txnController;

    public JTATransactionWrapper(EntityManagerImpl entityManager) {
        super(entityManager);
        this.txnController = (AbstractTransactionController)entityManager.getServerSession().getExternalTransactionController();
    }

    public Object checkForTransaction(boolean validateExistence) {
        Object transaction = this.txnController.getTransaction();
        if (validateExistence && transaction == null) {
            this.throwCheckTransactionFailedException();
        }
        return transaction;
    }

    public void clear() {
        if (this.txnKey != null && this.entityManager.shouldPropagatePersistenceContext()) {
            this.txnController.getUnitsOfWork().remove(this.txnKey);
        }
        this.localUOW.release();
        this.localUOW = null;
    }

    public void setRollbackOnlyInternal() {
        if (this.txnController.getTransaction() != null) {
            this.txnController.markTransactionForRollback();
        }
    }

    public RepeatableWriteUnitOfWork getTransactionalUnitOfWork(Object transaction) {
        if (transaction == null) {
            return null;
        }
        if (this.entityManager.shouldPropagatePersistenceContext()) {
            Object newTxnKey = this.txnController.getTransactionKey(transaction);
            if (this.txnKey == newTxnKey) {
                return this.localUOW;
            }
            this.txnKey = newTxnKey;
            this.localUOW = (RepeatableWriteUnitOfWork)this.txnController.lookupActiveUnitOfWork(transaction);
            if (this.localUOW == null) {
                this.localUOW = new RepeatableWriteUnitOfWork(this.entityManager.getServerSession().acquireClientSession());
                this.localUOW.registerWithTransactionIfRequired();
                this.localUOW.setShouldCascadeCloneToJoinedRelationship(true);
                this.txnController.getUnitsOfWork().put(newTxnKey, this.localUOW);
            }
        } else if (this.localUOW == null) {
            this.localUOW = new RepeatableWriteUnitOfWork(this.entityManager.getServerSession().acquireClientSession());
            this.localUOW.registerWithTransactionIfRequired();
            this.localUOW.setShouldCascadeCloneToJoinedRelationship(true);
        }
        return this.localUOW;
    }

    protected void throwUserTransactionException() {
        throw TransactionException.entityTransactionWithJTANotAllowed();
    }

    protected void throwCheckTransactionFailedException() {
        throw TransactionException.externalTransactionNotActive();
    }

    public void registerUnitOfWorkWithTxn(UnitOfWorkImpl uow) {
        uow.registerWithTransactionIfRequired();
    }

    public boolean shouldFlushBeforeQuery(UnitOfWorkImpl uow) {
        return uow.isSynchronized();
    }
}

