/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.client;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureRecoveryAction;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FailureRecoveryActionImpl
implements FailureRecoveryAction {
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private CallBack caller;

    public FailureRecoveryActionImpl(CallBack caller) {
        this.caller = caller;
    }

    public void consumeSignal(Signal signal) {
        try {
            signal.acquire();
            String component = ((FailureRecoverySignal)signal).getComponentName();
            this.logger.log(Level.FINE, component + ":Failure Recovery Signal acquired");
            this.notifyListeners(signal);
            signal.release();
            this.logger.log(Level.FINE, component + ":Failure Recovery Signal released");
        }
        catch (SignalAcquireException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        catch (SignalReleaseException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void notifyListeners(Signal signal) {
        this.caller.processNotification(signal);
    }
}

