/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.Action;
import com.sun.enterprise.ee.cms.core.ActionException;
import com.sun.enterprise.ee.cms.core.FailureNotificationAction;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoveryAction;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedAction;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedSignal;
import com.sun.enterprise.ee.cms.core.JoinNotificationAction;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageAction;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownAction;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.common.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureRecoverySignalImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureSuspectedSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.JoinNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.PlannedShutdownSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.SignalHandler;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router {
    private final Vector<FailureNotificationActionFactory> failureNotificationAF = new Vector();
    private final Hashtable<String, FailureRecoveryActionFactory> failureRecoveryAF = new Hashtable();
    private final Hashtable<String, MessageActionFactory> messageAF = new Hashtable();
    private final Vector<PlannedShutdownActionFactory> plannedShutdownAF = new Vector();
    private final Vector<JoinNotificationActionFactory> joinNotificationAF = new Vector();
    private final Vector<FailureSuspectedActionFactory> failureSuspectedAF = new Vector();
    private final BlockingQueue<SignalPacket> queue;
    private final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private final ExecutorService actionPool;
    private long startupTime;
    private static final int GROUP_WARMUP_TIME = 30000;
    private static final int BUFSIZE = 100;

    public Router() {
        this.queue = new ArrayBlockingQueue<SignalPacket>(100);
        SignalHandler signalHandler = new SignalHandler(this.queue, this);
        new Thread((Runnable)signalHandler, this.getClass().getCanonicalName() + " Thread").start();
        this.actionPool = Executors.newCachedThreadPool();
        this.startupTime = System.currentTimeMillis();
    }

    void addDestination(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.failureNotificationAF.add(failureNotificationActionFactory);
    }

    void addDestination(String componentName, FailureRecoveryActionFactory failureRecoveryActionFactory) {
        this.failureRecoveryAF.put(componentName, failureRecoveryActionFactory);
    }

    void addDestination(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.joinNotificationAF.add(joinNotificationActionFactory);
    }

    void addDestination(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.plannedShutdownAF.add(plannedShutdownActionFactory);
    }

    void addDestination(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.failureSuspectedAF.add(failureSuspectedActionFactory);
    }

    void addDestination(MessageActionFactory messageActionFactory, String componentName) {
        this.messageAF.put(componentName, messageActionFactory);
    }

    void removeDestination(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.failureNotificationAF.remove(failureNotificationActionFactory);
    }

    void removeDestination(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.joinNotificationAF.remove(joinNotificationActionFactory);
    }

    void removeDestination(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.plannedShutdownAF.remove(plannedShutdownActionFactory);
    }

    void removeDestination(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.failureSuspectedAF.remove(failureSuspectedActionFactory);
    }

    public void removeMessageAFDestination(String componentName) {
        this.messageAF.remove(componentName);
    }

    public void removeFailureRecoveryAFDestination(String componentName) {
        this.messageAF.remove(componentName);
    }

    public void queueSignals(SignalPacket signalPacket) {
        try {
            this.queue.put(signalPacket);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, e.getMessage());
            e.printStackTrace();
        }
    }

    public void queueSignal(SignalPacket signalPacket) {
        try {
            this.queue.put(signalPacket);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undocketAllDestinations() {
        Cloneable cloneable = this.failureRecoveryAF;
        synchronized (cloneable) {
            this.failureRecoveryAF.clear();
        }
        cloneable = this.failureNotificationAF;
        synchronized (cloneable) {
            this.failureNotificationAF.removeAllElements();
        }
        cloneable = this.plannedShutdownAF;
        synchronized (cloneable) {
            this.plannedShutdownAF.removeAllElements();
        }
        cloneable = this.joinNotificationAF;
        synchronized (cloneable) {
            this.joinNotificationAF.removeAllElements();
        }
        cloneable = this.messageAF;
        synchronized (cloneable) {
            this.messageAF.clear();
        }
        cloneable = this.failureSuspectedAF;
        synchronized (cloneable) {
            this.failureSuspectedAF.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFailureNotificationAction(FailureNotificationSignal signal) {
        this.logger.log(Level.INFO, "failurenotificationsignals.send.member", new Object[]{signal.getMemberToken()});
        Vector<FailureNotificationActionFactory> vector = this.failureNotificationAF;
        synchronized (vector) {
            for (FailureNotificationActionFactory fnaf : this.failureNotificationAF) {
                FailureNotificationAction a = (FailureNotificationAction)fnaf.produceAction();
                FailureNotificationSignalImpl fns = new FailureNotificationSignalImpl(signal);
                this.callAction(a, fns);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFailureRecoveryAction(FailureRecoverySignal signal) {
        this.logger.log(Level.INFO, "failurenotificationsignals.send.component", new Object[]{signal.getComponentName()});
        Hashtable<String, FailureRecoveryActionFactory> hashtable = this.failureRecoveryAF;
        synchronized (hashtable) {
            FailureRecoveryActionFactory fraf = this.failureRecoveryAF.get(signal.getComponentName());
            FailureRecoveryAction a = (FailureRecoveryAction)fraf.produceAction();
            FailureRecoverySignalImpl frs = new FailureRecoverySignalImpl(signal);
            this.callAction(a, frs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFailureSuspectedAction(FailureSuspectedSignal signal) {
        this.logger.log(Level.INFO, "failuresuspectedsignals.send.member", new Object[]{signal.getMemberToken()});
        Vector<FailureSuspectedActionFactory> vector = this.failureSuspectedAF;
        synchronized (vector) {
            for (FailureSuspectedActionFactory fsaf : this.failureSuspectedAF) {
                FailureSuspectedAction a = (FailureSuspectedAction)fsaf.produceAction();
                FailureSuspectedSignalImpl fss = new FailureSuspectedSignalImpl(signal);
                this.callAction(a, fss);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyMessageAction(MessageSignal signal) {
        Hashtable<String, MessageActionFactory> hashtable = this.messageAF;
        synchronized (hashtable) {
            Enumeration<String> i = this.messageAF.keys();
            while (i.hasMoreElements()) {
                String target = i.nextElement();
                if (!target.equals(signal.getTargetComponent())) continue;
                MessageActionFactory maf = this.messageAF.get(target);
                MessageAction a = (MessageAction)maf.produceAction();
                try {
                    a.consumeSignal(signal);
                }
                catch (ActionException e) {
                    this.logger.log(Level.WARNING, "action.exception", new Object[]{e.getLocalizedMessage()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyJoinNotificationAction(JoinNotificationSignal signal) {
        if (this.isJoinNotificationAFRegistered()) {
            this.logger.log(Level.FINE, MessageFormat.format("Sending JoinNotificationSignals to registered Actions, Member {0}...", signal.getMemberToken()));
            Vector<JoinNotificationActionFactory> vector = this.joinNotificationAF;
            synchronized (vector) {
                for (JoinNotificationActionFactory jnaf : this.joinNotificationAF) {
                    JoinNotificationAction a = (JoinNotificationAction)jnaf.produceAction();
                    JoinNotificationSignalImpl jns = new JoinNotificationSignalImpl(signal);
                    this.callAction(a, jns);
                }
            }
        }
        if (System.currentTimeMillis() - this.startupTime < 30000L) {
            try {
                this.queue.put(new SignalPacket(signal));
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPlannedShutdownAction(PlannedShutdownSignal signal) {
        this.logger.log(Level.INFO, "plannedshutdownsignals.send.member", new Object[]{signal.getEventSubType(), signal.getMemberToken()});
        Vector<PlannedShutdownActionFactory> vector = this.plannedShutdownAF;
        synchronized (vector) {
            for (PlannedShutdownActionFactory psaf : this.plannedShutdownAF) {
                PlannedShutdownAction a = (PlannedShutdownAction)psaf.produceAction();
                PlannedShutdownSignalImpl pss = new PlannedShutdownSignalImpl(signal);
                this.callAction(a, pss);
            }
        }
    }

    private void callAction(Action a, Signal signal) {
        try {
            CallableAction task = new CallableAction(a, signal);
            this.actionPool.submit(task);
        }
        catch (RejectedExecutionException e) {
            this.logger.log(Level.WARNING, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailureNotificationAFRegistered() {
        boolean retval = true;
        Vector<FailureNotificationActionFactory> vector = this.failureNotificationAF;
        synchronized (vector) {
            if (this.failureNotificationAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailureRecoveryAFRegistered() {
        boolean retval = true;
        Hashtable<String, FailureRecoveryActionFactory> hashtable = this.failureRecoveryAF;
        synchronized (hashtable) {
            if (this.failureRecoveryAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessageAFRegistered() {
        boolean retval = true;
        Hashtable<String, MessageActionFactory> hashtable = this.messageAF;
        synchronized (hashtable) {
            if (this.messageAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlannedShutdownAFRegistered() {
        boolean retval = true;
        Vector<PlannedShutdownActionFactory> vector = this.plannedShutdownAF;
        synchronized (vector) {
            if (this.plannedShutdownAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoinNotificationAFRegistered() {
        boolean retval = true;
        Vector<JoinNotificationActionFactory> vector = this.joinNotificationAF;
        synchronized (vector) {
            if (this.joinNotificationAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailureSuspectedAFRegistered() {
        boolean retval = true;
        Vector<FailureSuspectedActionFactory> vector = this.failureSuspectedAF;
        synchronized (vector) {
            if (this.failureSuspectedAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    Hashtable<String, FailureRecoveryActionFactory> getFailureRecoveryAFRegistrations() {
        return new Hashtable<String, FailureRecoveryActionFactory>(this.failureRecoveryAF);
    }

    public Set<String> getFailureRecoveryComponents() {
        this.logger.log(Level.FINEST, MessageFormat.format("Router Returning failure recovery components={0}", this.failureRecoveryAF.keySet()));
        return this.failureRecoveryAF.keySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallableAction
    implements Callable<Object> {
        private Action action;
        private Signal signal;

        CallableAction(Action action, Signal signal) {
            this.action = action;
            this.signal = signal;
        }

        @Override
        public Object call() throws ActionException {
            this.action.consumeSignal(this.signal);
            return null;
        }
    }
}

