/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.jxta;

import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.jxta.EventPacket;
import com.sun.enterprise.ee.cms.impl.jxta.GMSContext;
import com.sun.enterprise.ee.cms.impl.jxta.MessagePacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.GMSMessage;
import com.sun.enterprise.ee.cms.spi.GroupCommunicationProvider;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import com.sun.enterprise.jxtamgmt.ClusterManager;
import com.sun.enterprise.jxtamgmt.ClusterMessageListener;
import com.sun.enterprise.jxtamgmt.ClusterView;
import com.sun.enterprise.jxtamgmt.ClusterViewEvent;
import com.sun.enterprise.jxtamgmt.ClusterViewEventListener;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.id.ID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupCommunicationProviderImpl
implements GroupCommunicationProvider,
ClusterViewEventListener,
ClusterMessageListener {
    private ClusterManager clusterManager;
    private String certPass;
    private final String groupName;
    private GMSContext ctx;
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");

    public GroupCommunicationProviderImpl(String groupName) {
        this.groupName = groupName;
        System.setProperty("JXTA_MGMT_LOGGER", this.logger.getName());
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = (GMSContext)GMSContextFactory.getGMSContext(this.groupName);
        }
        return this.ctx;
    }

    @Override
    public void clusterViewEvent(ClusterViewEvent clusterViewEvent, ClusterView clusterView) {
        if (!this.getGMSContext().isShuttingDown()) {
            this.logger.log(Level.FINER, "Received Cluster View Event...");
            this.logger.log(Level.FINER, clusterView.getView().toString());
            EventPacket ePacket = new EventPacket(clusterViewEvent.getEvent(), clusterViewEvent.getAdvertisement(), clusterView);
            ArrayBlockingQueue<EventPacket> viewQueue = this.getGMSContext().getViewQueue();
            try {
                viewQueue.put(ePacket);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "interruptedexception.occurred", new Object[]{e.getLocalizedMessage()});
            }
        }
    }

    @Override
    public void initializeGroupCommunicationProvider(String memberName, String groupName, Map<String, String> identityMap, Map configProperties) {
        ArrayList<ClusterViewEventListener> cvListeners = new ArrayList<ClusterViewEventListener>();
        cvListeners.add(this);
        ArrayList<ClusterMessageListener> cmListeners = new ArrayList<ClusterMessageListener>();
        cmListeners.add(this);
        this.clusterManager = new ClusterManager(groupName, memberName, identityMap, configProperties, cvListeners, cmListeners);
    }

    @Override
    public void join() {
        this.logger.log(Level.FINE, "starting.cluster");
        this.clusterManager.start();
    }

    @Override
    public void announceClusterShutdown(GMSMessage gmsMessage) {
        try {
            this.clusterManager.send(null, gmsMessage);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "ioexception.occurred.cluster.shutdown", new Object[]{e});
        }
    }

    @Override
    public void leave(boolean isClusterShutdown) {
        this.clusterManager.stop(isClusterShutdown);
    }

    @Override
    public void sendMessage(String targetMemberIdentityToken, Serializable message, boolean synchronous) throws GMSException {
        try {
            if (targetMemberIdentityToken == null) {
                this.clusterManager.send(null, message);
            } else {
                ID id = this.clusterManager.getID(targetMemberIdentityToken);
                this.logger.log(Level.FINER, "sending message to PeerID: " + id);
                this.clusterManager.send(id, message);
            }
        }
        catch (IOException e) {
            throw new GMSException(e);
        }
    }

    @Override
    public void sendMessage(Serializable message) throws GMSException {
        this.sendMessage(null, message, false);
    }

    public Object getLocalAddress() {
        return this.clusterManager.getSystemAdvertisement().getID();
    }

    @Override
    public List<String> getMembers() {
        return this.clusterManager.getClusterViewManager().getLocalView().getPeerNamesInView();
    }

    @Override
    public boolean isGroupLeader() {
        return this.clusterManager.isMaster();
    }

    @Override
    public MemberStates getMemberState(String memberIdentityToken) {
        return MemberStates.valueOf(this.clusterManager.getNodeState(this.clusterManager.getID(memberIdentityToken)).toUpperCase());
    }

    @Override
    public String getGroupLeader() {
        return this.clusterManager.getClusterViewManager().getMaster().getName();
    }

    @Override
    public void handleClusterMessage(SystemAdvertisement adv, Object message) {
        try {
            this.logger.log(Level.FINER, "Received AppMessage Notification, placing in message queue");
            this.getGMSContext().getMessageQueue().put(new MessagePacket(adv, message));
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, MessageFormat.format("Interrupted Exception occured while adding message to Shoal MessageQueue :{0}", e.getLocalizedMessage()));
        }
    }
}

