/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.ClusterMessageListener;
import com.sun.enterprise.jxtamgmt.ClusterView;
import com.sun.enterprise.jxtamgmt.ClusterViewEvent;
import com.sun.enterprise.jxtamgmt.ClusterViewEventListener;
import com.sun.enterprise.jxtamgmt.ClusterViewManager;
import com.sun.enterprise.jxtamgmt.HealthMonitor;
import com.sun.enterprise.jxtamgmt.JxtaConfigConstants;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import com.sun.enterprise.jxtamgmt.MasterNode;
import com.sun.enterprise.jxtamgmt.NetworkManager;
import com.sun.enterprise.jxtamgmt.NetworkManagerRegistry;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterManager
implements PipeMsgListener {
    private static final Logger LOG = JxtaUtil.getLogger(ClusterManager.class.getName());
    private MasterNode masterNode = null;
    private ClusterViewManager clusterViewManager = null;
    private HealthMonitor healthMonitor = null;
    private NetworkManager netManager = null;
    private String groupName = null;
    private String instanceName = null;
    private volatile boolean started = false;
    private volatile boolean stopped = true;
    private boolean loopbackMessages = false;
    private final String closeLock = new String("closeLock");
    private SystemAdvertisement systemAdv = null;
    private static final String NODEADV = "NAD";
    private transient Map<String, String> identityMap;
    private PipeAdvertisement pipeAdv;
    private PipeService pipeService;
    private MessageElement sysAdvElement = null;
    private InputPipe inputPipe;
    private OutputPipe outputPipe;
    private static final String NAMESPACE = "CLUSTER_MANAGER";
    private PeerID myID;
    private static final String APPMESSAGE = "APPMESSAGE";
    private List<ClusterMessageListener> cmListeners;
    private volatile boolean stopping = false;
    private transient Map<ID, OutputPipe> pipeCache = new Hashtable<ID, OutputPipe>();

    public ClusterManager(String groupName, String instanceName, Map<String, String> identityMap, Map props, List<ClusterViewEventListener> viewListeners, List<ClusterMessageListener> messageListeners) {
        this.groupName = groupName;
        this.instanceName = instanceName;
        this.loopbackMessages = this.isLoopBackEnabled(props);
        this.netManager = new NetworkManager(groupName, instanceName, props);
        this.identityMap = identityMap;
        try {
            this.netManager.start();
        }
        catch (PeerGroupException pge) {
            LOG.log(Level.SEVERE, pge.getLocalizedMessage());
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, ioe.getLocalizedMessage());
        }
        NetworkManagerRegistry.add(groupName, this.netManager);
        this.systemAdv = ClusterManager.createSystemAdv(this.netManager.getNetPeerGroup(), instanceName, identityMap);
        LOG.log(Level.FINER, "Instance ID :" + this.getSystemAdvertisement().getID());
        this.clusterViewManager = new ClusterViewManager(this.getSystemAdvertisement(), this, viewListeners);
        this.masterNode = new MasterNode(this, this.getDiscoveryTimeout(props), 1);
        this.healthMonitor = new HealthMonitor(this, this.getFailureDetectionTimeout(props), this.getFailureDetectionRetries(props), this.getVerifyFailureTimeout(props));
        this.pipeService = this.netManager.getNetPeerGroup().getPipeService();
        this.myID = this.netManager.getNetPeerGroup().getPeerID();
        try {
            this.pipeAdv = this.createPipeAdv();
            this.outputPipe = this.pipeService.createOutputPipe(this.pipeAdv, 100L);
        }
        catch (IOException io) {
            LOG.log(Level.FINE, "Failed to create master outputPipe", io);
        }
        this.cmListeners = messageListeners;
        this.sysAdvElement = new TextDocumentMessageElement(NODEADV, (TextDocument)((XMLDocument)this.getSystemAdvertisement().getDocument(MimeMediaType.XMLUTF8)), null);
    }

    private boolean isLoopBackEnabled(Map props) {
        Object lp;
        boolean loopback = false;
        if (props != null && !props.isEmpty() && (lp = props.get(JxtaConfigConstants.LOOPBACK.toString())) != null) {
            loopback = Boolean.parseBoolean((String)lp);
        }
        return loopback;
    }

    private long getDiscoveryTimeout(Map props) {
        Object dt;
        long discTimeout = 5000L;
        if (props != null && !props.isEmpty() && (dt = props.get(JxtaConfigConstants.DISCOVERY_TIMEOUT.toString())) != null) {
            discTimeout = Long.parseLong((String)dt);
        }
        return discTimeout;
    }

    private long getFailureDetectionTimeout(Map props) {
        Object ft;
        long failTimeout = 3000L;
        if (props != null && !props.isEmpty() && (ft = props.get(JxtaConfigConstants.FAILURE_DETECTION_TIMEOUT.toString())) != null) {
            failTimeout = Long.parseLong((String)ft);
        }
        return failTimeout;
    }

    private int getFailureDetectionRetries(Map props) {
        Object fr;
        int failRetry = 3;
        if (props != null && !props.isEmpty() && (fr = props.get(JxtaConfigConstants.FAILURE_DETECTION_RETRIES.toString())) != null) {
            failRetry = Integer.parseInt((String)fr);
        }
        return failRetry;
    }

    private long getVerifyFailureTimeout(Map props) {
        Object vt;
        long verifyTimeout = 2000L;
        if (props != null && !props.isEmpty() && (vt = props.get(JxtaConfigConstants.FAILURE_VERIFICATION_TIMEOUT.toString())) != null) {
            verifyTimeout = Long.parseLong((String)vt);
        }
        return verifyTimeout;
    }

    public void addClusteMessageListener(ClusterMessageListener listener) {
        this.cmListeners.add(listener);
    }

    public void removeClusterViewEventListener(ClusterMessageListener listener) {
        this.cmListeners.remove(listener);
    }

    public static void main(String[] argv) {
        JxtaUtil.setupLogHandler();
        LOG.setLevel(Level.FINEST);
        String name = System.getProperty("INAME", "instanceName");
        String groupName = System.getProperty("GNAME", "groupName");
        LOG.log(Level.FINER, "Instance Name :" + name);
        Map props = ClusterManager.getPropsForTest();
        Map<String, String> idMap = ClusterManager.getIdMap();
        ArrayList<ClusterViewEventListener> vListeners = new ArrayList<ClusterViewEventListener>();
        ArrayList<ClusterMessageListener> mListeners = new ArrayList<ClusterMessageListener>();
        vListeners.add(new ClusterViewEventListener(){

            public void clusterViewEvent(ClusterViewEvent event, ClusterView view) {
                LOG.log(Level.INFO, "event.message", new Object[]{event.getEvent().toString()});
                LOG.log(Level.INFO, "peer.involved", new Object[]{event.getAdvertisement().toString()});
                LOG.log(Level.INFO, "view.message", new Object[]{view.getPeerNamesInView().toString()});
            }
        });
        mListeners.add(new ClusterMessageListener(){

            public void handleClusterMessage(SystemAdvertisement id, Object message) {
                LOG.log(Level.INFO, id.getName());
                LOG.log(Level.INFO, message.toString());
            }
        });
        ClusterManager manager = new ClusterManager(groupName, name, idMap, props, vListeners, mListeners);
        manager.start();
        manager.waitForClose();
    }

    private static Map<String, String> getIdMap() {
        return new HashMap<String, String>();
    }

    private static Map getPropsForTest() {
        return new HashMap();
    }

    public void announceStop(boolean isClusterShutdown) {
        this.stopping = true;
        this.healthMonitor.announceStop(isClusterShutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(boolean isClusterShutdown) {
        if (!this.stopped) {
            this.announceStop(isClusterShutdown);
            this.outputPipe.close();
            this.inputPipe.close();
            this.pipeCache.clear();
            this.healthMonitor.stop();
            this.masterNode.stop();
            this.netManager.stop();
            NetworkManagerRegistry.remove(this.groupName);
            this.stopped = true;
            String string = this.closeLock;
            synchronized (string) {
                this.closeLock.notify();
            }
        }
    }

    public synchronized void start() {
        if (!this.started) {
            this.masterNode.start();
            this.healthMonitor.start();
            this.started = true;
            this.stopped = false;
            try {
                this.inputPipe = this.pipeService.createInputPipe(this.pipeAdv, (PipeMsgListener)this);
            }
            catch (IOException ioe) {
                LOG.log(Level.SEVERE, "Failed to create service input pipe: " + ioe);
            }
        }
    }

    public NetworkManager getNetworkManager() {
        return this.netManager;
    }

    public MasterNode getMasterNode() {
        return this.masterNode;
    }

    public HealthMonitor getHealthMonitor() {
        return this.healthMonitor;
    }

    public ClusterViewManager getClusterViewManager() {
        return this.clusterViewManager;
    }

    public PeerGroup getNetPeerGroup() {
        return this.netManager.getNetPeerGroup();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean isMaster() {
        return this.clusterViewManager.isMaster() && this.masterNode.isMasterAssigned();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForClose() {
        try {
            LOG.log(Level.FINER, "Waiting for close");
            String string = this.closeLock;
            synchronized (string) {
                this.closeLock.wait();
            }
            this.stop(false);
            LOG.log(Level.FINER, "Good Bye");
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    public void send(ID peerid, Serializable msg) throws IOException {
        if (!this.stopping) {
            Message message = new Message();
            message.addMessageElement(NAMESPACE, this.sysAdvElement);
            ByteArrayMessageElement bame = new ByteArrayMessageElement(APPMESSAGE, MimeMediaType.AOS, JxtaUtil.createByteArrayFromObject(msg), null);
            message.addMessageElement(NAMESPACE, (MessageElement)bame);
            if (peerid != null) {
                OutputPipe output;
                if (!this.pipeCache.containsKey(peerid)) {
                    output = this.pipeService.createOutputPipe(this.pipeAdv, Collections.singleton(peerid), 1L);
                    this.pipeCache.put(peerid, output);
                } else {
                    output = this.pipeCache.get(peerid);
                    if (output.isClosed()) {
                        output = this.pipeService.createOutputPipe(this.pipeAdv, Collections.singleton(peerid), 1L);
                        this.pipeCache.put(peerid, output);
                    }
                }
                output.send(message);
            } else {
                LOG.log(Level.FINER, "Broadcasting Message");
                this.outputPipe.send(message);
            }
        }
    }

    private PipeAdvertisement createPipeAdv() {
        PipeAdvertisement pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        pipeAdv.setPipeID((ID)this.getNetworkManager().getAppServicePipeID());
        pipeAdv.setType("JxtaPropagate");
        return pipeAdv;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        if (this.started && !this.stopping) {
            try {
                Object appMessage;
                Message msg = event.getMessage();
                if (msg == null) {
                    LOG.log(Level.WARNING, "Received a null message");
                    return;
                }
                LOG.log(Level.FINEST, "ClusterManager:Received a AppMessage ");
                MessageElement msgElement = msg.getMessageElement(NAMESPACE, NODEADV);
                if (msgElement == null) {
                    LOG.log(Level.WARNING, "Received an unknown message");
                    return;
                }
                StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument((MimeMediaType)msgElement.getMimeType(), (InputStream)msgElement.getStream());
                SystemAdvertisement adv = new SystemAdvertisement((Element)asDoc);
                PeerID srcPeerID = (PeerID)adv.getID();
                if (!this.loopbackMessages && srcPeerID.equals(this.myID)) {
                    LOG.log(Level.FINEST, "CLUSTERMANAGER:Discarding loopback message");
                    return;
                }
                msgElement = msg.getMessageElement(NAMESPACE, APPMESSAGE);
                if (msgElement != null && (appMessage = JxtaUtil.getObjectFromByteArray(msgElement)) != null) {
                    LOG.log(Level.FINEST, "ClusterManager: Notifying APPMessage Listeners");
                    this.notifyMessageListeners(adv, appMessage);
                }
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
    }

    private void notifyMessageListeners(SystemAdvertisement senderSystemAdvertisement, Object appMessage) {
        for (ClusterMessageListener listener : this.cmListeners) {
            listener.handleClusterMessage(senderSystemAdvertisement, appMessage);
        }
    }

    public SystemAdvertisement getSystemAdvertisementForMember(ID id) {
        return this.clusterViewManager.get(id);
    }

    public SystemAdvertisement getSystemAdvertisement() {
        if (this.systemAdv == null) {
            this.systemAdv = ClusterManager.createSystemAdv(this.netManager.getNetPeerGroup(), this.instanceName, this.identityMap);
        }
        return this.systemAdv;
    }

    public PeerID getNodeID() {
        return this.myID;
    }

    private static synchronized SystemAdvertisement createSystemAdv(PeerGroup group, String name, Map<String, String> customTags) {
        SystemAdvertisement sysAdv = new SystemAdvertisement();
        sysAdv.setID((ID)group.getPeerID());
        sysAdv.setName(name);
        try {
            sysAdv.setIP(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException ignored) {
            LOG.log(Level.WARNING, "Failed to obtain IP address :" + ignored);
        }
        sysAdv.setOSName(System.getProperty("os.name"));
        sysAdv.setOSVersion(System.getProperty("os.version"));
        sysAdv.setOSArch(System.getProperty("os.arch"));
        sysAdv.setHWArch(System.getProperty("HOSTTYPE", System.getProperty("os.arch")));
        sysAdv.setHWVendor(System.getProperty("java.vm.vendor"));
        sysAdv.setCustomTags(customTags);
        return sysAdv;
    }

    public String getNodeState(ID peerID) {
        return this.getHealthMonitor().getState((ID)((PeerID)peerID));
    }

    public ID getID(String name) {
        return this.netManager.getPeerID(name);
    }

    boolean isStopping() {
        return this.stopping;
    }
}

