#!/bin/sh
#

BIN_DIR=$1
ADMIN_USER=$2
PASSWORD_FILE=$3

numRunning=`$BIN_DIR/asadmin list-domains | grep -v "not running" | grep -c "running"`

if [ $numRunning -ne 0 ]; then
   $BIN_DIR/asadmin stop-appserv
   result=$?
   if [ $result -ne 0 ]; then
      exit 1
   fi
fi

setsid $BIN_DIR/asadmin start-domain --user $ADMIN_USER --passwordfile $PASSWORD_FILE
result=$?
if [ $result -ne 0 ]; then
   echo "Could not start domain. There could be port conflicts.\n"
   echo "Check server.log for more info.\n"
   exit 0
fi

exit 0

