// ==============================================================
//	This file is part of Glest (www.glest.org)
//
//	Copyright (C) 2001-2008 Martio Figueroa
//
//	You can redistribute this code and/or modify it under 
//	the terms of the GNU General Public License as published 
//	by the Free Software Foundation; either version 2 of the 
//	License, or (at your option) any later version
// ==============================================================

#include "client_interface.h"

#include <stdexcept>

#include "platform_util.h"
#include "conversion.h"

using namespace std;
using namespace Shared::Platform;
using namespace Shared::Util;

namespace Glest{ namespace Game{

// =====================================================
//	class ClientInterface
// =====================================================

ClientInterface::ClientInterface(){
	clientSocket= NULL;
}

ClientInterface::~ClientInterface(){
	delete clientSocket;
}

void ClientInterface::connect(const Ip &ip, int port){
	delete clientSocket;
	clientSocket= new ClientSocket();
	clientSocket->setBlock(false);
	clientSocket->connect(ip, port);
}

void ClientInterface::reset(){
	delete clientSocket;
	clientSocket= NULL;
}

void ClientInterface::update(){
	NetworkMessageCommandList networkMessageCommandList;

	//add as much commands as we can
	while(!commands.empty()){
		if(networkMessageCommandList.addCommand(&commands.front())){
			commands.erase(commands.begin());
		}
		else{
			break;
		}
	}

	if(networkMessageCommandList.getCommandCount()>0){
		sendMessage(&networkMessageCommandList);
	}
}

void ClientInterface::waitUntilReady(Checksum* checksum){
	
	NetworkMessageReady networkMessageReady;
	Chrono chrono;

	chrono.start();

	//send ready message
	sendMessage(&networkMessageReady);

	//wait until we get a ready message from the server
	while(true){
		
		NetworkMessageType networkMessageType= getNextMessageType();

		if(networkMessageType==nmtReady){
			if(receiveMessage(&networkMessageReady)){
				break;
			}
		}
		else if(networkMessageType==nmtInvalid){
			if(chrono.getMillis()>readyWaitTimeout){
				throw runtime_error("Timeout waiting for server");
			}
		}
		else{
			throw runtime_error("Unexpected network message: " + intToStr(networkMessageType) );
		}

		// sleep a bit
		sleep(waitSleepTime);
	}

	//check checksum
	if(networkMessageReady.getChecksum()!=checksum->getSum()){
		throw runtime_error("Checksum error, you don't have the same data as the server");
	}

	//delay the start a bit, so clients have nore room to get messages
	sleep(GameConstants::networkExtraLatency);
}

void ClientInterface::sendCommand(const NetworkCommand* networkCommand){
	commands.push_back(*networkCommand);
}

}}//end namespace
