// ==============================================================
//	This file is part of Glest (www.glest.org)
//
//	Copyright (C) 2001-2008 Martio Figueroa
//
//	You can redistribute this code and/or modify it under 
//	the terms of the GNU General Public License as published 
//	by the Free Software Foundation; either version 2 of the 
//	License, or (at your option) any later version
// ==============================================================

#ifndef _GLEST_GAME_NETWORKINTERFACE_H_
#define _GLEST_GAME_NETWORKINTERFACE_H_

#include <string>
#include "checksum.h"

#include "network_message.h"

using std::string;
using Shared::Util::Checksum;

namespace Glest{ namespace Game{

// =====================================================
//	class NetworkInterface
// =====================================================

class NetworkInterface{
public:
	static const int messageWaitTimeout;
	static const int readyWaitTimeout;
	static const int waitSleepTime;

public:
	virtual ~NetworkInterface(){}

	virtual Socket* getSocket()= 0;
	virtual const Socket* getSocket() const= 0;
	virtual void update()= 0;
	virtual void waitUntilReady(Checksum* checksum)= 0;

	string getIp() const		{return getSocket()->getIp();}
	string getHostName() const	{return getSocket()->getHostName();}

	void sendMessage(const NetworkMessage* networkMessage);
	NetworkMessageType getNextMessageType();
	bool receiveMessage(NetworkMessage* networkMessage);

	bool isConnected();
	void waitForMessage();
};

}}//end namespace

#endif
