// ==============================================================
//	This file is part of Glest (www.glest.org)
//
//	Copyright (C) 2001-2008 Martio Figueroa
//
//	You can redistribute this code and/or modify it under 
//	the terms of the GNU General Public License as published 
//	by the Free Software Foundation; either version 2 of the 
//	License, or (at your option) any later version
// ==============================================================

#ifndef _GLEST_GAME_SERVERINTERFACE_H_
#define _GLEST_GAME_SERVERINTERFACE_H_

#include <vector>

#include "game_constants.h"
#include "network_interface.h"
#include "connection_slot.h"
#include "socket.h"

using std::vector;
using Shared::Platform::ServerSocket;

namespace Glest{ namespace Game{

// =====================================================
//	class ServerInterface
// =====================================================

class ServerInterface: public NetworkInterface{
private:
	typedef vector<NetworkCommand> Commands;

private:
	ConnectionSlot* slots[GameConstants::maxPlayers];
	ServerSocket serverSocket;
	Commands commands;

public:
	ServerInterface();
	virtual ~ServerInterface();

	virtual Socket* getSocket()				{return &serverSocket;}
	virtual const Socket* getSocket() const	{return &serverSocket;}
	virtual void update();
	virtual void waitUntilReady(Checksum* checksum);

	ServerSocket* getServerSocket()		{return &serverSocket;}
	void addSlot(int playerIndex);
	void removeSlot(int playerIndex);
	ConnectionSlot* getSlot(int playerIndex);
	int getConnectedSlotCount();

	void launchGame(const GameSettings* gameSettings);
	void quitGame();
	void addCommand(const NetworkCommand* networkCommand);
	void sendCommands(int frameCount);

	int getCommandCount()const					{return commands.size();}
	const NetworkCommand* getCommand(int i)		{return &commands[i];}

private:
	void updateListen();
};

}}//end namespace

#endif
