/* GSnes9x -- codes.c: Cheat Codes stuff.
 * Copyright (C) 1999 Canek Pelez Valds <canek@abulafia.fciencias.unam.mx>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gsnes9x.h"

void
gg_codes_change_cb (GtkWidget *widget, ROMPrefsData *rpd)
{
	F_NAME();
	
	codes_change_dialog (rpd, GG_CODE);
}

void
ar_codes_change_cb (GtkWidget *widget, ROMPrefsData *rpd)
{
	F_NAME();
	
	codes_change_dialog (rpd, AR_CODE);
}

void
gf_codes_change_cb (GtkWidget *widget, ROMPrefsData *rpd)
{
	F_NAME();
	
	codes_change_dialog (rpd, GF_CODE);
}

void
gg_codes_clean_cb (GtkWidget *widget, ROMPrefsData *rpd)
{
	F_NAME();
	
	codes_clean (rpd, GG_CODE);
}

void
ar_codes_clean_cb (GtkWidget *widget, ROMPrefsData *rpd)
{
	F_NAME();
	
	codes_clean (rpd, AR_CODE);
}

void
gf_codes_clean_cb (GtkWidget *widget, ROMPrefsData *rpd)
{
	F_NAME();
	
	codes_clean (rpd, GF_CODE);
}

CodesListStruct*
codes_list_struct_new ()
{
	CodesListStruct *cls = g_new (CodesListStruct, 1);

	F_NAME();
	
	cls->dialog    = NULL;
	cls->clist     = NULL;
	cls->selection = NULL;
	cls->rpd       = NULL;
	cls->list      = NULL;
	
	return cls;
}
	
CodesListStruct*
get_codes_clist (ROMPrefsData *rpd, GSnes9xCheatCodes cc)
{
	CodesListStruct *cl = codes_list_struct_new ();
	GList           *list;
	gint             i, l;
	gchar           *row[3];
	
	gchar *titles[] = {
		_("Code"),
		_("Name"),
		_("Description")
	};

	F_NAME();
	
	cl->window = gtk_scrolled_window_new (NULL, NULL);
	cl->clist  = gtk_clist_new_with_titles (3, titles);
	cl->rpd    = rpd;
	cl->cc     = cc;
	
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (cl->window),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);

	gtk_clist_set_selection_mode (GTK_CLIST (cl->clist),
				      GTK_SELECTION_EXTENDED);
	gtk_clist_set_auto_sort (GTK_CLIST (cl->clist), TRUE);

	gtk_signal_connect (GTK_OBJECT (cl->clist), "click-column",
			    GTK_SIGNAL_FUNC (code_sort_column),
			    NULL);

	gtk_container_add (GTK_CONTAINER (cl->window), cl->clist);
	
	cl->list = get_codes_for_rom (rpd->rom_info->string_prefs[NAME], cc);

	list = g_list_first (cl->list);
	
	l = g_list_length (list);

	for (i = 0; i < l; i++) {
		row[0] = ((CheatCode*)(list->data))->code;
		row[1] = ((CheatCode*)(list->data))->name;
		row[2] = ((CheatCode*)(list->data))->descr;
		
		gtk_clist_append (GTK_CLIST (cl->clist), row);

		list = g_list_next (list);
	}

	gtk_clist_set_column_width
		(GTK_CLIST (cl->clist), 0,
		 gtk_clist_optimal_column_width
		 (GTK_CLIST (cl->clist), 0));
	gtk_clist_set_column_width
		(GTK_CLIST (cl->clist), 1,
		 gtk_clist_optimal_column_width
		 (GTK_CLIST (cl->clist), 1));
	
	gtk_signal_connect (GTK_OBJECT (cl->clist), "select-row",
			    GTK_SIGNAL_FUNC (code_select_cb),
			    (gpointer) cl);

	gtk_signal_connect (GTK_OBJECT (cl->clist), "unselect-row",
			    GTK_SIGNAL_FUNC (code_unselect_cb),
			    (gpointer) cl);
	
	gtk_widget_set_usize (cl->window, IMAGE_WIDTH, IMAGE_HEIGHT);
	
	gtk_widget_show (cl->clist);
	
	return cl;
}

void
codes_change_dialog (ROMPrefsData *rpd, GSnes9xCheatCodes cc)
{
	CodesListStruct *cls;
	GtkWidget       *dialog;
	gchar           *title = NULL;

	F_NAME();
	
	switch (cc) {
	case GG_CODE:
		title = g_strdup_printf (_("Game Genie codes for %s"),
					 rpd->rom_info->string_prefs[NAME]);
		break;
	case AR_CODE:
		title = g_strdup_printf (_("Action Replay codes for %s"),
					 rpd->rom_info->string_prefs[NAME]);
		break;
	case GF_CODE:
		title = g_strdup_printf (_("Gold Finger codes for %s"),
					 rpd->rom_info->string_prefs[NAME]);
		break;
	}

	cls = get_codes_clist (rpd, cc);
	
	dialog = gnome_dialog_new (title,
				   _("Add code"),
				   _("Remove code(s)"),
				   _("Set code(s)"),
				   GNOME_STOCK_BUTTON_CLOSE,
				   NULL);
	
	g_free (title);
	
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
	gtk_window_set_transient_for (GTK_WINDOW (dialog),
				      GTK_WINDOW (rpd->rom_prefs_dialog));
	
	cls->dialog = dialog;
	
	gtk_signal_connect (GTK_OBJECT (cls->dialog), "destroy",
			    GTK_SIGNAL_FUNC (code_dialog_free_cb),
			    (gpointer) cls);
	
	gnome_dialog_button_connect (GNOME_DIALOG (dialog),
				     0, GTK_SIGNAL_FUNC (code_add_cb),
				     (gpointer) cls);
	
	gnome_dialog_button_connect (GNOME_DIALOG (dialog),
				     1, GTK_SIGNAL_FUNC (code_remove_cb),
				     (gpointer) cls);

	gnome_dialog_button_connect (GNOME_DIALOG (dialog),
				     2, GTK_SIGNAL_FUNC (code_set_cb),
				     (gpointer) cls);

	gnome_dialog_button_connect (GNOME_DIALOG (dialog),
				     3, GTK_SIGNAL_FUNC (destroy_data_cb),
				     (gpointer) dialog);
	
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox),
			    cls->window, FALSE, FALSE, 10);

	gtk_widget_show (cls->window);
	gtk_widget_show (dialog);	
}

void
code_add_cb (GtkWidget *widget, CodesListStruct *cls)
{
	AddCodeStruct *add_code = g_new (AddCodeStruct, 1);
	GtkWidget     *code_add_dialog;
	GtkWidget     *table;
	GtkWidget     *entry;
	GtkWidget     *label;
	gchar         *title = NULL, *label_name = NULL;

	F_NAME();
	
	add_code->cls = cls;
	
	switch (cls->cc) {
	case GG_CODE:
		title = _("Add Game Genie code");
		label_name = _("GameGenie code:");
		break;
	case AR_CODE:
		title = _("Add Action Replay code");
		label_name = _("ActionReplay code:");
		break;
	case GF_CODE:
		title = _("Add Gold Finger code");
		label_name = _("GoldFinger code:");
		break;
	}
	
	code_add_dialog = gnome_dialog_new (title, GNOME_STOCK_BUTTON_OK,
					    GNOME_STOCK_BUTTON_CANCEL, NULL);

	gtk_window_set_modal (GTK_WINDOW (code_add_dialog), TRUE);
	gtk_window_set_transient_for (GTK_WINDOW (code_add_dialog),
				      GTK_WINDOW (cls->dialog));
	
	add_code->dialog = code_add_dialog;

	gtk_signal_connect (GTK_OBJECT (code_add_dialog), "destroy",
			    GTK_SIGNAL_FUNC (code_add_free_cb),
			    (gpointer) add_code);
	
	gnome_dialog_button_connect (GNOME_DIALOG (code_add_dialog),
				     0, GTK_SIGNAL_FUNC (code_add_ok_cb),
				     (gpointer) add_code);
	gnome_dialog_button_connect (GNOME_DIALOG (code_add_dialog),
				     1, GTK_SIGNAL_FUNC (code_add_cancel_cb),
				     (gpointer) add_code);
	
	table = gtk_table_new (3, 2, FALSE);

	label = gtk_label_new (label_name);
	g_free (label_name);
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);

	entry = gtk_entry_new_with_max_length (CONF_STR_LEN);

	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
			  GTK_FILL, GTK_FILL, 5, 2);

	gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 0, 1,
			  GTK_FILL, GTK_FILL, 5, 2);

	gtk_widget_show (label);
	gtk_widget_show (entry);
	add_code->entry[0] = entry;
	
	label = gtk_label_new (_("Name:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	entry = gtk_entry_new_with_max_length (CONF_STR_LEN);

	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
			  GTK_FILL, GTK_FILL, 5, 2);

	gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2,
			  GTK_FILL, GTK_FILL, 5, 2);

	gtk_widget_show (label);
	gtk_widget_show (entry);
	add_code->entry[1] = entry;
	
	label = gtk_label_new (_("Description:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	entry = gtk_entry_new_with_max_length (CONF_STR_LEN);

	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
			  GTK_FILL, GTK_FILL, 5, 2);

	gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 2, 3,
			  GTK_FILL, GTK_FILL, 5, 2);

	gtk_widget_show (label);
	gtk_widget_show (entry);
	add_code->entry[2] = entry;

	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (code_add_dialog)->vbox),
			    table, FALSE, FALSE, 10);

	gtk_widget_show (table);
	gtk_widget_show (code_add_dialog);
}


void
code_remove_cb (GtkWidget *widget, CodesListStruct *cls)
{
	gint l;
	GtkWidget *warning;
	gchar *mesg = NULL, *codetype = NULL;
	
	F_NAME();
	
	l = g_list_length (cls->selection);

	if (!l)
		return;

	switch (cls->cc) {
	case GG_CODE:
		codetype = "Game Genie";
		break;
	case AR_CODE:
		codetype = "Action Replay";
		break;
	case GF_CODE:
		codetype = "Gold Finger";
		break;
	}
	
	if (l > 1)
		mesg = g_strdup_printf (_("Are you sure you want to remove "
					  "this\n%d %s codes?"), l, codetype);
	else
		mesg = g_strdup_printf (_("Are you sure you want to remove\n"
					  "this %s code?"), codetype);
	
	warning = gnome_message_box_new (mesg,
					 GNOME_MESSAGE_BOX_WARNING,
					 GNOME_STOCK_BUTTON_YES,
					 GNOME_STOCK_BUTTON_NO,
					 NULL);

	g_free (mesg);

	gtk_window_set_modal (GTK_WINDOW (warning), TRUE);
	gtk_window_set_transient_for (GTK_WINDOW (warning),
				      GTK_WINDOW (cls->dialog));
	
	gnome_dialog_button_connect (GNOME_DIALOG (warning),
				     0, GTK_SIGNAL_FUNC
				     (code_remove_ok_cb),
				     (gpointer) cls);
	
	gnome_dialog_button_connect (GNOME_DIALOG (warning),
				     1, GTK_SIGNAL_FUNC
				     (destroy_data_cb),
				     (gpointer) warning);

	gtk_widget_show (warning);
}

void
code_set_cb (GtkWidget *widget, CodesListStruct *cls)
{
	gint i, l;
	GtkWidget *warning;
	gchar *mesg = NULL, *codetype = NULL;
	GList *list;
	gchar *tmp;

	F_NAME();
	
	l = g_list_length (cls->selection);

	switch (cls->cc) {
	case GG_CODE:
		codetype = "Game Genie";
		break;
	case AR_CODE:
		codetype = "Action Replay";
		break;
	case GF_CODE:
		codetype = "Gold Finger";
		break;
	}
	
	if (l > MAX_CODES) {
		mesg = g_strdup_printf (_("You cannot use more than %d %s "
					  "codes at the same time."),
					MAX_CODES, codetype);
		
		warning = gnome_message_box_new (mesg,
						 GNOME_MESSAGE_BOX_ERROR,
						 GNOME_STOCK_BUTTON_OK,
						 NULL);
		g_free (mesg);

		gtk_window_set_modal (GTK_WINDOW (warning), TRUE);
		gtk_window_set_transient_for (GTK_WINDOW (warning),
					      GTK_WINDOW (cls->dialog));
		
		gtk_widget_show (warning);
		
		return;
	}

	if (l < 1) {
		mesg = g_strdup_printf (_("You must select at least one %s code."),
					codetype);
		warning = gnome_message_box_new (mesg,
						 GNOME_MESSAGE_BOX_ERROR,
						 GNOME_STOCK_BUTTON_OK,
						 NULL);
		g_free (mesg);

		gtk_window_set_modal (GTK_WINDOW (warning), TRUE);
		gtk_window_set_transient_for (GTK_WINDOW (warning),
					      GTK_WINDOW (cls->dialog));
		
		gtk_widget_show (warning);
		
		return;
	}
	
	list = cls->selection;

	for (i = 0; i < l; i++) {
		tmp = (gchar*)(list->data);
		switch (cls->cc) {
		case GG_CODE:
			gtk_label_set_text (GTK_LABEL
					    (cls->rpd->code[GG_CODE][i]),
					    tmp);
			break;
		case AR_CODE:
			gtk_label_set_text (GTK_LABEL
					    (cls->rpd->code[AR_CODE][i]),
					    tmp);
			break;
		case GF_CODE:
			gtk_label_set_text (GTK_LABEL
					    (cls->rpd->code[GF_CODE][i]),
					    tmp);
			break;
		}
		list = g_list_next (list);
	}

	for (i = l; i < MAX_CODES; i++) {
		switch (cls->cc) {
		case GG_CODE:
			gtk_label_set_text (GTK_LABEL
					    (cls->rpd->code[GG_CODE][i]), "-");
			break;
		case AR_CODE:
			gtk_label_set_text (GTK_LABEL
					    (cls->rpd->code[AR_CODE][i]), "-");
			break;
		case GF_CODE:
			gtk_label_set_text (GTK_LABEL
					    (cls->rpd->code[GF_CODE][i]), "-");
			break;
		}
	}

	rom_prefs_dialog_changed_cb (NULL, cls->rpd);

	gtk_widget_destroy (cls->dialog);
}

void
code_add_ok_cb (GtkWidget *widget, AddCodeStruct *add_code)
{
	CheatCode *cc = g_new (CheatCode, 1);
	GList *codes_list = add_code->cls->list;
	FILE  *file;
	gchar *filename, *type = NULL;
	gchar *row[3];
	gboolean repeat = FALSE;
	gint i, l;	

	F_NAME();
	
	if (!strlen (gtk_entry_get_text (GTK_ENTRY (add_code->entry[0]))) ||
	    !strlen (gtk_entry_get_text (GTK_ENTRY (add_code->entry[1]))) ||
	    !strlen (gtk_entry_get_text (GTK_ENTRY (add_code->entry[2]))))
		return;

	codes_list = g_list_first (codes_list);
	
	l = g_list_length (codes_list);

	cc->code  = g_strdup
		(gtk_entry_get_text (GTK_ENTRY (add_code->entry[0])));
	cc->name  = g_strdup
		(gtk_entry_get_text (GTK_ENTRY (add_code->entry[1])));
	cc->descr = g_strdup
		(gtk_entry_get_text (GTK_ENTRY (add_code->entry[2])));

	row[0] = cc->code;
	row[1] = cc->name;
	row[2] = cc->descr;
	
	for (i = 0; i < l; i++)
		if (!strcmp (((CheatCode*)(codes_list->data))->code, cc->code))
			repeat = TRUE;

	if (repeat) {
		code_repeated (cc->code);
		g_free (cc->code);
		g_free (cc->name);
		g_free (cc->descr);
		g_free (cc);
		return;
	}

	switch (add_code->cls->cc) {
	case GG_CODE:
		type = "gg";
		break;
	case AR_CODE:
		type = "ar";
		break;
	case GF_CODE:
		type = "gf";
		break;
	}

	filename = g_strdup_printf ("%s/%s.%s", CONF_DIR,
				    add_code->cls->rpd->rom_info->
				    string_prefs[NAME], type);
	
	file = fopen (gnome_util_home_file (filename), "a");
	
	g_free (filename);
	
	fprintf (file, "%s\n", cc->code);
	fprintf (file, "%s\n", cc->name);
	fprintf (file, "%s\n", cc->descr);

	fclose (file);

	add_code->cls->list = g_list_prepend (codes_list, (gpointer) cc);
	
	gtk_clist_append (GTK_CLIST (add_code->cls->clist), row);

	gtk_clist_set_column_width (GTK_CLIST (add_code->cls->clist), 0,
				    gtk_clist_optimal_column_width
				    (GTK_CLIST (add_code->cls->clist), 0));
	gtk_clist_set_column_width (GTK_CLIST (add_code->cls->clist), 1,
				    gtk_clist_optimal_column_width
				    (GTK_CLIST (add_code->cls->clist), 1));
	
	gtk_widget_destroy (add_code->dialog);
}

void
code_add_cancel_cb (GtkWidget *widget, AddCodeStruct *add_code)
{
	F_NAME();
	
	gtk_widget_destroy (add_code->dialog);
}

void
code_add_free_cb (GtkWidget *widget, AddCodeStruct *add_code)
{
	F_NAME();
	
	g_free (add_code);
}

void
code_remove_ok_cb (GtkWidget *widget, CodesListStruct *cls)
{
	CheatCode *cheat_code = NULL;
	FILE      *file;
	GList     *list_tmp;
	gchar    **codes, *code_tmp, *type = NULL, *filename;
	gint       i, j, sel_len, clist_len, row = -1;

	F_NAME();
	
	list_tmp = g_list_first  (cls->selection);
	sel_len  = g_list_length (list_tmp);
	codes    = g_new (gchar*, sel_len);

	clist_len = g_list_length (cls->list);

	/* Copy selected codes. */
	for (i = 0; i < sel_len; i++) {
		code_tmp = (gchar*)(list_tmp->data);
		codes[i] = g_strdup (code_tmp);
		list_tmp = g_list_next (list_tmp);
	}

	/* Remove rows in GtkCList. */
	for (i = 0; i < sel_len; i++) {
		for (j = 0; j < clist_len; j++) {
			gtk_clist_get_text (GTK_CLIST (cls->clist), j, 0,
					    &code_tmp);
			if (!strcmp (codes[i], code_tmp)) {
				row = j;
				j = clist_len*2;
			}
		}
		gtk_clist_remove (GTK_CLIST (cls->clist), row);
		clist_len--;
	}

	list_tmp  = g_list_first  (cls->list);
	clist_len = g_list_length (list_tmp);
	
	/* Remove CheatCode's from list. */
	for (i = 0; i < sel_len; i++) {
		for (j = 0; j < clist_len; j++) {
			code_tmp = ((CheatCode*)(list_tmp->data))->code;
			if (!strcmp (codes[i], code_tmp)) {
				cheat_code = (CheatCode*)(list_tmp->data);
				j = clist_len*2;
			}
			list_tmp = g_list_next (list_tmp);
		}
		cls->list = g_list_remove (cls->list, (gpointer) cheat_code);
		list_tmp  = cls->list;
		clist_len = g_list_length (list_tmp);
	}

	for (i = 0; i < sel_len; i++)
		g_free (codes[i]);
	g_free (codes);

	switch (cls->cc) {
	case GG_CODE:
		type = "gg";
		break;
	case AR_CODE:
		type = "ar";
		break;
	case GF_CODE:
		type = "gf";
		break;
	}

	filename = g_strdup_printf ("%s/%s.%s", CONF_DIR,
				    cls->rpd->rom_info->string_prefs[NAME],
				    type);
	
	if (clist_len) {
		file = fopen (gnome_util_home_file (filename), "w");
		for (i = 0; i < clist_len; i++) {
			cheat_code =  (CheatCode*)(list_tmp->data);
			fprintf (file, "%s\n%s\n%s\n", cheat_code->code,
				 cheat_code->name, cheat_code->descr);
			list_tmp = g_list_next (list_tmp);
		}
		fclose (file);
		gtk_clist_set_column_width
			(GTK_CLIST (cls->clist), 0,
			 gtk_clist_optimal_column_width
			 (GTK_CLIST (cls->clist), 0));
		gtk_clist_set_column_width
			(GTK_CLIST (cls->clist), 1,
			 gtk_clist_optimal_column_width
			 (GTK_CLIST (cls->clist), 1));
	} else
		remove (gnome_util_home_file (filename));

	g_free (filename);
}

void
code_select_cb (GtkWidget *clist, gint row, gint col,
		GdkEventButton *event, CodesListStruct *cls)
{
	gchar *code;

	F_NAME();
	
	gtk_clist_get_text (GTK_CLIST (clist), row, 0, &code);

	/* Avoid duplication by double click. */
	if (!event)
		cls->selection =
			g_list_prepend (cls->selection, (gpointer) code);
	else
		if (event->type == GDK_BUTTON_RELEASE)
			cls->selection =
				g_list_prepend (cls->selection,
						(gpointer) code);
}

void
code_unselect_cb (GtkWidget *clist, gint row, gint col,
		  GdkEventButton *event, CodesListStruct *cls)
{
	gboolean last = FALSE;
	gchar *code;

	F_NAME();
	
	gtk_clist_get_text (GTK_CLIST (clist), row, 0, &code);
	
	if (g_list_length (cls->selection) == 1)
		last = TRUE;
	
	cls->selection =
		g_list_remove (cls->selection, (gpointer) code);
	
	if (last)
		cls->selection = NULL;
}

void
code_sort_column (GtkWidget *clist,  gint column, gpointer data)
{
	F_NAME();
	
	gtk_clist_set_sort_column (GTK_CLIST (clist), column);
	gtk_clist_sort (GTK_CLIST (clist));
}

void
code_repeated (gchar *name)
{
	GtkWidget *error;
	gchar     *msg;

	F_NAME();

	msg = g_strdup_printf (_("Sorry, the code \"%s\" already exists."),
			       name);
	
	error = gnome_message_box_new (msg,
				       GNOME_MESSAGE_BOX_ERROR, 
				       GNOME_STOCK_BUTTON_OK,
				       NULL);

	gtk_widget_show (error);
	
	g_free (msg);

	
}

void
codes_clean (ROMPrefsData *rpd, GSnes9xCheatCodes cc)
{
	gint i;

	F_NAME();
	
	for (i = 0; i < MAX_CODES; i++)
		gtk_label_set_text (GTK_LABEL (rpd->code[cc][i]), "-");
}

void
code_dialog_free_cb (GtkWidget *widget, CodesListStruct *cls)
{
	F_NAME();
	
	if (cls->selection)
		g_list_free (cls->selection);

	g_free (cls);	
}

/* codes.c ends here. */
