/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.StringUID;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import java.util.Collections;
import java.util.Map;

public class DestinationUID
extends StringUID {
    static final long serialVersionUID = 3047167637056417589L;
    private static Map topics = Collections.synchronizedMap(new WeakValueHashMap("DestinationUID_topics"));
    private static Map queues = Collections.synchronizedMap(new WeakValueHashMap("DestinationUID_queues"));
    private boolean isQueue = false;
    private String name = null;
    private static String localQueue = Globals.getBrokerResources().getString("B0043");
    private static String localTopic = Globals.getBrokerResources().getString("B0044");

    public static void clearCache() {
        queues.clear();
        topics.clear();
    }

    protected DestinationUID(String string, boolean bl) {
        super(DestinationUID.getUniqueString(string, bl));
        this.name = string;
        this.isQueue = bl;
    }

    public DestinationUID(String string) {
        super(string);
        this.name = this.getName(string);
        this.isQueue = this.getIsQueue(string);
    }

    public String getDestType() {
        if (this.isQueue) {
            return localQueue;
        }
        return localTopic;
    }

    public String getLocalizedName() {
        return Globals.getBrokerResources().getString("B0045", this.name, this.getDestType());
    }

    private String getName(String string) {
        return string.substring(2);
    }

    private boolean getIsQueue(String string) {
        return string.charAt(0) == 'Q';
    }

    public String getName() {
        return this.name;
    }

    public boolean isQueue() {
        return this.isQueue;
    }

    public static DestinationUID getUID(String string, int n) {
        return DestinationUID.getUID(string, DestType.isQueue(n));
    }

    public static DestinationUID getUID(String string, boolean bl) {
        DestinationUID destinationUID = null;
        if (bl) {
            destinationUID = (DestinationUID)queues.get(string);
            if (destinationUID == null) {
                destinationUID = new DestinationUID(string, bl);
                queues.put(string, destinationUID);
            }
        } else {
            destinationUID = (DestinationUID)topics.get(string);
            if (destinationUID == null) {
                destinationUID = new DestinationUID(string, bl);
                topics.put(string, destinationUID);
            }
        }
        return destinationUID;
    }

    public static void clearUID(DestinationUID destinationUID) {
        if (destinationUID.isQueue()) {
            queues.remove(destinationUID.getName());
        } else {
            topics.remove(destinationUID.getName());
        }
    }

    public String toString() {
        return super.toString();
    }

    public String getLongString() {
        if (this.isQueue) {
            return "queue:" + this.name;
        }
        return "topic:" + this.name;
    }

    public static final String getUniqueString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("Q:");
        } else {
            stringBuffer.append("T:");
        }
        stringBuffer.append(string);
        if (stringBuffer.indexOf("/") != -1) {
            for (int i = 0; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                if (c != '/') continue;
                stringBuffer.setCharAt(i, '_');
            }
        }
        return stringBuffer.toString();
    }
}

