/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.GoodbyeTask;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Hashtable;

public class GoodbyeHandler
extends PacketHandler {
    protected static long timeout = Globals.getConfig().getLongProperty("imq.goodbye.timeout", 0L);
    ConnectionManager conlist = null;

    public GoodbyeHandler(ConnectionManager connectionManager) {
        this.conlist = connectionManager;
        timeout = Globals.getConfig().getLongProperty("imq.goodbye.timeout", 0L);
        GoodbyeTask.initialize(timeout);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        boolean bl;
        block14: {
            block11: {
                Hashtable<String, Object> hashtable;
                Packet packet2;
                block13: {
                    block12: {
                        boolean bl2;
                        Hashtable hashtable2 = null;
                        try {
                            hashtable2 = packet.getProperties();
                        }
                        catch (Exception exception) {
                            this.logger.log(8, "Internal Error: unable to retrieve  properties from goodbye message " + packet, exception);
                            hashtable2 = new Hashtable();
                        }
                        boolean bl3 = bl2 = !iMQConnection.isAuthenticated();
                        if (iMQConnection.isValid() && bl2) {
                            this.logger.log(16, "Internal error:  received goodbye on unauthenticated connection " + iMQConnection.getConnectionUID().longValue() + " " + iMQConnection.getRemoteConnectionString());
                        }
                        Boolean bl4 = hashtable2 != null ? (Boolean)hashtable2.get("JMQBlock") : null;
                        boolean bl5 = bl4 != null && bl4 != false;
                        iMQConnection.stopConnection();
                        if (bl5) {
                            iMQConnection.cleanupConnection();
                        }
                        bl = false;
                        if (!packet.getSendAcknowledge()) break block11;
                        packet2 = new Packet(iMQConnection.useDirectBuffers());
                        packet2.setPacketType(29);
                        packet2.setConsumerID(packet.getConsumerID());
                        hashtable = new Hashtable<String, Object>();
                        hashtable.put("JMQStatus", new Integer(200));
                        IMQIPConnection cfr_ignored_0 = (IMQIPConnection)iMQConnection;
                        if (IMQIPConnection.getDumpPacket()) break block12;
                        IMQIPConnection cfr_ignored_1 = (IMQIPConnection)iMQConnection;
                        if (!IMQIPConnection.getDumpOutPacket()) break block13;
                    }
                    hashtable.put("JMQReqID", packet.getSysMessageID().toString());
                }
                packet2.setProperties(hashtable);
                iMQConnection.sendControlMessage(packet2);
                if (iMQConnection.isBlocking()) {
                    if (iMQConnection instanceof IMQIPConnection) {
                        IMQIPConnection iMQIPConnection = (IMQIPConnection)iMQConnection;
                        iMQIPConnection.flushControl(timeout);
                    }
                    bl = true;
                } else {
                    iMQConnection.setDestroyReason(Globals.getBrokerResources().getKString("B0059"));
                    GoodbyeTask.addConnection(iMQConnection.getConnectionUID(), Globals.getBrokerResources().getKString("B0059"));
                }
                break block14;
            }
            bl = true;
        }
        if (bl) {
            iMQConnection.destroyConnection(false, 5, Globals.getBrokerResources().getKString("B0059"));
        }
        return true;
    }
}

