/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.util.DestType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class DestinationDAOImpl
extends BaseDAOImpl
implements DestinationDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateSQL;
    protected String updateConnectedTimeSQL;
    protected String deleteSQL;
    protected String deleteSharedDstSQL;
    protected String selectSQL;
    protected String selectConnectedTimeSQL;
    protected String selectDstsByBrokerSQL;
    protected String selectLocalDstsByBrokerSQL;
    protected String selectExistSQL;

    DestinationDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQDST41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("DESTINATION").append(", ").append("IS_LOCAL").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("STORE_SESSION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        this.updateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION").append(" = ?, ").append("IS_LOCAL").append(" = ?, ").append("CONNECTION_ID").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateConnectedTimeSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("CONNECTED_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSharedDstSQL = new StringBuffer(128).append(this.deleteSQL).append(" AND NOT EXISTS (SELECT * FROM ").append(dBManager.getTableName("MQMSG41")).append(" WHERE ").append("DESTINATION_ID").append(" = ?)").append(" AND NOT EXISTS (SELECT * FROM ").append(dBManager.getTableName("MQBKR41")).append(" WHERE ").append("ID").append(" <> ? ").append(" AND ").append("STATE").append(" = ").append(1).append(")").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectConnectedTimeSQL = new StringBuffer(128).append("SELECT ").append("CONNECTED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectDstsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" IN (SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("IS_LOCAL").append(" = 0").append(" UNION SELECT dstTbl.").append("ID").append(" FROM ").append(this.tableName).append(" dstTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = dstTbl.").append("STORE_SESSION_ID").append(")").toString();
        this.selectLocalDstsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" dstTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl WHERE ").append(" sesTbl.").append("BROKER_ID").append(" = ?").append(" AND ").append(" sesTbl.").append("ID").append(" = dstTbl.").append("STORE_SESSION_ID").toString();
        this.selectExistSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return "MQDST41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection connection, Destination destination, long l, long l2, long l3) throws BrokerException {
        block16: {
            PreparedStatement preparedStatement;
            block15: {
                String string = destination.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (this.hasDestination(connection, string)) {
                        throw new BrokerException(this.br.getKString("B3012", string));
                    }
                    try {
                        ConnectionUID connectionUID;
                        int n;
                        int n2 = n = destination.getIsLocal() ? 1 : 0;
                        if (n == 0) {
                            l = 0L;
                        }
                        long l4 = -1L;
                        if (destination.isTemporary() && (connectionUID = destination.getConnectionUID()) != null) {
                            l4 = connectionUID.longValue();
                            if (l2 <= 0L) {
                                l2 = System.currentTimeMillis();
                            }
                        }
                        preparedStatement = connection.prepareStatement(this.insertSQL);
                        preparedStatement.setString(1, string);
                        Util.setObject(preparedStatement, 2, destination);
                        preparedStatement.setInt(3, n);
                        Util.setLong(preparedStatement, 4, l4);
                        Util.setLong(preparedStatement, 5, l2);
                        Util.setLong(preparedStatement, 6, l);
                        preparedStatement.setLong(7, l3);
                        preparedStatement.executeUpdate();
                    }
                    catch (Exception exception) {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4014", string), exception2);
                    }
                    if (!bl) break block15;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        Util.close(null, preparedStatement, connection);
                    } else {
                        Util.close(null, preparedStatement, null);
                    }
                    throw throwable;
                }
                Util.close(null, preparedStatement, connection);
                break block16;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void update(Connection connection, Destination destination) throws BrokerException {
        block14: {
            PreparedStatement preparedStatement;
            block13: {
                String string = destination.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                try {
                    ConnectionUID connectionUID;
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    int n = destination.getIsLocal() ? 1 : 0;
                    long l = -1L;
                    if (n > 0 && (connectionUID = destination.getConnectionUID()) != null) {
                        l = connectionUID.longValue();
                    }
                    preparedStatement = connection.prepareStatement(this.updateSQL);
                    Util.setObject(preparedStatement, 1, destination);
                    preparedStatement.setInt(2, n);
                    Util.setLong(preparedStatement, 3, l);
                    preparedStatement.setString(4, string);
                    if (preparedStatement.executeUpdate() == 0) {
                        throw new DestinationNotFoundException(this.br.getKString("B3013", string), 404);
                    }
                    if (!bl) break block13;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.updateSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4014", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block14;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void updateConnectedTime(Connection connection, Destination destination, long l) throws BrokerException {
        String string = destination.getUniqueName();
        if (!destination.getIsLocal()) {
            throw new BrokerException(this.br.getKString("B3181", string));
        }
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.updateConnectedTimeSQL);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            if (preparedStatement.executeUpdate() == 0) {
                throw new DestinationNotFoundException(this.br.getKString("B3013", string), 404);
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateConnectedTimeSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4014", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public boolean delete(Connection connection, Destination destination) throws BrokerException {
        return this.delete(connection, destination.getDestinationUID(), destination.getType());
    }

    public boolean delete(Connection connection, DestinationUID destinationUID, int n) throws BrokerException {
        boolean bl;
        block16: {
            PreparedStatement preparedStatement;
            block15: {
                bl = false;
                String string = destinationUID.toString();
                boolean bl2 = false;
                String string2 = null;
                preparedStatement = null;
                try {
                    int n2;
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl2 = true;
                    }
                    if ((n2 = dBManager.getDAOFactory().getMessageDAO().deleteByDestination(connection, destinationUID)) > 0) {
                        this.logger.log(16, "B2181", (Object)String.valueOf(n2), destinationUID);
                    }
                    if (Globals.getHAEnabled() && DestType.isAutoCreated(n) && !DestType.isTemporary(n)) {
                        string2 = this.deleteSharedDstSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                        preparedStatement.setString(2, string);
                        preparedStatement.setString(3, dBManager.getBrokerID());
                    } else {
                        string2 = this.deleteSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                    }
                    int n3 = preparedStatement.executeUpdate();
                    if (bl2) {
                        connection.commit();
                    }
                    boolean bl3 = bl = n3 > 0;
                    if (!bl2) break block15;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4144", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block16;
            }
            Util.close(null, preparedStatement, null);
        }
        return bl;
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            DBManager dBManager = DBManager.getDBManager();
            string = new StringBuffer(128).append("EXISTS (SELECT ").append("ID").append(" FROM ").append(dBManager.getTableName("MQSES41")).append(" WHERE ").append("ID").append(" = ").append(this.tableName).append(".").append("STORE_SESSION_ID").append(" AND ").append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("')").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    public Destination getDestination(Connection connection, String string) throws BrokerException {
        Destination destination;
        block9: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block8: {
                destination = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    destination = (Destination)this.loadData(resultSet, true);
                    if (!bl) break block8;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4224", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block9;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return destination;
    }

    public long getDestinationConnectedTime(Connection connection, String string) throws BrokerException {
        long l;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                l = -1L;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectConnectedTimeSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new DestinationNotFoundException(this.br.getKString("B3013", string), 404);
                    }
                    l = resultSet.getLong(1);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectConnectedTimeSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4224", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return l;
    }

    public List getAllDestinations(Connection connection, String string) throws BrokerException {
        List list;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                list = Collections.EMPTY_LIST;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (string == null) {
                        string = dBManager.getBrokerID();
                    }
                    preparedStatement = connection.prepareStatement(this.selectDstsByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    list = (List)this.loadData(resultSet, false);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectDstsByBrokerSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4031"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return list;
    }

    public List getAllLocalDestinations(Connection connection, String string) throws BrokerException {
        List list;
        block13: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block12: {
                list = Collections.EMPTY_LIST;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (string == null) {
                        string = dBManager.getBrokerID();
                    }
                    preparedStatement = connection.prepareStatement(this.selectLocalDstsByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    list = (List)this.loadData(resultSet, false);
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectLocalDstsByBrokerSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B3175", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block13;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return list;
    }

    public boolean hasDestination(Connection connection, String string) throws BrokerException {
        boolean bl;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectExistSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                    if (!bl2) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectExistSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4166", this.selectExistSQL), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return bl;
    }

    public void checkDestination(Connection connection, String string) throws BrokerException {
        if (!this.hasDestination(connection, string)) {
            throw new DestinationNotFoundException(this.br.getKString("B3013", string), 404);
        }
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Destinations(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    protected Object loadData(ResultSet resultSet, boolean bl) throws SQLException {
        ArrayList<Destination> arrayList = null;
        if (!bl) {
            arrayList = new ArrayList<Destination>(100);
        }
        while (resultSet.next()) {
            try {
                Destination destination = (Destination)Util.readObject(resultSet, 1);
                if (bl) {
                    return destination;
                }
                arrayList.add(destination);
            }
            catch (Exception exception) {
                this.logger.logStack(32, "B4124", exception);
            }
        }
        return arrayList;
    }
}

