/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class TransactionDAOImpl
extends BaseDAOImpl
implements TransactionDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateTxnStateSQL;
    protected String updateTxnHomeBrokerSQL;
    protected String updateTxnBrokersSQL;
    protected String updateAccessedTimeSQL;
    protected String deleteSQL;
    protected String deleteNotInStateSQL;
    protected String selectTxnStateSQL;
    protected String selectTxnHomeBrokerSQL;
    protected String selectTxnBrokersSQL;
    protected String selectAccessedTimeSQL;
    protected String selectTxnInfoSQL;
    protected String selectTxnStatesByBrokerSQL;
    protected String selectTxnStatesByBrokerAndTypeSQL;
    protected String selectRemoteTxnStatesByBrokerAndTypeSQL;
    protected String selectUsageInfoSQL;

    TransactionDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        String string = Globals.getHAEnabled() ? " AND NOT EXISTS (" + ((BrokerDAOImpl)dBManager.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")" : "";
        this.tableName = dBManager.getTableName("MQTXN41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("TYPE").append(", ").append("STATE").append(", ").append("AUTO_ROLLBACK").append(", ").append("XID").append(", ").append("TXN_STATE").append(", ").append("TXN_HOME_BROKER").append(", ").append("TXN_BROKERS").append(", ").append("STORE_SESSION_ID").append(", ").append("EXPIRED_TS").append(", ").append("ACCESSED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )").toString();
        this.updateTxnStateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?, ").append("TXN_STATE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(string).toString();
        this.updateTxnHomeBrokerSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TXN_HOME_BROKER").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(string).toString();
        this.updateTxnBrokersSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TYPE").append(" = ?, ").append("TXN_BROKERS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(string).toString();
        this.updateAccessedTimeSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("ACCESSED_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteNotInStateSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("STATE").append(" <> ?").toString();
        this.selectTxnStateSQL = new StringBuffer(128).append("SELECT ").append("STATE").append(", ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectTxnHomeBrokerSQL = new StringBuffer(128).append("SELECT ").append("TXN_HOME_BROKER").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectTxnBrokersSQL = new StringBuffer(128).append("SELECT ").append("TXN_BROKERS").append(", ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAccessedTimeSQL = new StringBuffer(128).append("SELECT ").append("ACCESSED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectTxnInfoSQL = new StringBuffer(128).append("SELECT ").append("TYPE").append(", ").append("STATE").append(", ").append("TXN_STATE").append(", ").append("TXN_HOME_BROKER").append(", ").append("TXN_BROKERS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectTxnStatesByBrokerSQL = new StringBuffer(128).append("SELECT txnTbl.").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" txnTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = txnTbl.").append("STORE_SESSION_ID").append(" AND ").append("STATE").append(" <> -1").append(" AND ").append("TYPE").append(" IN (").append(1).append(", ").append(2).append(")").toString();
        this.selectTxnStatesByBrokerAndTypeSQL = new StringBuffer(128).append("SELECT txnTbl.").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" txnTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = txnTbl.").append("STORE_SESSION_ID").append(" AND ").append("STATE").append(" <> -1").append(" AND ").append("TYPE").append(" = ?").toString();
        this.selectRemoteTxnStatesByBrokerAndTypeSQL = new StringBuffer(256).append("SELECT ").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" IN (SELECT DISTINCT t.").append("ID").append(" FROM ").append(dBManager.getTableName("MQSES41")).append(" s, ").append(dBManager.getTableName("MQMSG41")).append(" m, ").append(dBManager.getTableName("MQCONSTATE41")).append(" c, ").append(this.tableName).append(" t").append(" WHERE s.").append("BROKER_ID").append(" = ?").append(" AND s.").append("ID").append(" = m.").append("STORE_SESSION_ID").append(" AND m.").append("ID").append(" = c.").append("MESSAGE_ID").append(" AND c.").append("TRANSACTION_ID").append(" = t.").append("ID").append(" AND t.").append("STORE_SESSION_ID").append(" <> s.").append("ID").append(" AND t.").append("TYPE").append(" = ?)").toString();
        this.selectUsageInfoSQL = new StringBuffer(128).append("SELECT MAX(mcount), MAX(scount) FROM (").append("SELECT COUNT(*) AS mcount, 0 AS scount FROM ").append(dBManager.getTableName("MQMSG41")).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").append(" UNION ").append("SELECT 0 AS mcount, COUNT(*) AS scount FROM ").append(dBManager.getTableName("MQCONSTATE41")).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").append(")").toString();
    }

    public final String getTableNamePrefix() {
        return "MQTXN41";
    }

    public String getTableName() {
        return this.tableName;
    }

    public void insert(Connection connection, TransactionUID transactionUID, TransactionState transactionState, long l) throws BrokerException {
        this.insert(connection, transactionUID, transactionState, null, null, 1, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection connection, TransactionUID transactionUID, TransactionState transactionState, BrokerAddress brokerAddress, TransactionBroker[] transactionBrokerArray, int n, long l) throws BrokerException {
        block15: {
            PreparedStatement preparedStatement;
            block14: {
                long l2 = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (this.hasTransaction(connection, l2)) {
                        throw new BrokerException(this.br.getKString("B3015", transactionUID.toString()));
                    }
                    try {
                        preparedStatement = connection.prepareStatement(this.insertSQL);
                        preparedStatement.setLong(1, l2);
                        preparedStatement.setInt(2, n);
                        preparedStatement.setInt(3, transactionState.getState());
                        preparedStatement.setInt(4, transactionState.getType().intValue());
                        JMQXid jMQXid = transactionState.getXid();
                        if (jMQXid != null) {
                            preparedStatement.setString(5, jMQXid.toString());
                        } else {
                            preparedStatement.setNull(5, 12);
                        }
                        Util.setObject(preparedStatement, 6, transactionState);
                        Util.setObject(preparedStatement, 7, brokerAddress);
                        Util.setObject(preparedStatement, 8, transactionBrokerArray);
                        preparedStatement.setLong(9, l);
                        preparedStatement.setLong(10, transactionState.getExpirationTime());
                        preparedStatement.setLong(11, transactionState.getLastAccessTime());
                        preparedStatement.executeUpdate();
                    }
                    catch (Exception exception) {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4019", transactionUID), exception2);
                    }
                    if (!bl) break block14;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        Util.close(null, preparedStatement, connection);
                    } else {
                        Util.close(null, preparedStatement, null);
                    }
                    throw throwable;
                }
                Util.close(null, preparedStatement, connection);
                break block15;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void updateTransactionState(Connection connection, TransactionUID transactionUID, TransactionState transactionState) throws BrokerException {
        block18: {
            PreparedStatement preparedStatement;
            block17: {
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateTxnStateSQL);
                    preparedStatement.setInt(1, transactionState.getState());
                    Util.setObject(preparedStatement, 2, transactionState);
                    preparedStatement.setLong(3, transactionUID.longValue());
                    if (Globals.getHAEnabled()) {
                        preparedStatement.setString(4, dBManager.getBrokerID());
                    }
                    if (preparedStatement.executeUpdate() == 0) {
                        if (Globals.getHAEnabled()) {
                            String string = dBManager.getBrokerID();
                            BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                            if (brokerDAO.isBeingTakenOver(connection, string)) {
                                StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                try {
                                    HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, string);
                                    this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                throw storeBeingTakenOverException;
                            }
                        }
                        throw new BrokerException(this.br.getKString("B3016", transactionUID), 404);
                    }
                    if (!bl) break block17;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.updateTxnStateSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateTxnStateSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4137", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block18;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void updateTransactionHomeBroker(Connection connection, TransactionUID transactionUID, BrokerAddress brokerAddress) throws BrokerException {
        block18: {
            PreparedStatement preparedStatement;
            block17: {
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateTxnHomeBrokerSQL);
                    Util.setObject(preparedStatement, 1, brokerAddress);
                    preparedStatement.setLong(2, transactionUID.longValue());
                    if (Globals.getHAEnabled()) {
                        preparedStatement.setString(3, dBManager.getBrokerID());
                    }
                    if (preparedStatement.executeUpdate() == 0) {
                        if (Globals.getHAEnabled()) {
                            String string = dBManager.getBrokerID();
                            BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                            if (brokerDAO.isBeingTakenOver(connection, string)) {
                                StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                try {
                                    HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, string);
                                    this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                throw storeBeingTakenOverException;
                            }
                        }
                        throw new BrokerException(this.br.getKString("B3016", transactionUID), 404);
                    }
                    if (!bl) break block17;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.updateTxnHomeBrokerSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateTxnHomeBrokerSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4019", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block18;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void updateTransactionBrokers(Connection connection, TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray) throws BrokerException {
        block18: {
            PreparedStatement preparedStatement;
            block17: {
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateTxnBrokersSQL);
                    preparedStatement.setInt(1, 2);
                    Util.setObject(preparedStatement, 2, transactionBrokerArray);
                    preparedStatement.setLong(3, transactionUID.longValue());
                    if (Globals.getHAEnabled()) {
                        preparedStatement.setString(4, dBManager.getBrokerID());
                    }
                    if (preparedStatement.executeUpdate() == 0) {
                        if (Globals.getHAEnabled()) {
                            String string = dBManager.getBrokerID();
                            BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                            if (brokerDAO.isBeingTakenOver(connection, string)) {
                                StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                try {
                                    HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, string);
                                    this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                throw storeBeingTakenOverException;
                            }
                        }
                        throw new BrokerException(this.br.getKString("B3016", transactionUID), 404);
                    }
                    if (!bl) break block17;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.updateTxnBrokersSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateTxnBrokersSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4019", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block18;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void updateTransactionBrokerState(Connection connection, TransactionUID transactionUID, int n, TransactionBroker transactionBroker) throws BrokerException {
        block16: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block15: {
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(false);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTxnBrokersSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3016", transactionUID), 404);
                    }
                    TransactionBroker[] transactionBrokerArray = (TransactionBroker[])Util.readObject(resultSet, 1);
                    int n2 = resultSet.getInt(2);
                    if (n2 != n) {
                        Object[] objectArray = new Object[]{transactionBroker, transactionUID, TransactionState.toString(n), TransactionState.toString(n2)};
                        throw new BrokerException(this.br.getKString("B3219", objectArray), 409);
                    }
                    int n3 = transactionBrokerArray.length;
                    for (int i = 0; i < n3; ++i) {
                        TransactionBroker transactionBroker2 = transactionBrokerArray[i];
                        if (!transactionBroker2.equals(transactionBroker)) continue;
                        transactionBroker2.copyState(transactionBroker);
                        break;
                    }
                    this.updateTransactionBrokers(connection, transactionUID, transactionBrokerArray);
                    if (bl) {
                        connection.commit();
                    }
                    if (!bl) break block15;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.selectTxnBrokersSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnBrokersSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4019", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block16;
            }
            Util.close(resultSet, preparedStatement, null);
        }
    }

    public void updateAccessedTime(Connection connection, TransactionUID transactionUID, long l) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.updateAccessedTimeSQL);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, transactionUID.longValue());
            if (preparedStatement.executeUpdate() == 0) {
                throw new BrokerException(this.br.getKString("B3016", transactionUID), 404);
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateAccessedTimeSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4019", transactionUID), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void delete(Connection connection, TransactionUID transactionUID) throws BrokerException {
        block14: {
            PreparedStatement preparedStatement;
            block13: {
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteSQL);
                    preparedStatement.setLong(1, transactionUID.longValue());
                    if (preparedStatement.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3016", transactionUID), 404);
                    }
                    dBManager.getDAOFactory().getConsumerStateDAO().deleteByTransaction(connection, transactionUID);
                    if (bl) {
                        connection.commit();
                    }
                    if (!bl) break block13;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4138", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block14;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            DBManager dBManager = DBManager.getDBManager();
            string = new StringBuffer(128).append("EXISTS (SELECT ").append("ID").append(" FROM ").append(dBManager.getTableName("MQSES41")).append(" WHERE ").append("ID").append(" = ").append(this.tableName).append(".").append("STORE_SESSION_ID").append(" AND ").append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("')").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    public TransactionState getTransactionState(Connection connection, TransactionUID transactionUID) throws BrokerException {
        TransactionState transactionState;
        block13: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block12: {
                transactionState = null;
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTxnStateSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        try {
                            int n = resultSet.getInt(1);
                            transactionState = (TransactionState)Util.readObject(resultSet, 2);
                            transactionState.setState(n);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4128", iOException);
                        }
                    } else {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(l)), 404);
                    }
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnStateSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block13;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return transactionState;
    }

    public BrokerAddress getTransactionHomeBroker(Connection connection, TransactionUID transactionUID) throws BrokerException {
        BrokerAddress brokerAddress;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                brokerAddress = null;
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTxnHomeBrokerSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(l)), 404);
                    }
                    brokerAddress = (BrokerAddress)Util.readObject(resultSet, 1);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnHomeBrokerSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return brokerAddress;
    }

    public TransactionBroker[] getTransactionBrokers(Connection connection, TransactionUID transactionUID) throws BrokerException {
        TransactionBroker[] transactionBrokerArray;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                transactionBrokerArray = null;
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTxnBrokersSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(l)), 404);
                    }
                    transactionBrokerArray = (TransactionBroker[])Util.readObject(resultSet, 1);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnBrokersSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return transactionBrokerArray;
    }

    public TransactionInfo getTransactionInfo(Connection connection, TransactionUID transactionUID) throws BrokerException {
        TransactionInfo transactionInfo;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                transactionInfo = null;
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTxnInfoSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(l)), 404);
                    }
                    int n = resultSet.getInt(1);
                    int n2 = resultSet.getInt(2);
                    TransactionState transactionState = (TransactionState)Util.readObject(resultSet, 3);
                    transactionState.setState(n2);
                    BrokerAddress brokerAddress = (BrokerAddress)Util.readObject(resultSet, 4);
                    TransactionBroker[] transactionBrokerArray = (TransactionBroker[])Util.readObject(resultSet, 5);
                    transactionInfo = new TransactionInfo(transactionState, brokerAddress, transactionBrokerArray, n);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnInfoSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return transactionInfo;
    }

    public long getAccessedTime(Connection connection, TransactionUID transactionUID) throws BrokerException {
        long l;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                l = -1L;
                long l2 = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAccessedTimeSQL);
                    preparedStatement.setLong(1, l2);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(l2)), 404);
                    }
                    l = resultSet.getLong(1);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAccessedTimeSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return l;
    }

    public List getTransactionsByBroker(Connection connection, String string) throws BrokerException {
        ArrayList<TransactionUID> arrayList;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                arrayList = new ArrayList<TransactionUID>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTxnStatesByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        arrayList.add(new TransactionUID(resultSet.getLong(1)));
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnStatesByBrokerSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4235", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public List getRemoteTransactionsByBroker(Connection connection, String string) throws BrokerException {
        ArrayList<TransactionUID> arrayList;
        block12: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                arrayList = new ArrayList<TransactionUID>();
                boolean bl = false;
                String string2 = null;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    if (Globals.getHAEnabled()) {
                        string2 = this.selectRemoteTxnStatesByBrokerAndTypeSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                        preparedStatement.setInt(2, 2);
                    } else {
                        string2 = this.selectTxnStatesByBrokerAndTypeSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                        preparedStatement.setInt(2, 3);
                    }
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        arrayList.add(new TransactionUID(resultSet.getLong(1)));
                    }
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectRemoteTxnStatesByBrokerAndTypeSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4235", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block12;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public HashMap getTransactionStatesByBroker(Connection connection, String string) throws BrokerException {
        HashMap<TransactionUID, TransactionState> hashMap;
        block13: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block12: {
                hashMap = new HashMap<TransactionUID, TransactionState>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (string == null) {
                        string = dBManager.getBrokerID();
                    }
                    preparedStatement = connection.prepareStatement(this.selectTxnStatesByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        try {
                            long l = resultSet.getLong(1);
                            int n = resultSet.getInt(2);
                            TransactionState transactionState = (TransactionState)Util.readObject(resultSet, 3);
                            transactionState.setState(n);
                            hashMap.put(new TransactionUID(l), transactionState);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4128", iOException);
                        }
                    }
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnStatesByBrokerSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4032"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block13;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return hashMap;
    }

    public HashMap getRemoteTransactionStatesByBroker(Connection connection, String string) throws BrokerException {
        HashMap<TransactionUID, TransactionState> hashMap;
        block15: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block14: {
                hashMap = new HashMap<TransactionUID, TransactionState>();
                boolean bl = false;
                String string2 = null;
                preparedStatement = null;
                resultSet = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (string == null) {
                        string = dBManager.getBrokerID();
                    }
                    if (Globals.getHAEnabled()) {
                        string2 = this.selectRemoteTxnStatesByBrokerAndTypeSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                        preparedStatement.setInt(2, 2);
                    } else {
                        string2 = this.selectTxnStatesByBrokerAndTypeSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                        preparedStatement.setInt(2, 3);
                    }
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        try {
                            long l = resultSet.getLong(1);
                            int n = resultSet.getInt(2);
                            TransactionState transactionState = (TransactionState)Util.readObject(resultSet, 3);
                            transactionState.setState(n);
                            hashMap.put(new TransactionUID(l), transactionState);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4128", iOException);
                        }
                    }
                    if (!bl) break block14;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4032"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block15;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return hashMap;
    }

    public int[] getTransactionUsageInfo(Connection connection, TransactionUID transactionUID) throws BrokerException {
        int[] nArray;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                nArray = new int[]{0, 0};
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectUsageInfoSQL);
                    preparedStatement.setLong(1, l);
                    preparedStatement.setLong(2, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        nArray[0] = resultSet.getInt(1);
                        nArray[1] = resultSet.getInt(2);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectUsageInfoSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return nArray;
    }

    public boolean hasTransaction(Connection connection, long l) throws BrokerException {
        boolean bl;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAccessedTimeSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                    if (!bl2) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAccessedTimeSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", String.valueOf(l)), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return bl;
    }

    public void checkTransaction(Connection connection, long l) throws BrokerException {
        if (!this.hasTransaction(connection, l)) {
            throw new BrokerException(this.br.getKString("B3016", String.valueOf(l)), 404);
        }
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Transactions(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }
}

