/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.MQObjectInputStream;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnectionPool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class Util
implements DBConstants {
    static int insertDstDIDIndex = 1;
    static int insertDstDestIndex = 2;
    static int insertMsgMIDIndex = 1;
    static int insertMsgDIDIndex = 2;
    static int insertMsgSizeIndex = 3;
    static int insertMsgMsgIndex = 4;
    static int deleteStatesMIDIndex = 1;
    static int insertMsgStateMIDIndex = 1;
    static int insertMsgStateCUIDIndex = 2;
    static int insertMsgStateDIDIndex = 3;
    static int insertMsgStateStateIndex = 4;
    static int insertInterestCUIDIndex = 1;
    static int insertInterestIntIndex = 2;
    static int insertTxnTidIndex = 1;
    static int insertTxnStateIndex = 2;
    static int insertTxnStateObjIndex = 3;
    static int insertTxnAckTidIndex = 1;
    static int insertTxnAckAckIndex = 2;
    static int insertCCRTimeIndex = 1;
    static int insertCCRRecordIndex = 2;
    static int insertPropertyNameIndex = 1;
    static int insertPropertyValueIndex = 2;
    static boolean OracleBLOB_initialized = false;
    static Method OracleBLOB_empty_lob_method = null;
    static Method OracleBLOB_getBinaryOutputStream_method = null;
    static Method OraclePreparedStatement_setBLOB_method = null;

    static void setString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (string != null && string.length() > 0) {
            preparedStatement.setString(n, string);
        } else {
            preparedStatement.setNull(n, 12);
        }
    }

    static void setInt(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        if (n2 >= 0) {
            preparedStatement.setInt(n, n2);
        } else {
            preparedStatement.setNull(n, 4);
        }
    }

    static void setLong(PreparedStatement preparedStatement, int n, long l) throws SQLException {
        if (l >= 0L) {
            preparedStatement.setLong(n, l);
        } else {
            preparedStatement.setNull(n, -5);
        }
    }

    static void setObject(PreparedStatement preparedStatement, int n, Object object) throws IOException, SQLException {
        if (object == null) {
            preparedStatement.setNull(n, -4);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Util.setBytes(preparedStatement, n, byArray);
        }
    }

    static void setBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws IOException, SQLException {
        if (byArray == null) {
            preparedStatement.setNull(n, -4);
        } else {
            preparedStatement.setBytes(n, byArray);
        }
    }

    static void setBytesAsBinaryStream(PreparedStatement preparedStatement, int n, byte[] byArray) throws IOException, SQLException {
        if (byArray == null) {
            preparedStatement.setNull(n, -4);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, byArray.length);
            byteArrayInputStream.close();
        }
    }

    static Object readObject(ResultSet resultSet, int n) throws IOException, SQLException, ClassNotFoundException {
        InputStream inputStream = resultSet.getBinaryStream(n);
        if (inputStream == null) {
            return null;
        }
        MQObjectInputStream mQObjectInputStream = new MQObjectInputStream(inputStream);
        Object object = mQObjectInputStream.readObject();
        mQObjectInputStream.close();
        return object;
    }

    static byte[] readBytes(ResultSet resultSet, int n) throws IOException, SQLException {
        InputStream inputStream = resultSet.getBinaryStream(n);
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, 256)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        catch (EOFException eOFException) {
        }
        return byteArrayOutputStream.toByteArray();
    }

    static String getInsertDestinationSQL(String string) {
        return "INSERT INTO " + string + " (" + "DID" + ", " + "DEST" + ") VALUES ( ?,? )";
    }

    static String getInsertMessageSQL(String string) {
        return "INSERT INTO " + string + " (" + "MID" + ", " + "DID" + ", " + "MSGSIZE" + ", " + "MSG" + ") VALUES ( ?,?,?,? )";
    }

    static String getDeleteStatesSQL(String string) {
        return "DELETE FROM " + string + " WHERE " + "MID" + "=?";
    }

    static String getInsertMessageStateSQL(String string) {
        return "INSERT INTO " + string + " (" + "MID" + ", " + "CUID" + ", " + "DID" + ", " + "STATE" + ") " + "VALUES ( ?,?,?,? )";
    }

    static String getInsertInterestSQL(String string) {
        return "INSERT INTO " + string + " (" + "CUID" + ", " + "INTEREST" + ") VALUES ( ?,? )";
    }

    static PreparedStatement getPreparedStatement(Connection connection, String string) throws BrokerException {
        try {
            return connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            Globals.getLogger().log(32, "B4151", (Object)string, (Throwable)sQLException);
            throw new BrokerException(Globals.getBrokerResources().getString("B4151", string), sQLException);
        }
    }

    static String getInsertTxnSQL(String string) {
        return "INSERT INTO " + string + " (" + "TUID" + ", " + "STATE" + ", " + "TSTATEOBJ" + ") VALUES ( ?,?,? )";
    }

    static String getInsertTxnAckSQL(String string) {
        return "INSERT INTO " + string + " (" + "TUID" + ", " + "TXNACK" + ") VALUES ( ?,? )";
    }

    static String getInsertConfigRecordSQL(String string) {
        return "INSERT INTO " + string + " ( " + "RECORDTIME" + ", " + "RECORD" + ") " + "VALUES ( ?,? )";
    }

    static String getInsertPropertySQL(String string) {
        return "INSERT INTO " + string + " (" + "PROPNAME" + ", " + "PROPVALUE" + ") VALUES ( ?,? )";
    }

    public static void close(ResultSet resultSet, Statement statement, Connection connection) throws BrokerException {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException));
        }
        finally {
            if (connection != null) {
                DBConnectionPool.freeConnection(connection);
            }
        }
    }

    static boolean isAlphanumericString(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            char c;
            int n = string.length();
            for (int i = 0; i < n && ((bl = Character.isLetterOrDigit(c = string.charAt(i))) || c == '_'); ++i) {
            }
        }
        return bl;
    }

    static final void OracleBLOB_init() throws BrokerException {
        if (!OracleBLOB_initialized) {
            try {
                Class<?> clazz = Class.forName("oracle.sql.BLOB");
                OracleBLOB_empty_lob_method = clazz.getMethod("empty_lob", null);
                Class[] classArray = new Class[]{Integer.TYPE};
                OracleBLOB_getBinaryOutputStream_method = clazz.getMethod("getBinaryOutputStream", null);
                Class<?> clazz2 = Class.forName("oracle.jdbc.OraclePreparedStatement");
                classArray = new Class[]{Integer.TYPE, clazz};
                OraclePreparedStatement_setBLOB_method = clazz2.getMethod("setBLOB", classArray);
                OracleBLOB_initialized = true;
            }
            catch (Exception exception) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Oracle LOB extension APIs not found"), exception);
            }
        }
    }

    static final Blob OracleBLOB_empty_lob() throws Exception {
        if (!OracleBLOB_initialized) {
            Util.OracleBLOB_init();
        }
        Blob blob = (Blob)OracleBLOB_empty_lob_method.invoke(null, null);
        return blob;
    }

    static final OutputStream OracleBLOB_getBinaryOutputStream(Blob blob) throws Exception {
        if (!OracleBLOB_initialized) {
            Util.OracleBLOB_init();
        }
        OutputStream outputStream = (OutputStream)OracleBLOB_getBinaryOutputStream_method.invoke((Object)blob, null);
        return outputStream;
    }

    static void OraclePreparedStatement_setBLOB(PreparedStatement preparedStatement, int n, Blob blob) throws Exception {
        if (!OracleBLOB_initialized) {
            Util.OracleBLOB_init();
        }
        Object[] objectArray = new Object[]{new Integer(n), blob};
        OraclePreparedStatement_setBLOB_method.invoke((Object)preparedStatement, objectArray);
    }

    static final Blob setOracleBLOB(PreparedStatement preparedStatement, int n) throws Exception {
        Blob blob = null;
        blob = Util.OracleBLOB_empty_lob();
        Util.OraclePreparedStatement_setBLOB(preparedStatement, n, blob);
        return blob;
    }

    public static boolean isHADBTooManyLockError(Throwable throwable) {
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            return n == 2080 || n == 2096;
        }
        return false;
    }

    public static List getChunkDelimiters(ResultSet resultSet, int n, int n2) throws SQLException {
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        int n3 = 0;
        while (resultSet.next()) {
            if (++n3 != n2) continue;
            n3 = 0;
            arrayList.add(new Long(resultSet.getLong(n)));
        }
        arrayList.add(new Long(System.currentTimeMillis() + 60000L));
        return arrayList;
    }

    public static class RetryStrategy {
        DBManager dbMgr = null;
        Exception originalException = null;
        int retryCount = 0;
        int retryMax;
        long delayTime;

        public RetryStrategy() throws BrokerException {
            this(DBManager.getDBManager());
        }

        protected RetryStrategy(DBManager dBManager) {
            this.dbMgr = dBManager;
            this.delayTime = dBManager.txnRetryDelay;
            this.retryMax = dBManager.txnRetryMax;
        }

        protected RetryStrategy(DBManager dBManager, long l, int n) {
            this.dbMgr = dBManager;
            this.delayTime = l;
            this.retryMax = n;
        }

        public void assertShouldRetry(Exception exception) throws BrokerException {
            if (this.originalException == null) {
                this.originalException = exception;
            }
            if (exception instanceof StoreBeingTakenOverException && Globals.getHAEnabled()) {
                String string = Globals.getBrokerResources().getKString("B3203");
                Globals.getLogger().logStack(32, string, exception);
                Broker.getBroker().exit(BrokerStateHandler.getRestartCode(), string, 1, exception, true, false, true);
                throw (StoreBeingTakenOverException)exception;
            }
            Throwable throwable = exception;
            if (exception instanceof BrokerException) {
                throwable = exception.getCause();
            }
            boolean bl = false;
            if (throwable instanceof SQLException) {
                SQLException sQLException = (SQLException)throwable;
                int n = sQLException.getErrorCode();
                if (this.dbMgr.isHADB()) {
                    bl = n == 224 || n == 2078 || n == 2080 || n == 2096 || n == 2097 || n == 4576 || n == 12815 || n == 25012 || n == 25017 || n == 25018;
                } else if (this.dbMgr.isOracle()) {
                    bl = n == 16 || n == 44 || n == 17008 || n == 17009 || n == 17016 || n == 12535;
                } else {
                    String string = sQLException.getMessage();
                    boolean bl2 = bl = string != null && string.toLowerCase().indexOf("timed out") > 0;
                }
            }
            if (bl && this.retryCount < this.retryMax) {
                ++this.retryCount;
                try {
                    Thread.sleep(this.delayTime);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                Globals.getLogger().logStack(4, "Attempt to retry database operation due to unexpected error [retryCount=" + this.retryCount + ", delayTime=" + this.delayTime + "]", exception);
                this.delayTime *= 2L;
                return;
            }
            if (!(this.originalException instanceof BrokerException)) {
                this.originalException = new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to retry database operation"), this.originalException);
            }
            throw (BrokerException)this.originalException;
        }
    }
}

