/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.Bits;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class SysMessageID
implements Cloneable {
    public static final int ID_SIZE = 32;
    private static String ID_PREFIX = "ID:";
    protected int sequence;
    protected int port;
    protected long timestamp;
    protected IPAddress ip = new IPAddress();
    private String msgID = null;
    private boolean dirty = true;

    public SysMessageID() {
        this.clear();
    }

    public static void main(String[] stringArray) {
        SysMessageID sysMessageID = new SysMessageID();
        System.out.println("With MAC Address");
        System.out.println("------------------------");
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        sysMessageID.setIPAddress(inetAddress.getAddress(), IPAddress.getRandomMac());
        sysMessageID.setPort(123);
        sysMessageID.setTimestamp(123456L);
        sysMessageID.setSequence(5);
        System.out.println("\tOriginal: " + sysMessageID);
        SysMessageID sysMessageID2 = SysMessageID.get(sysMessageID.toString());
        System.out.println("\tDecoded: " + sysMessageID2);
        System.out.println("\tHash[o,n]=[" + sysMessageID.hashCode() + "," + sysMessageID2.hashCode() + "]");
        System.out.println("\tEquals: " + sysMessageID.equals(sysMessageID2) + " , " + sysMessageID2.equals(sysMessageID));
        System.out.println("\n\nWithout MAC Address");
        System.out.println("------------------------");
        sysMessageID = new SysMessageID();
        sysMessageID.setIPAddress(inetAddress.getAddress());
        sysMessageID.setPort(664);
        sysMessageID.setTimestamp(789012L);
        sysMessageID.setSequence(2);
        System.out.println("\tOriginal: " + sysMessageID);
        sysMessageID2 = SysMessageID.get(sysMessageID.toString());
        System.out.println("\tHash[o,n]=[" + sysMessageID.hashCode() + "," + sysMessageID2.hashCode() + "]");
        System.out.println("\tEquals: " + sysMessageID.equals(sysMessageID2) + " , " + sysMessageID2.equals(sysMessageID));
        System.out.println("\tDecoded: " + SysMessageID.get(sysMessageID.toString()));
        System.out.println("\n\nIPV6");
        System.out.println("------------------------");
        System.out.println("Testing IPV6 requires changes to OS");
    }

    public static SysMessageID get(String string) {
        String[] stringArray;
        SysMessageID sysMessageID = new SysMessageID();
        if (string.startsWith(ID_PREFIX)) {
            string = string.substring(ID_PREFIX.length());
        }
        if ((stringArray = string.split("-")).length != 4) {
            throw new RuntimeException("Bad Sysmessage ID");
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[2]);
        long l = Long.parseLong(stringArray[3]);
        IPAddress iPAddress = IPAddress.readFromString(stringArray[1]);
        sysMessageID.setPort(n2);
        sysMessageID.setSequence(n);
        sysMessageID.setTimestamp(l);
        sysMessageID.ip = iPAddress;
        return sysMessageID;
    }

    public void clear() {
        this.port = 0;
        this.sequence = 0;
        this.timestamp = 0L;
        this.ip.clear();
        this.dirty = true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SysMessageID)) {
            return false;
        }
        SysMessageID sysMessageID = (SysMessageID)object;
        return this.sequence == sysMessageID.sequence && this.timestamp == sysMessageID.timestamp && this.port == sysMessageID.port && this.ip.equals(sysMessageID.ip);
    }

    public int hashCode() {
        int n = this.port == 0 ? 1 : this.port;
        return (int)this.timestamp * n * this.sequence;
    }

    public String toString() {
        if (this.msgID == null || this.dirty) {
            this.msgID = new StringBuffer(128).append(this.sequence).append("-").append(this.ip.toString()).append("-").append(this.port).append("-").append(this.timestamp).toString();
            this.dirty = false;
        }
        return this.msgID;
    }

    public String getUniqueName() {
        return this.toString();
    }

    public String getUniqueNameOldFormat() {
        String string = String.valueOf(this.sequence) + String.valueOf(this.timestamp) + String.valueOf(this.port) + IPAddress.rawIPToString(this.ip.getAddress(), false);
        return string;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getPort() {
        return this.port;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte[] getIPAddress() {
        return this.ip.getAddress();
    }

    public void setSequence(int n) {
        this.dirty = true;
        this.sequence = n;
    }

    public void setPort(int n) {
        this.dirty = true;
        this.port = n;
    }

    public void setTimestamp(long l) {
        this.dirty = true;
        this.timestamp = l;
    }

    public void setIPAddress(byte[] byArray) throws IllegalArgumentException {
        this.ip.setAddress(byArray);
        this.dirty = true;
    }

    public void setIPAddress(byte[] byArray, byte[] byArray2) throws IllegalArgumentException {
        this.ip.setAddress(byArray);
        if (byArray2 != null && this.ip.getType() != 2) {
            this.ip.setMac(byArray2);
        }
        this.dirty = true;
    }

    public void writeID(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.timestamp);
        this.ip.writeAddress(dataOutput);
        dataOutput.writeInt(this.port);
        dataOutput.writeInt(this.sequence);
        if (dataOutput instanceof DataOutputStream) {
            ((DataOutputStream)dataOutput).flush();
        }
    }

    public byte[] getRawID() {
        byte[] byArray = new byte[32];
        int n = 0;
        n = Bits.put(byArray, n, this.timestamp);
        n = Bits.put(byArray, n, this.ip.getAddressUnsafe());
        n = Bits.put(byArray, n, this.port);
        Bits.put(byArray, n, this.sequence);
        return byArray;
    }

    public void readID(DataInput dataInput) throws IOException {
        this.timestamp = dataInput.readLong();
        this.ip.readAddress(dataInput);
        this.port = dataInput.readInt();
        this.sequence = dataInput.readInt();
    }

    public Object clone() {
        try {
            SysMessageID sysMessageID = (SysMessageID)super.clone();
            sysMessageID.ip = (IPAddress)this.ip.clone();
            return sysMessageID;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("SysMessageID: Could not clone: " + cloneNotSupportedException);
            return null;
        }
    }
}

