/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)BrokerCmdException.java	1.23 06/27/07
 */ 

package com.sun.messaging.jmq.admin.apps.broker;

/**
 * This exception is thrown when problems are
 * encountered when validating the information
 * that is provided to execute commands. Examples
 * of errors include:
 * <UL>
 * <LI>bad command type
 * <LI>missing mandatory values
 * </UL>
 *
 * <P>
 * The information that is provided by the user is encapsulated
 * in a BrokerCmdProperties object. This exception will
 * contain a BrokerCmdProperties object to encapsulate
 * the erroneous information.
 **/

public class BrokerCmdException extends Exception  {

    public static final int		NO_CMD_SPEC		= 0;
    public static final int		BAD_CMD_SPEC		= 1;
    public static final int		TARGET_NAME_NOT_SPEC	= 2;
    public static final int		CMDARG_NOT_SPEC		= 3;
    public static final int		BAD_CMDARG_SPEC		= 4;
    public static final int		DEST_NAME_NOT_SPEC	= 5;
    public static final int		TARGET_ATTRS_NOT_SPEC	= 6;
    public static final int		DEST_TYPE_NOT_SPEC	= 7;
    public static final int		FLAVOUR_TYPE_INVALID	= 8;
    public static final int		INVALID_INTEGER_VALUE	= 9;
    public static final int		INVALID_DEST_TYPE	= 10;
    public static final int		CLIENT_ID_NOT_SPEC	= 11;
    public static final int		BAD_ATTR_SPEC_CREATE_DST_QUEUE	= 12;
    public static final int		BAD_ATTR_SPEC_CREATE_DST_TOPIC	= 13;
    public static final int		BAD_ATTR_SPEC_UPDATE_BKR	= 14;
    public static final int		BAD_ATTR_SPEC_UPDATE_DST_QUEUE	= 15;
    public static final int		BAD_ATTR_SPEC_UPDATE_DST_TOPIC	= 16;
    public static final int		BAD_ATTR_SPEC_UPDATE_SVC	= 17;
    public static final int		INVALID_BOOLEAN_VALUE	= 18;
    public static final int		INVALID_LOG_LEVEL_VALUE	= 19;
    public static final int		INVALID_METRIC_INTERVAL	= 20;
    public static final int		INVALID_METRIC_TYPE	= 21;
    public static final int		INVALID_BYTE_VALUE	= 22;
    public static final int		INVALID_RECV_TIMEOUT_VALUE= 23;
    public static final int		BAD_ATTR_SPEC_GETATTR = 24;
    public static final int		SINGLE_TARGET_ATTR_NOT_SPEC = 25;
    public static final int		BAD_ATTR_SPEC_PAUSE_DST		= 26;
    public static final int		INVALID_PAUSE_TYPE		= 27;
    public static final int		INVALID_METRIC_DST_TYPE		= 28;
    public static final int		INVALID_METRIC_SAMPLES		= 29;
    public static final int		INVALID_NUM_RETRIES_VALUE	= 30;
    public static final int		INVALID_LIMIT_BEHAV_VALUE	= 31;
    public static final int		DST_QDP_VALUE_INVALID		= 32;
    public static final int		BKR_QDP_VALUE_INVALID		= 33;
    public static final int		READ_PASSFILE_FAIL		= 34;
    public static final int		INVALID_TIME			= 35;
    public static final int		INVALID_RESET_TYPE		= 36;
    public static final int		MSG_ID_NOT_SPEC			= 37;
    public static final int		UPDATE_DST_ATTR_SPEC_CREATE_ONLY_QUEUE	= 38;
    public static final int		UPDATE_DST_ATTR_SPEC_CREATE_ONLY_TOPIC	= 39;

    /**
     * Props object encapsulating the user specified options/commands.
     **/
    private BrokerCmdProperties brokerCmdProps;
    private String validCmdArgs[];
    private String validAttrs[];
    private String badAttr;
    private String badValue;
    private int type;
    // this is a convenient storage place for a single value
    private String errorString = null;
    private Exception           linkedEx;

    /**
     * Constructs an BrokerCmdException
     */ 
    public BrokerCmdException() {
        super();
        brokerCmdProps = null;
    }

    /** 
     * Constructs an BrokerCmdException with type
     *
     * @param  type       type of exception 
     **/
    public BrokerCmdException(int type) {
        super();
        brokerCmdProps = null;
	this.type = type;
    }

    /** 
     * Constructs an BrokerCmdException with reason
     *
     * @param  reason        a description of the exception
     **/
    public BrokerCmdException(String reason) {
        super(reason);
        brokerCmdProps = null;
    }

    /**
     * Gets the properties object that encapsulates the user specified
     * options/commands.
     *
     * @return the properties object that encapsulates the user 
     *		specified options/commands.
     **/
    public BrokerCmdProperties getProperties() {
        return (brokerCmdProps);
    }

    /**
     * Sets the properties object that encapsulates the user specified
     * options/commands.
     *
     * @param p		the properties object that encapsulates the user 
     *			specified options/commands.
     **/
    public synchronized void setProperties(BrokerCmdProperties p) {
        brokerCmdProps = p;
    }

    /**
     * Gets the type of exception.
     *
     * @return the exception type.
     **/
    public synchronized int getType() {
	return (type);
    }

    /**
     * Sets the valid cmd args - to be used for exceptions of type
     * BAD_CMDARG_SPEC when printing out the error message.
     *
     * @param validCmdArgs	the array of Strings that contains
     *				the valid command arguments for
     *				the command specified in the
     *				BrokerCmdProperties object.
     **/
    public void setValidCmdArgs(String validCmdArgs[]) {
	this.validCmdArgs = validCmdArgs;
    }

    /**
     * Gets the valid cmd args - to be used for exceptions of type
     * BAD_CMDARG_SPEC when printing out the error message.
     *
     * @return	The array of Strings that contains
     *		the valid command arguments for
     *		the command specified in the
     *		BrokerCmdProperties object.
     **/
    public String[] getValidCmdArgs() {
	return (validCmdArgs);
    }

    /**
     * Sets the valid attrs - to be used for exceptions of type
     * BAD_ATTR_SPEC_* when printing out the error message.
     *
     * @param validAttrs	the array of Strings that contains
     *				the valid attributes for
     *				the command specified in the
     *				BrokerCmdProperties object.
     **/
    public void setValidAttrs(String validAttrs[]) {
	this.validAttrs = validAttrs;
    }

    /**
     * Gets the valid attrs - to be used for exceptions of type
     * BAD_ATTR_SPEC_* when printing out the error message.
     *
     * @return	The array of Strings that contains
     *		the valid attributes for
     *		the command specified in the
     *		BrokerCmdProperties object.
     **/
    public String[] getValidAttrs() {
	return (validAttrs);
    }

    /**
     * Sets the bad attr that caused the BAD_ATTR_SPEC_* exception.
     * This will be used when printing out the error message.
     *
     * @param badAttr		the bad attribute causing the exception.
     **/
    public void setBadAttr(String badAttr)  {
	this.badAttr = badAttr;
    }

    /**
     * Gets the bad attr that caused the BAD_ATTR_SPEC_* exception.
     * This will be used when printing out the error message.
     *
     * @return	The bad attribute causing the exception.
     **/
    public String getBadAttr()  {
	return (badAttr);
    }

    /**
     * Sets the bad value that caused the exception.
     * This will be used when printing out the error message.
     *
     * @param badAttr		the bad value causing the exception.
     **/
    public void setBadValue(String badValue)  {
	this.badValue = badValue;
    }

    /**
     * Returns the bad value that caused the exception.
     * This will be used when printing out the error message.
     *
     * @return	The bad value causing the exception.
     **/
    public String getBadValue()  {
	return (badValue);
    }

    /**
     * Sets an error string.  This can be used to print a more explicit error message.
     **/
    public void setErrorString(String value) {
	this.errorString = value;
    }

    /**
     * Gets an error string.
     *
     * @return errorString
     **/
    public String getErrorString() {
	return (errorString);
    }

    /**
     * Set linked exception.
     *
     * @param Exception relevant to this one.
     **/
    public void setLinkedException(Exception ex)  {
        linkedEx = ex;
    }

    /**
     * Get linked exception.
     *
     * @return Exception relevant to this one.
     **/
    public Exception getLinkedException()  {
        return (linkedEx);
    }
}
