/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)URLEndpoint.java	1.3 07/02/07
 */ 

package javax.xml.messaging;

/**
 * A special case of the <code>Endpoint</code> class used for simple
 * applications that want to communicate directly with another
 * SOAP-based application in a point-to-point fashion instead of 
 * going through a messaging provider.
 * <P>
 * A <code>URLEndpoint</code> object contains a URL, which is used to make
 * connections to the remote party.
 * A standalone client can pass a <code>URLEndpoint</code> object 
 * to the <code>SOAPConnection</code> method <code>call</code>
 * to send a message synchronously. 
 *
 */
public class URLEndpoint extends Endpoint {
    /**
     * Constructs a new <code>URLEndpoint</code> object using the given URL. 
     *
     * @param url a <code>String</code> giving the URL to use in constructing
     *         the new <code>URLEndpoint</code> object
     */
    public URLEndpoint(String url) {
        super(url);
    }
    
    /**
     * Gets the URL associated with this <code>URLEndpoint</code> object.
     *
     * @return a <code>String</code> giving the URL associated with this 
     *         <code>URLEndpoint</code> object
     */
    public String getURL() {
        return id;
    }
}

