/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import org.antlr.analysis.SemanticContext;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

public class Label
implements Comparable,
Cloneable {
    public static final int INVALID = -6;
    public static final int EPSILON = -5;
    public static final String EPSILON_STR = "<EPSILON>";
    public static final int SEMPRED = -4;
    public static final int SET = -3;
    public static final int EOT = -2;
    public static final int EOF = -1;
    public static final int NUM_FAUX_LABELS = 6;
    public static final int MIN_ATOM_VALUE = -2;
    public static final int MIN_CHAR_VALUE = 0;
    public static final int MAX_CHAR_VALUE = 65534;
    public static final int EOR_TOKEN_TYPE = 1;
    public static final int DOWN = 2;
    public static final int UP = 3;
    public static final int MIN_TOKEN_TYPE = 4;
    protected int label;
    protected SemanticContext semanticContext;
    protected IntSet labelSet;

    public Object clone() {
        Label l;
        try {
            l = (Label)super.clone();
            l.label = this.label;
            l.labelSet = new IntervalSet();
            l.labelSet.addAll(this.labelSet);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return l;
    }

    public void add(Label a) {
        if (this.isAtom()) {
            this.labelSet = IntervalSet.of(this.label);
            this.label = -3;
            if (a.isAtom()) {
                this.labelSet.add(a.getAtom());
            } else if (a.isSet()) {
                this.labelSet.addAll(a.getSet());
            } else {
                throw new IllegalStateException("can't add element to Label of type " + this.label);
            }
            return;
        }
        if (this.isSet()) {
            if (a.isAtom()) {
                this.labelSet.add(a.getAtom());
            } else if (a.isSet()) {
                this.labelSet.addAll(a.getSet());
            } else {
                throw new IllegalStateException("can't add element to Label of type " + this.label);
            }
            return;
        }
        throw new IllegalStateException("can't add element to Label of type " + this.label);
    }

    public boolean isAtom() {
        boolean bl = false;
        if (this.label >= -2) {
            bl = true;
        }
        return bl;
    }

    public boolean isEpsilon() {
        boolean bl = false;
        if (this.label == -5) {
            bl = true;
        }
        return bl;
    }

    public boolean isSemanticPredicate() {
        boolean bl = false;
        if (this.label == -4) {
            bl = true;
        }
        return bl;
    }

    public boolean isSet() {
        boolean bl = false;
        if (this.label == -3) {
            bl = true;
        }
        return bl;
    }

    public int getAtom() {
        if (this.isAtom()) {
            return this.label;
        }
        return -6;
    }

    public IntSet getSet() {
        if (this.label != -3) {
            return IntervalSet.of(this.label);
        }
        return this.labelSet;
    }

    public void setSet(IntSet set) {
        this.label = -3;
        this.labelSet = set;
    }

    public SemanticContext getSemanticContext() {
        return this.semanticContext;
    }

    public boolean matches(int atom) {
        if (this.label == atom) {
            return true;
        }
        if (this.isSet()) {
            return this.labelSet.member(atom);
        }
        return false;
    }

    public boolean matches(IntSet set) {
        if (this.isAtom()) {
            return set.member(this.getAtom());
        }
        if (this.isSet()) {
            return this.getSet().and(set).isNil() ^ true;
        }
        return false;
    }

    public boolean matches(Label other) {
        if (other.isSet()) {
            return this.matches(other.getSet());
        }
        if (other.isAtom()) {
            return this.matches(other.getAtom());
        }
        return false;
    }

    public int hashCode() {
        switch (this.label) {
            case -3: {
                return this.labelSet.hashCode();
            }
            case -4: {
                return this.semanticContext.hashCode();
            }
        }
        return this.label;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.label != ((Label)o).label) {
            return false;
        }
        if (this.label == -3) {
            return this.labelSet.equals(((Label)o).labelSet);
        }
        return true;
    }

    public int compareTo(Object o) {
        return this.label - ((Label)o).label;
    }

    public String toString() {
        switch (this.label) {
            case -3: {
                return this.labelSet.toString();
            }
            case -4: {
                return "{" + this.semanticContext + "}?";
            }
        }
        return String.valueOf(this.label);
    }

    public String toString(Grammar g) {
        switch (this.label) {
            case -3: {
                return this.labelSet.toString(g);
            }
            case -4: {
                return "{" + this.semanticContext + "}?";
            }
        }
        return g.getTokenDisplayName(this.label);
    }

    public Label(int label) {
        this.label = label;
    }

    public Label(GrammarAST predicateASTNode) {
        this(-4);
        this.semanticContext = new SemanticContext.Predicate(predicateASTNode);
    }

    public Label(SemanticContext semCtx) {
        this(-4);
        this.semanticContext = semCtx;
    }

    public Label(IntSet labelSet) {
        int singleAtom = labelSet.getSingleElement();
        if (singleAtom != -6) {
            this.label = singleAtom;
            return;
        }
        this.label = -3;
        this.labelSet = labelSet;
    }
}

