/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.util.List;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DecisionProbe;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.BitSet;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarNonDeterminismMessage;
import org.antlr.tool.Message;
import org.antlr.tool.RecursionOverflowMessage;

public class TestSemanticPredicates
extends BaseTest {
    public void testPredsButSyntaxResolves() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : {p1}? A | {p2}? B ;");
        String expecting = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testLL_1_Pred() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : {p1}? A | {p2}? A ;");
        String expecting = ".s0-A->.s1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testLL_2_Pred() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : {p1}? A B | {p2}? A B ;");
        String expecting = ".s0-A->.s1\n.s1-B->.s2\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testPredicatedLoop() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : ( {p1}? A | {p2}? A )+;");
        String expecting = ".s0-A->.s2\n.s0-EOF->:s1=>3\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testPredicatedToStayInLoop() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : ( {p1}? A )+ (A)+;");
        String expecting = ".s0-A->.s1\n.s1-{!(p1)}?->:s2=>1\n.s1-{p1}?->:s3=>2\n";
    }

    public void testAndPredicates() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : {p1}? {p1a}? A | {p2}? A ;");
        String expecting = ".s0-A->.s1\n.s1-{(p1&&p1a)}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testOrPredicates() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b | {p2}? A ;\nb : {p1}? A | {p1a}? A ;");
        String expecting = ".s0-A->.s1\n.s1-{(p1||p1a)}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testIgnoresHoistingDepthGreaterThanZero() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : A {p1}? | A {p2}?;");
        String expecting = ".s0-A->:s1=>1\n";
        this.checkDecision(g, 1, expecting, new int[]{2}, new int[]{1, 2}, "A", null, null, 2);
    }

    public void testHoist2() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b | c ;\nb : {p1}? A ;\nc : {p2}? A ;\n");
        String expecting = ".s0-A->.s1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testHoistCorrectContext() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b | {p2}? ID ;\nb : {p1}? ID | INT ;\n");
        String expecting = ".s0-ID->.s1\n.s0-INT->:s2=>1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testDefaultPredNakedAltIsLast() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b | ID ;\nb : {p1}? ID | INT ;\n");
        String expecting = ".s0-ID->.s1\n.s0-INT->:s2=>1\n.s1-{p1}?->:s2=>1\n.s1-{true}?->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testDefaultPredNakedAltNotLast() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : ID | b ;\nb : {p1}? ID | INT ;\n");
        String expecting = ".s0-ID->.s1\n.s0-INT->:s3=>2\n.s1-{!(p1)}?->:s2=>1\n.s1-{p1}?->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testLeftRecursivePred() throws Exception {
        Grammar g = new Grammar("parser grammar P;\ns : a ;\na : {p1}? a | ID ;\n");
        String expecting = ".s0-ID->.s1\n.s1-{p1}?->:s2=>1\n.s1-{true}?->:s3=>2\n";
        DecisionProbe.verbose = true;
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        CodeGenerator generator = new CodeGenerator(this.newTool(), g, "Java");
        g.setCodeGenerator(generator);
        if (g.getNumberOfDecisions() == 0) {
            g.createNFAs();
            g.createLookaheadDFAs();
        }
        DFA dfa = g.getLookaheadDFA(1);
        FASerializer serializer = new FASerializer(g);
        String result = serializer.serialize(dfa.startState);
        TestSemanticPredicates.assertEquals((String)expecting, (String)result);
        TestSemanticPredicates.assertEquals((String)"unexpected number of expected problems", (int)1, (int)equeue.size());
        Message msg = (Message)equeue.warnings.get(0);
        TestSemanticPredicates.assertTrue((String)"warning must be a recursion overflow msg", (boolean)(msg instanceof RecursionOverflowMessage));
    }

    public void testIgnorePredFromLL2AltLastAltIsDefaultTrue() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : {p1}? A B | A C | {p2}? A | {p3}? A | A ;\n");
        String expecting = ".s0-A->.s1\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n.s1-{p2}?->:s4=>3\n.s1-{p3}?->:s5=>4\n.s1-{true}?->:s6=>5\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testIgnorePredFromLL2AltPredUnionNeeded() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : {p1}? A B | A C | {p2}? A | A | {p3}? A ;\n");
        String expecting = ".s0-A->.s1\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n.s1-{!((p3||p2))}?->:s5=>4\n.s1-{p2}?->:s4=>3\n.s1-{p3}?->:s6=>5\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testPredGets2SymbolSyntacticContext() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b | A B | C ;\nb : {p1}? A B ;\n");
        String expecting = ".s0-A->.s1\n.s0-C->:s5=>3\n.s1-B->.s2\n.s2-{p1}?->:s3=>1\n.s2-{true}?->:s4=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testMatchesLongestThenTestPred() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b | c ;\nb : {p}? A ;\nc : {q}? (A|B)+ ;");
        String expecting = ".s0-A->.s1\n.s0-B->:s3=>2\n.s1-{p}?->:s2=>1\n.s1-{q}?->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testPredsUsedAfterRecursionOverflow() throws Exception {
        Grammar g = new Grammar("grammar P;\ns : {p1}? e '.' | {p2}? e ':' ;\ne : '(' e ')' | INT ;\n");
        String expecting = ".s0-'('->.s1\n.s0-INT->.s7\n.s1-'('->.s2\n.s1-INT->.s5\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n.s5-')'->.s6\n.s6-'.'->:s3=>1\n.s6-':'->:s4=>2\n.s7-'.'->:s3=>1\n.s7-':'->:s4=>2\n";
        DecisionProbe.verbose = true;
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        CodeGenerator generator = new CodeGenerator(this.newTool(), g, "Java");
        g.setCodeGenerator(generator);
        if (g.getNumberOfDecisions() == 0) {
            g.createNFAs();
            g.createLookaheadDFAs();
        }
        TestSemanticPredicates.assertEquals((String)"unexpected number of expected problems", (int)0, (int)equeue.size());
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testLexerMatchesLongestThenTestPred() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nB : {p}? 'a' ;\nC : {q}? ('a'|'b')+ ;");
        String expecting = ".s0-'a'->.s1\n.s0-'b'->:s4=>2\n.s1-'a'..'b'->:s4=>2\n.s1-<EOT>->.s2\n.s2-{p}?->:s3=>1\n.s2-{q}?->:s4=>2\n";
        this.checkDecision(g, 2, expecting, null, null, null, null, null, 0);
    }

    public void testGatedPred() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nB : {p}? => 'a' ;\nC : {q}? => ('a'|'b')+ ;");
        String expecting = ".s0-'a'&&{(p||q)}?->.s1\n.s0-'b'&&{q}?->:s4=>2\n.s1-'a'..'b'&&{q}?->:s4=>2\n.s1-<EOT>&&{(p||q)}?->.s2\n.s2-{p}?->:s3=>1\n.s2-{q}?->:s4=>2\n";
        this.checkDecision(g, 2, expecting, null, null, null, null, null, 0);
    }

    public void testGatedPredHoistsAndCanBeInStopState() throws Exception {
        Grammar g = new Grammar("grammar u;\na : b+ ;\nb : 'x' | {p}?=> 'y' ;");
        String expecting = ".s0-'x'->:s2=>1\n.s0-'y'&&{p}?->:s3=>1\n.s0-EOF->:s1=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testGatedPredInCyclicDFA() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : {p}?=> ('a')+ 'x' ;\nB : {q}?=> ('a'|'b')+ 'x' ;");
        String expecting = ".s0-'a'&&{(p||q)}?->.s1\n.s0-'b'&&{q}?->:s5=>2\n.s1-'a'&&{(p||q)}?->.s1\n.s1-'b'&&{q}?->:s5=>2\n.s1-'x'&&{(p||q)}?->.s2\n.s2-<EOT>&&{(p||q)}?->.s3\n.s3-{p}?->:s4=>1\n.s3-{q}?->:s5=>2\n";
        this.checkDecision(g, 3, expecting, null, null, null, null, null, 0);
    }

    public void testGatedPredDoesNotForceAllToBeGated() throws Exception {
        Grammar g = new Grammar("grammar w;\na : b | c ;\nb : {p}? B ;\nc : {q}?=> d ;\nd : {r}? C ;\n");
        String expecting = ".s0-B->:s1=>1\n.s0-C&&{q}?->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testGatedPredDoesNotForceAllToBeGated2() throws Exception {
        Grammar g = new Grammar("grammar w;\na : b | c ;\nb : {p}? B ;\nc : {q}?=> d ;\nd : {r}?=> C\n  | B\n  ;\n");
        String expecting = ".s0-B->.s1\n.s0-C&&{(q&&r)}?->:s3=>2\n.s1-{p}?->:s2=>1\n.s1-{q}?->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testORGatedPred() throws Exception {
        Grammar g = new Grammar("grammar w;\na : b | c ;\nb : {p}? B ;\nc : {q}?=> d ;\nd : {r}?=> C\n  | {s}?=> B\n  ;\n");
        String expecting = ".s0-B->.s1\n.s0-C&&{(q&&r)}?->:s3=>2\n.s1-{(q&&s)}?->:s3=>2\n.s1-{p}?->:s2=>1\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, null, 0);
    }

    public void testIncompleteSemanticHoistedContext() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na : b | B;\nb : {p1}? B | B ;");
        String expecting = ".s0-B->:s1=>1\n";
        this.checkDecision(g, 1, expecting, new int[]{2}, new int[]{1, 2}, "B", new int[]{1}, null, 3);
    }

    public void testIncompleteSemanticHoistedContext2() throws Exception {
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Grammar g = new Grammar("parser grammar t;\na : b | B;\nb : {p1}? B | B D ;");
        String expecting = ".s0-B->:s1=>1\n";
        this.checkDecision(g, 1, expecting, new int[]{2}, new int[]{1, 2}, "B", new int[]{1}, null, 3);
    }

    public void testTooFewSemanticPredicates() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : {p1}? A | A | A ;");
        String expecting = ".s0-A->:s1=>1\n";
        this.checkDecision(g, 1, expecting, new int[]{2, 3}, new int[]{1, 2, 3}, "A", null, null, 2);
    }

    public void testPredWithK1() throws Exception {
        Grammar g = new Grammar("\tlexer grammar TLexer;\nA\noptions {\n  k=1;\n}\n  : {p1}? ('x')+ '.'\n  | {p2}? ('x')+ '.'\n  ;\n");
        String expecting = ".s0-'x'->.s1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = null;
        String ambigInput = null;
        int[] insufficientPredAlts = null;
        int[] danglingAlts = null;
        int numWarnings = 0;
        this.checkDecision(g, 3, expecting, unreachableAlts, nonDetAlts, ambigInput, insufficientPredAlts, danglingAlts, numWarnings);
    }

    public void testPredWithArbitraryLookahead() throws Exception {
        Grammar g = new Grammar("\tlexer grammar TLexer;\nA : {p1}? ('x')+ '.'\n  | {p2}? ('x')+ '.'\n  ;\n");
        String expecting = ".s0-'x'->.s1\n.s1-'.'->.s2\n.s1-'x'->.s1\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = null;
        String ambigInput = null;
        int[] insufficientPredAlts = null;
        int[] danglingAlts = null;
        int numWarnings = 0;
        this.checkDecision(g, 3, expecting, unreachableAlts, nonDetAlts, ambigInput, insufficientPredAlts, danglingAlts, numWarnings);
    }

    public void testUniquePredicateOR() throws Exception {
        Grammar g = new Grammar("parser grammar v;\n\na : {a}? b\n  | {b}? b\n  ;\n\nb : {c}? (X)+ ;\n\nc : a\n  | b\n  ;\n");
        String expecting = ".s0-X->.s1\n.s1-{((a&&c)||(b&&c))}?->:s2=>1\n.s1-{c}?->:s3=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = null;
        String ambigInput = null;
        int[] insufficientPredAlts = null;
        int[] danglingAlts = null;
        int numWarnings = 0;
        this.checkDecision(g, 3, expecting, unreachableAlts, nonDetAlts, ambigInput, insufficientPredAlts, danglingAlts, numWarnings);
    }

    public void _template() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A | B;");
        String expecting = "\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "L ID R";
        int[] insufficientPredAlts = new int[]{1};
        int[] danglingAlts = null;
        int numWarnings = 1;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, insufficientPredAlts, danglingAlts, numWarnings);
    }

    protected void checkDecision(Grammar g, int decision, String expecting, int[] expectingUnreachableAlts, int[] expectingNonDetAlts, String expectingAmbigInput, int[] expectingInsufficientPredAlts, int[] expectingDanglingAlts, int expectingNumWarnings) throws Exception {
        GrammarNonDeterminismMessage nondetMsg;
        DecisionProbe.verbose = true;
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        CodeGenerator generator = new CodeGenerator(this.newTool(), g, "Java");
        g.setCodeGenerator(generator);
        if (g.getNumberOfDecisions() == 0) {
            g.createNFAs();
            g.createLookaheadDFAs();
        }
        if (equeue.size() != expectingNumWarnings) {
            System.err.println("Warnings issued: " + equeue);
        }
        TestSemanticPredicates.assertEquals((String)"unexpected number of expected problems", (int)expectingNumWarnings, (int)equeue.size());
        DFA dfa = g.getLookaheadDFA(decision);
        FASerializer serializer = new FASerializer(g);
        String result = serializer.serialize(dfa.startState);
        List unreachableAlts = dfa.getUnreachableAlts();
        if (expectingUnreachableAlts != null) {
            BitSet s = new BitSet();
            s.addAll(expectingUnreachableAlts);
            BitSet s2 = new BitSet();
            s2.addAll(unreachableAlts);
            TestSemanticPredicates.assertEquals((String)"unreachable alts mismatch", (Object)s, (Object)s2);
        } else {
            TestSemanticPredicates.assertEquals((String)"unreachable alts mismatch", (int)0, (int)unreachableAlts.size());
        }
        if (expectingAmbigInput != null) {
            Message msg = (Message)equeue.warnings.get(0);
            TestSemanticPredicates.assertTrue((String)("expecting nondeterminism; found " + msg.getClass().getName()), (boolean)(msg instanceof GrammarNonDeterminismMessage));
            GrammarNonDeterminismMessage nondetMsg2 = this.getNonDeterminismMessage(equeue.warnings);
            List labels = nondetMsg2.probe.getSampleNonDeterministicInputSequence(nondetMsg2.problemState);
            String input = nondetMsg2.probe.getInputSequenceDisplay(labels);
            TestSemanticPredicates.assertEquals((String)expectingAmbigInput, (String)input);
        }
        if (expectingNonDetAlts != null) {
            nondetMsg = this.getNonDeterminismMessage(equeue.warnings);
            TestSemanticPredicates.assertNotNull((String)("found no nondet alts; expecting: " + this.str(expectingNonDetAlts)), (Object)nondetMsg);
            List nonDetAlts = nondetMsg.probe.getNonDeterministicAltsForState(nondetMsg.problemState);
            BitSet s = new BitSet();
            s.addAll(expectingNonDetAlts);
            BitSet s2 = new BitSet();
            s2.addAll(nonDetAlts);
            TestSemanticPredicates.assertEquals((String)"nondet alts mismatch", (Object)s, (Object)s2);
        } else {
            nondetMsg = this.getNonDeterminismMessage(equeue.warnings);
            TestSemanticPredicates.assertNull((String)"found nondet alts, but expecting none", (Object)nondetMsg);
        }
        TestSemanticPredicates.assertEquals((String)expecting, (String)result);
    }

    protected GrammarNonDeterminismMessage getNonDeterminismMessage(List warnings) {
        int i = 0;
        while (i < warnings.size()) {
            Message m = (Message)warnings.get(i);
            if (m instanceof GrammarNonDeterminismMessage) {
                return (GrammarNonDeterminismMessage)m;
            }
            ++i;
        }
        return null;
    }

    protected String str(int[] elements) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            if (i > 0) {
                buf.append(", ");
            }
            int element = elements[i];
            buf.append(element);
            ++i;
        }
        return buf.toString();
    }
}

