/*
 * Decompiled with CFR 0.152.
 */
package com.loomcom.ant.tasks.jarbundler;

import com.loomcom.ant.tasks.jarbundler.AppBundleProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class PropertyListWriter {
    private PrintWriter mOut;
    private AppBundleProperties mProps;

    public PropertyListWriter(AppBundleProperties p) {
        this.mProps = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(File fileName) throws BuildException {
        try {
            this.mOut = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
        }
        catch (IOException ex) {
            throw new BuildException("Unable to open " + fileName + " for writing.");
        }
        try {
            Hashtable javaProperties;
            this.mOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.mOut.println("<!DOCTYPE plist SYSTEM \"file://localhost/System/Library/DTDs/PropertyList.dtd\">");
            this.mOut.println("<plist version=\"1.0\">");
            this.openDict(0);
            this.writeKey(1, "CFBundleName");
            this.writeString(1, this.mProps.getCFBundleName());
            this.writeKey(1, "CFBundleVersion");
            this.writeString(1, this.mProps.getCFBundleVersion());
            this.writeKey(1, "CFBundleAllowMixedLocalizations");
            this.writeString(1, new Boolean(this.mProps.getCFBundleAllowMixedLocalizations()).toString());
            if (this.mProps.getCFBundleGetInfoString() != null) {
                this.writeKey(1, "CFBundleGetInfoString");
                this.writeString(1, this.mProps.getCFBundleGetInfoString());
            }
            this.writeKey(1, "CFBundleInfoDictionaryVersion");
            this.writeString(1, this.mProps.getCFBundleInfoDictionaryVersion());
            if (this.mProps.getCFBundleIdentifier() != null) {
                this.writeKey(1, "CFBundleIdentifier");
                this.writeString(1, this.mProps.getCFBundleIdentifier());
            }
            this.writeKey(1, "CFBundleExecutable");
            this.writeString(1, this.mProps.getCFBundleExecutable());
            this.writeKey(1, "CFBundleDevelopmentRegion");
            this.writeString(1, this.mProps.getCFBundleDevelopmentRegion());
            this.writeKey(1, "CFBundlePackageType");
            this.writeString(1, this.mProps.getCFBundlePackageType());
            this.writeKey(1, "CFBundleSignature");
            this.writeString(1, this.mProps.getCFBundleSignature());
            if (this.mProps.getCFBundleIconFile() != null) {
                this.writeKey(1, "CFBundleIconFile");
                this.writeString(1, this.mProps.getCFBundleIconFile());
            }
            this.writeKey(1, "Java");
            this.openDict(1);
            this.writeKey(2, "MainClass");
            this.writeString(2, this.mProps.getMainClass());
            if (this.mProps.getJVMVersion() != null) {
                this.writeKey(2, "JVMVersion");
                this.writeString(2, this.mProps.getJVMVersion());
            }
            List classPath = this.mProps.getClassPath();
            List extraClassPath = this.mProps.getExtraClassPath();
            if (classPath.size() > 0 || extraClassPath.size() > 0) {
                this.writeKey(2, "ClassPath");
                this.openArray(2);
                this.writeArray(3, classPath);
                this.writeArray(3, extraClassPath);
                this.closeArray(2);
            }
            if (this.mProps.getVMOptions() != null) {
                this.writeKey(2, "VMOptions");
                this.writeString(2, this.mProps.getVMOptions());
            }
            if (this.mProps.getWorkingDirectory() != null) {
                this.writeKey(2, "WorkingDirectory");
                this.writeString(2, this.mProps.getWorkingDirectory());
            }
            if (this.mProps.getArguments() != null) {
                this.writeKey(2, "Arguments");
                this.writeString(2, this.mProps.getArguments());
            }
            if ((javaProperties = this.mProps.getJavaProperties()) != null) {
                this.writeKey(2, "Properties");
                this.openDict(2);
                Iterator i = javaProperties.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    this.writeKey(3, key);
                    this.writeString(3, (String)javaProperties.get(key));
                }
                this.closeDict(2);
            }
            this.closeDict(1);
            this.closeDict(0);
            this.mOut.println("</plist>");
            this.mOut.flush();
            Object var8_8 = null;
            if (this.mOut != null) {
                this.mOut.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (this.mOut != null) {
                this.mOut.close();
            }
            throw throwable;
        }
    }

    private void openDict(int lvl) {
        for (int i = 0; i < lvl; ++i) {
            this.mOut.print("    ");
        }
        this.mOut.println("<dict>");
    }

    private void closeDict(int lvl) {
        for (int i = 0; i < lvl; ++i) {
            this.mOut.print("    ");
        }
        this.mOut.println("</dict>");
    }

    private void openArray(int lvl) {
        for (int i = 0; i < lvl; ++i) {
            this.mOut.print("    ");
        }
        this.mOut.println("<array>");
    }

    private void closeArray(int lvl) {
        for (int i = 0; i < lvl; ++i) {
            this.mOut.print("    ");
        }
        this.mOut.println("</array>");
    }

    private void writeArray(int lvl, List stringList) {
        Iterator it = stringList.iterator();
        while (it.hasNext()) {
            try {
                this.writeString(lvl, (String)it.next());
            }
            catch (ClassCastException ex) {}
        }
    }

    private void writeKey(int lvl, String s) {
        for (int i = 0; i < lvl; ++i) {
            this.mOut.print("    ");
        }
        this.mOut.println("<key>" + s + "</key>");
    }

    private void writeString(int lvl, String s) {
        for (int i = 0; i < lvl; ++i) {
            this.mOut.print("    ");
        }
        this.mOut.println("<string>" + s + "</string>");
    }
}

