/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.calendar.ui.basic;

import com.michaelbaranov.microba.calendar.CalendarPane;
import com.michaelbaranov.microba.calendar.CalendarResources;
import com.michaelbaranov.microba.calendar.DatePicker;
import com.michaelbaranov.microba.calendar.HolidayPolicy;
import com.michaelbaranov.microba.calendar.VetoPolicy;
import com.michaelbaranov.microba.calendar.resource.Resource;
import com.michaelbaranov.microba.calendar.ui.DatePickerUI;
import com.michaelbaranov.microba.common.CommitEvent;
import com.michaelbaranov.microba.common.CommitListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class BasicDatePickerUI
extends DatePickerUI
implements PropertyChangeListener {
    protected static final String POPUP_KEY = "##BasicVetoDatePickerUI.popup##";
    protected DatePicker peer;
    protected CalendarPane calendarPane;
    protected JButton button;
    protected JPopupMenu popup;
    protected JFormattedTextField field;
    protected ComponentListener componentListener;
    protected boolean buttonOnly = false;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDatePickerUI();
    }

    public void installUI(JComponent c) {
        this.peer = (DatePicker)c;
        this.installComponents();
        this.istallListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.peer = null;
    }

    protected void installKeyboardActions() {
        InputMap input = this.peer.getInputMap(1);
        input.put(KeyStroke.getKeyStroke(67, 8), POPUP_KEY);
        input.put(KeyStroke.getKeyStroke(34, 0), POPUP_KEY);
        this.peer.getActionMap().put(POPUP_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BasicDatePickerUI.this.showPopup(true);
            }
        });
    }

    protected void uninstallKeyboardActions() {
        InputMap input = this.peer.getInputMap(1);
        input.remove(KeyStroke.getKeyStroke(67, 8));
        input.remove(KeyStroke.getKeyStroke(34, 0));
        this.peer.getActionMap().remove(POPUP_KEY);
    }

    protected void istallListeners() {
        this.peer.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        this.peer.removePropertyChangeListener(this);
    }

    protected void uninstallComponents() {
        this.button.removeActionListener(this.componentListener);
        this.field.removePropertyChangeListener(this.componentListener);
        this.calendarPane.removePropertyChangeListener("date", this.componentListener);
        this.calendarPane.removeCommitListener(this.componentListener);
        this.peer.remove(this.field);
        this.peer.remove(this.button);
        this.popup = null;
        this.calendarPane = null;
        this.button = null;
        this.field = null;
    }

    protected void installComponents() {
        this.field = new JFormattedTextField(this.createFormatterFactory());
        this.field.setValue(this.peer.getDate());
        this.field.setFocusLostBehavior(this.peer.getFocusLostBehavior());
        this.field.setEditable(this.peer.isFieldEditable());
        this.button = new JButton();
        this.button.setFocusable(false);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.setSimpeLook(false);
        this.calendarPane = new CalendarPane(this.peer.getStyle());
        this.calendarPane.setShowTodayButton(this.peer.isShowTodayButton());
        this.calendarPane.setFocusLostBehavior(2);
        this.calendarPane.setFocusCycleRoot(true);
        this.popup = new JPopupMenu();
        this.popup.add(this.calendarPane);
        this.popup.setLightWeightPopupEnabled(true);
        this.peer.setLayout(new BorderLayout());
        if (!this.buttonOnly) {
            this.peer.add((Component)this.field, "Center");
        }
        this.peer.add((Component)this.button, "East");
        this.peer.revalidate();
        this.peer.repaint();
        this.componentListener = new ComponentListener();
        this.peerDateChanged(this.peer.getDate());
        this.button.addActionListener(this.componentListener);
        this.field.addPropertyChangeListener(this.componentListener);
        this.calendarPane.addPropertyChangeListener("date", this.componentListener);
        this.calendarPane.addCommitListener(this.componentListener);
    }

    public void setSimpeLook(boolean b) {
        if (b) {
            this.field.setBorder(BorderFactory.createEmptyBorder());
            this.button.setText("...");
            this.button.setIcon(null);
        } else {
            this.field.setBorder(new JTextField().getBorder());
            this.button.setText("");
            this.button.setIcon(new ImageIcon(Resource.class.getResource("picker2-16.png")));
        }
    }

    public void setButtonOnly(boolean b) {
        if (this.buttonOnly != b) {
            DatePicker dummy = this.peer;
            this.uninstallUI(dummy);
            this.buttonOnly = b;
            this.installUI(dummy);
        }
    }

    public void showPopup(boolean visible) {
        if (visible) {
            this.popup.show(this.peer, 0, this.peer.getHeight());
            this.calendarPane.requestFocus(false);
        } else {
            this.popup.setVisible(false);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("date")) {
            Date newValue = (Date)evt.getNewValue();
            this.peerDateChanged(newValue);
        } else if (evt.getPropertyName().equals("fieldEditable")) {
            this.field.setEditable(this.peer.isFieldEditable());
        } else if (evt.getPropertyName().equals("focusLostBehavior")) {
            this.field.setFocusLostBehavior(this.peer.getFocusLostBehavior());
        } else if (evt.getPropertyName().equals("locale")) {
            this.field.setFormatterFactory(this.createFormatterFactory());
            this.calendarPane.setLocale(this.peer.getLocale());
        } else if (evt.getPropertyName().equals("dateStyle")) {
            this.field.setFormatterFactory(this.createFormatterFactory());
        } else if (evt.getPropertyName().equals("zone")) {
            this.field.setFormatterFactory(this.createFormatterFactory());
            this.calendarPane.setZone((TimeZone)evt.getNewValue());
        } else if (evt.getPropertyName().equals("showTodayButton")) {
            boolean value = (Boolean)evt.getNewValue();
            this.calendarPane.setShowTodayButton(value);
        } else if (evt.getPropertyName().equals("showNoneButton")) {
            boolean value = (Boolean)evt.getNewValue();
            this.calendarPane.setShowNoneButton(value);
        } else if (evt.getPropertyName().equals("style")) {
            int value = (Integer)evt.getNewValue();
            this.calendarPane.setStyle(value);
        } else if (evt.getPropertyName().equals("vetoPlicy")) {
            this.calendarPane.setVetoPolicy((VetoPolicy)evt.getNewValue());
        } else if (evt.getPropertyName().equals("holidayPolicy")) {
            this.calendarPane.setHolidayPolicy((HolidayPolicy)evt.getNewValue());
        } else if (evt.getPropertyName().equals("focusable")) {
            boolean value = (Boolean)evt.getNewValue();
            this.field.setFocusable(value);
        } else if (evt.getPropertyName().equals("resources")) {
            CalendarResources resources = (CalendarResources)evt.getNewValue();
            this.calendarPane.setResources(resources);
        } else if (evt.getPropertyName().equals("enabled")) {
            boolean value = (Boolean)evt.getNewValue();
            this.field.setEnabled(value);
            this.button.setEnabled(value);
        }
    }

    private void peerDateChanged(Date newValue) {
        try {
            this.calendarPane.setDate(newValue);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.field.setValue(newValue);
    }

    private DefaultFormatterFactory createFormatterFactory() {
        DateFormat df = DateFormat.getDateInstance(this.peer.getDateStyle(), this.peer.getLocale());
        df.setTimeZone(this.peer.getZone());
        return new DefaultFormatterFactory(new DateFormatter(df));
    }

    public void commit() throws PropertyVetoException, ParseException {
        this.field.commitEdit();
    }

    public void revert() {
        this.peerDateChanged(this.peer.getDate());
    }

    protected class ComponentListener
    implements ActionListener,
    PropertyChangeListener,
    CommitListener {
        protected ComponentListener() {
        }

        public void actionPerformed(ActionEvent e) {
            BasicDatePickerUI.this.showPopup(true);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == BasicDatePickerUI.this.calendarPane && "date".equals(evt.getPropertyName())) {
                BasicDatePickerUI.this.showPopup(false);
                if (BasicDatePickerUI.this.field.getValue() != null || evt.getNewValue() != null) {
                    BasicDatePickerUI.this.field.setValue((Date)evt.getNewValue());
                }
            }
            if (evt.getSource() == BasicDatePickerUI.this.field && "value".equals(evt.getPropertyName())) {
                Date value = (Date)BasicDatePickerUI.this.field.getValue();
                try {
                    BasicDatePickerUI.this.peer.setDate(value);
                }
                catch (PropertyVetoException e) {
                    BasicDatePickerUI.this.field.setValue(BasicDatePickerUI.this.peer.getDate());
                }
            }
        }

        public void commit(CommitEvent action) {
            BasicDatePickerUI.this.showPopup(false);
            if (BasicDatePickerUI.this.field.getValue() != null || BasicDatePickerUI.this.calendarPane.getDate() != null) {
                BasicDatePickerUI.this.field.setValue(BasicDatePickerUI.this.calendarPane.getDate());
            }
        }

        public void revert(CommitEvent action) {
            BasicDatePickerUI.this.showPopup(false);
        }
    }
}

