/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pdfbox.util.ImageParameters;

public class PDFOperator {
    private String theOperator;
    private byte[] imageData;
    private ImageParameters imageParameters;
    private static Map operators = Collections.synchronizedMap(new HashMap());

    private PDFOperator(String aOperator) {
        this.theOperator = aOperator;
        if (aOperator.startsWith("/")) {
            throw new RuntimeException("Operators are not allowed to start with / '" + aOperator + "'");
        }
    }

    public static PDFOperator getOperator(String operator) {
        PDFOperator operation = null;
        if (operator.equals("ID") || operator.equals("BI")) {
            operation = new PDFOperator(operator);
        } else {
            operation = (PDFOperator)operators.get(operator);
            if (operation == null) {
                operation = new PDFOperator(operator);
                operators.put(operator, operation);
            }
        }
        return operation;
    }

    public String getOperation() {
        return this.theOperator;
    }

    public String toString() {
        return "PDFOperator{" + this.theOperator + "}";
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageDataArray) {
        this.imageData = imageDataArray;
    }

    public ImageParameters getImageParameters() {
        return this.imageParameters;
    }

    public void setImageParameters(ImageParameters params) {
        this.imageParameters = params;
    }
}

