/* <qd.c> 18feb05
**
** Program to dump data from Folding@home <queue.dat> file.
** It will poke around at other files too, if it can find them.
**
** Copyright (C) 2002-2005 Richard P. Howell IV.  This is free
** software; you can distribute it and/or modify it under the terms of
** the GNU General Public License.  There is no warranty whatsoever.
**
** To compile (for example):
**
**  cc -o qd -DNO_CTIME=1 -DTZONE=0 qd.c
**
** Define SYSTYPE as needed for system being compiled for...
**  0 - Linux
**  1 - Windows NT, 2K, ME, XP
**  2 - OS X
**
** DATE and FREV are normally defined automatically along with the point
** table inserted during compilation.
**
** The program accepts the following flag arguments...
**
**  -u print usage message
**  -h print an explanation of the status codes
**  -i format with deeper indentation
**  -p don't look at FAH files other than <queue.dat>
**  -f explicitly specify folding directory
**  -q explicitly specify queue data file (implies -p)
**  -n explicitly specify qd info file (default <qdinfo.dat>)
**  -m explicitly specify EM III info file (default <emprotz.dat>)
**  -s {linux, windows, mac} specify type of queue data file
**  -t override time zone (needs argument)
**  -z force UTC
**  -v just print version info and stop
**  -d print debug dump
**  -e print all entries even if they're garbage
**  -l format for log entry data
**  -L format for log entry data with specified ID string
**  -b just print out benchmark number (like "qbm") UNIMPLEMENTED
**  -r detect and fix errors (like "qfix") UNIMPLEMENTED
*/

#ifndef SYSTYPE			/* Really it should always be compiler arg */
# if defined (__i386__) && (defined(__linux__) || defined(__unix__))
#  define SYSTYPE	0
# elif defined (__i386__) && (defined(__WIN32__) || defined(WIN32))
#  define SYSTYPE	1
# elif defined(__ppc__) && defined(__APPLE__)
#  define SYSTYPE	2
# else
#  define SYSTYPE	-1
# endif
#endif
#ifndef NO_CTIME
# define NO_CTIME	0	/* It's OK to use library "ctime" function */
#endif
#ifndef DEFQVER
# define DEFQVER	400	/* Default client version number if file looks bad */
#endif
#ifndef MAXQVER
# define MAXQVER	510	/* Maximum queue version number allowed */
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#if !NO_CTIME
# include <time.h>
#endif

typedef int bool;
#ifndef FALSE
# define FALSE		0
# define TRUE		1
#endif

#define TIME_OFS 946684800U	/* Linux epoch is 1970, FAH (Cosm) is 2000 */

#ifndef TZONE
# define TZONE (0 * 3600)	/* Our own time printer needs the time zone */
#endif
char mtab[] = "Jan\037Feb\035Mar\037Apr\036May\037Jun\036\
Jul\037Aug\037Sep\036Oct\037Nov\036Dec\037";

#define be4(x)	(((x)[0]<<24)|(((x)[1]&0xFF)<<16)|(((x)[2]&0xFF)<<8)|((x)[3]&0xFF))
#define le4(x)	(((x)[3]<<24)|(((x)[2]&0xFF)<<16)|(((x)[1]&0xFF)<<8)|((x)[0]&0xFF))
#define le2(x)	((((x)[1]&0xFF)<<8)|((x)[0]&0xFF))
#define exch(x, y, t)	{t=x;x=y;y=t;}

int flags;			/* Various flag bits */
#define F_INDT 0x0001	/* Format with deeper indentation */
#define F_PRST 0x0002	/* Print an explanation of the status codes */
#define F_ONLY 0x0004	/* Don't look at files other than <queue.dat> */
#define F_DBGD 0x0008	/* Print debug dump */
#define F_PALL 0x0010	/* Print all entries even if they're garbage */
#define F_LOGD 0x0020	/* Format for log entry data */
#define F_ZONE 0x0040	/* Time zone specified (don't use "ctime") */
#define F_STYP 0x0080	/* System type specified (don't autodetect) */
#define F_PVER 0x0100	/* Just print version information and stop */
#define F_PQBM 0x0200	/* Just print out benchmark number (like "qbm") */
#define F_QFIX 0x0400	/* Detect and fix errors (like "qfix") */
#define F_OLDI 0x8000	/* Info file is older than builtin tables */

char *qfil;			/* Name of queue data file (default "queue.dat") */
char *nfil;			/* Name of qd info file (default "qdinfo.dat") */
char *mfil;			/* Name of EM III info file (default "emprotz.dat") */
char *fdir;			/* Folding directory (default "./") */
char *lid;			/* Specified log ID string */
int systype;		/* System type (from SYSTYPE) */
unsigned int qver;	/* Queue version number, from queue or best guess */
bool eswap;			/* Queue file with opposite endianness (default FALSE) */
int tzone;			/* Time zone (default TZONE) */
char *idnt;			/* Indentation string */

FILE *fp;
FILE *fpm;

/* Structure of <queue.dat> file */

typedef unsigned int u32;
typedef unsigned short u16;

struct qf
{	u32		version;	/* 0000 Queue (client) version (v2.17 and above) */
	u32		current;	/* 0004 Current index number */
	struct qs
	{	u32		stat;		/* 000 Status */
		char	z004[4];	/* 004 Pad for Windows, others as of v4.01 */
		u32		tdata[8];	/* 008 Time data (epoch 0000 1jan00 UTC) */
		u32		svr1;		/* 040 Server IP address (until v3.0) */
		u32		ustat;		/* 044 Upload status */
		char	url[128];	/* 048 Web address for core downloads */
		u32		m176;		/* 176 Misc1a */
		u32		core;		/* 180 Core_xx number (hex) */
		u32		m184;		/* 184 Misc1b */
		u32		dsiz;		/* 188 wudata_xx.dat file size */
		char	z192[16];
		union
		{	struct
			{	char	proj[2];	/* 208 Project number (LE) */
				char	run[2];		/* 210 Run (LE) */
				char	clone[2];	/* 212 Clone (LE) */
				char	gen[2];		/* 214 Generation (LE) */
				char	issue[2][4];	/* 216 WU issue time (LE) */
			}		f;			/* Folding@home data */
			struct
			{	char	proj[2];	/* 208 Project number (LE) */
				u16		miscg1;		/* 210 Miscg1 */
				char	issue[2][4];	/* 212 WU issue time (LE) */
				u16		miscg2;		/* 220 Miscg2 */
				u16		miscg3;		/* 222 Miscg3 */
			}		g;			/* Genome@home data */
		}		wuid;		/* 208 Work unit ID information */
		char	z224[36];
		char	mid[4];		/* 260 Machine ID (LE) */
		u32		svr2;		/* 264 Server IP address */
		u32		port;		/* 268 Server port number */
		char	type[64];	/* 272 Work unit type */
		char	uname[64];	/* 336 User Name */
		char	teamn[64];	/* 400 Team Number */
		char	uid[8];		/* 464 Stored ID for unit (UserID + MachineID) */
		char	bench[4];	/* 472 Benchmark (as of v3.24) (LE) */
		char	m476[4];	/* 476 Misc3b (unused as of v3.24) (LE) */
		char	z480[16];
		u32		expire;		/* 496 Allowed time to return (seconds) */
		char	z500[8];
		char	aiflag[4];	/* 508 Assignment info present flag (LE or BE) */
		char	aitime[4];	/* 512 Assignment timestamp (LE or BE) */
		char	aidata[4];	/* 516 Assignment info (xx xx xx xx) (LE or BE) */
		char	csip[4];	/* 520 Collection server IP address (as of v5.00) (LE) */
		char	dstart[4];	/* 524 Download started time (as of v5.00) (BE) */
		char	z528[160];
		u32		due[4];		/* 688 WU expiration time */
		u32		plimit;		/* 704 Packet size limit (as of v5.00) */
		u32		uploads;	/* 708 Number of upload failures (as of v5.00) */
	}		entry[10];	/* 0008 Array of ten queue entries */
	u32		pfract;		/* 7128 Performance fraction (as of v3.24) */
	u32		punits;		/* 7132 Performance fraction unit weight (as of v3.24) */
	u32		drate;		/* 7136 Download rate sliding average (as of v4.00) */
	u32		dunits;		/* 7140 Download rate unit weight (as of v4.00) */
	u32		urate;		/* 7144 Upload rate sliding average (as of v4.00) */
	u32		uunits;		/* 7148 Upload rate unit weight (as of v4.00) */
	char	z7152[16];	/* 7152 (as of v5.00) ...all zeros after queue conversion... */
} qbuf;

/* There is still sometimes unknown stuff in bytes 483, 484, 490, 491, 495, and 503 */

struct ptent
{	u16			proj;			/* Project number */
	u16			points;			/* Points */
	u32			until;			/* Time points may have changed */
} pbuf[5000];				/* Working point table */

char wbuf[300];
char nbuf[300];
char vbuf[20];
char vbufa[20];
void cfn(char *, int);					/* Construct file name (in wbuf) */
int lform(int *);						/* Construct line with variable fields */
void printip(char *, unsigned int, unsigned int);	/* Print IP address */
void prtime(char *, unsigned int);		/* Print a date and time */
void printb(void *, void *, int);		/* Print hex bytes */
u32 es32(u32);
void eswp(struct qf *);

/* The following text is automatically generated from <qdinfo.dat> */

#define DATE "25 February 2005"
#define FREV "029"
#define PGEN 0x09B216D8
struct ptent ptbl[] =		/* Built-in table, from "pt" and "ph" entries */
 {	{  101, 7400 },{  111,  500 },{  112,  500 },{  113,  500 },{  114,  500 },
	{  127,  200 },{  128,  200 },{  129,  200 },{  131,  140 },{  132,  280 },
	{  133,  350 },{  134,  190 },{  135,   70 },{  136,  130 },{  137,   60 },
	{  138,   60 },{  139,   60 },{  140,   60 },{  141,   60 },{  142,   60 },
	{  143,   60 },{  144,   60 },{  145,   60 },{  146,  600 },{  147,   60 },
	{  160,  200 },{  161,  200 },{  162,  200 },{  163,  200 },{  164,  200 },
	{  165,  200 },{  166,  200 },{  167,  200 },{  168,  200 },{  169,  200 },
	{  170,  200 },{  171,  200 },{  172,  200 },{  180, 9300 },{  181,  800 },
	{  182, 9300 },{  183,   70 },{  184, 9300 },{  185, 9300 },{  186,  640 },
	{  187,  640 },{  188,  640 },{  189,  640 },{  190,  640 },{  191, 1800 },
	{  192, 1000 },{  200,  200 },{  201,  760 },{  202,  760 },{  203,  760 },
	{  204,  760 },{  205,  760 },{  206,  760 },{  207,  760 },{  208,  760 },
	{  209,  760 },{  210,  760 },{  211,  640 },{  212,13500 },{  213,  640 },
	{  214, 6400 },{  215, 5400 },{  216, 5400 },{  217,23600 },{  218,18600 },
	{  219,16000 },{  220,14800 },{  221, 4200 },{  223, 3800 },{  224, 3400 },
	{  227, 3200 },{  230, 7800 },{  231, 6400 },{  233, 5300 },{  234, 5200 },
	{  235,23900 },{  236,18500 },{  237,16000 },{  238,14800 },{  239, 4200 },
	{  240, 3800 },{  241, 3300 },{  242, 3200 },{  243, 7800 },{  244, 6300 },
	{  245, 5400 },{  246, 5300 },{  247,23500 },{  248,18300 },{  249,15800 },
	{  250, 5330 },{  251, 1800 },{  252, 3500 },{  253, 3500 },{  254, 7400 },
	{  255, 7700 },{  256, 7600 },{  257, 1500 },{  258, 9200 },{  259, 9800 },
	{  260, 2200 },{  261,36600 },{  262,15200 },{  263,22100 },{  264,20600 },
	{  265,14600 },{  266,15200 },{  267,22100 },{  268,20600 },{  269,14600 },
	{  272, 4550 },{  273, 4000 },{  274, 4100 },{  275, 4100 },{  276, 4100 },
	{  277, 4100 },{  278, 4100 },{  279, 4100 },{  280, 4100 },{  281, 4100 },
	{  282, 4200 },{  283, 4100 },{  284, 4100 },{  285, 4100 },{  286, 4100 },
	{  287, 4100 },{  288, 4200 },{  289, 4100 },{  290, 4100 },{  291, 4100 },
	{  292, 4100 },{  293, 4100 },{  294,46900 },{  295,23400 },{  296,23400 },
	{  297,26600 },{  298,23500 },{  299,26100 },{  301,  200 },{  304,  200 },
	{  310,  200 },{  312,   50 },{  313,   50 },{  314,   50 },{  315,  200 },
	{  316,  200 },{  317,  200 },{  318,  420 },{  319,   50 },{  320, 5140 },
	{  321, 5140 },{  322, 5140 },{  323, 5140 },{  324, 5140 },{  325, 5140 },
	{  326, 5140 },{  327, 5140 },{  328, 5140 },{  329, 5140 },{  330, 5140 },
	{  332, 5140 },{  333, 5140 },{  334, 5140 },{  335, 5140 },{  336, 5140 },
	{  337, 5140 },{  338, 5140 },{  340, 5330 },{  341, 5330 },{  342, 5330 },
	{  343, 5330 },{  344, 5330 },{  345, 5330 },{  346, 5330 },{  347, 5330 },
	{  348, 5460 },{  349, 5460 },{  350, 5140 },{  351, 5140 },{  352, 5140 },
	{  353, 5140 },{  354, 5140 },{  355, 5140 },{  356, 5140 },{  357, 5140 },
	{  358, 5140 },{  359, 5140 },{  360, 5330 },{  361, 5330 },{  362, 5460 },
	{  363, 5460 },{  364, 2940 },{  365, 2940 },{  367, 5330 },{  368, 2940 },
	{  369, 2940 },{  372, 5330 },{  373, 5330 },{  374, 1530 },{  375, 1530 },
	{  376, 5330 },{  377, 5330 },{  378, 5330 },{  379, 5330 },{  380, 5330 },
	{  381, 5330 },{  382, 5330 },{  383, 5330 },{  384, 5330 },{  385, 5330 },
	{  386, 1530 },{  387, 1530 },{  388,  956 },{  389,  956 },{  391,  956 },
	{  392,  956 },{  393,  956 },{  394,  956 },{  395,  956 },{  396,  956 },
	{  397,  478 },{  411,   60 },{  412,   60 },{  434,   30 },{  435,   30 },
	{  437,   30 },{  439,   30 },{  441,   60 },{  442,   30 },{  443,   30 },
	{  447,   30 },{  448,   30 },{  451,   30 },{  452,   30 },{  457,   60 },
	{  458,   60 },{  459,   60 },{  464,   60 },{  465,   60 },{  466,   60 },
	{  468,   60 },{  469,   60 },{  472,   60 },{  477,   60 },{  482,   60 },
	{  487,   60 },{  488,   60 },{  489,   60 },{  494,   60 },{  499,   60 },
	{  501,  160 },{  502,  160 },{  504,  190 },{  505,  160 },{  506,  160 },
	{  507,  160 },{  508,  160 },{  509,  600 },{  511,  600 },{  513,  600 },
	{  514,  600 },{  515,  600 },{  516,  600 },{  520, 4400 },{  521, 4400 },
	{  522, 4400 },{  523, 4400 },{  524, 4400 },{  525, 4400 },{  526, 4400 },
	{  529, 4600 },{  530, 4400 },{  531,  700 },{  532, 2400 },{  533,  700 },
	{  534,  700 },{  535,  700 },{  536, 1000 },{  537, 1800 },{  538, 4800 },
	{  539, 4600 },{  540, 3300 },{  541, 3300 },{  542, 4600 },{  543, 4400 },
	{  544, 4700 },{  545, 4700 },{  546, 4700 },{  547, 1800 },{  548, 2300 },
	{  549, 4700 },{  553,  900 },{  554,   60 },{  555,  900 },{  556, 3300 },
	{  557,  900 },{  558, 4700 },{  559, 4600 },{  560,   60 },{  561,   60 },
	{  562,   60 },{  563, 2300 },{  564,   60 },{  565,   60 },{  566, 3300 },
	{  567, 3300 },{  568, 2300 },{  569, 4600 },{  570, 3600 },{  571, 6600 },
	{  572, 6100 },{  573, 4700 },{  574, 4700 },{  575, 4700 },{  576, 4700 },
	{  577, 4700 },{  578, 4700 },{  580,  650 },{  581,22000 },{  582,27700 },
	{  583, 4200 },{  584, 8800 },{  585, 1000 },{  586,21500 },{  587,18600 },
	{  588,23000 },{  589,23000 },{  590, 9300 },{  591, 2000 },{  599,  900 },
	{  601,   75 },{  602,   75 },{  603,  150 },{  604,  150 },{  605,  150 },
	{  606,  150 },{  607,  100 },{  608,  140 },{  609,  280 },{  610,  700 },
	{  611,  570 },{  612,  810 },{  613,  570 },{  614,  570 },{  615,  570 },
	{  616,  570 },{  617, 5100 },{  618, 6300 },{  619, 5200 },{  620, 1040 },
	{  621,  730 },{  622,12800 },{  623,12800 },{  624,12800 },{  625,12800 },
	{  626, 6600 },{  627, 3800 },{  628, 5100 },{  629, 2900 },{  630, 4300 },
	{  631, 2400 },{  632, 2360 },{  633, 2360 },{  634,20400 },{  635,24800 },
	{  636,11500 },{  637,13800 },{  638,23900 },{  639,23900 },{  640, 1970 },
	{  641, 1970 },{  642, 1970 },{  643, 1970 },{  644, 2360 },{  645, 2360 },
	{  646, 1970 },{  647, 1970 },{  648, 1970 },{  649, 1970 },{  650, 4060 },
	{  651, 4060 },{  652, 3060 },{  653, 3060 },{  654, 1720 },{  655, 1720 },
	{  656,14600 },{  657,14600 },{  658, 6700 },{  659,12200 },{  660,12800 },
	{  661,12800 },{  662, 1970 },{  663, 1970 },{  664, 1970 },{  665, 1970 },
	{  666, 1970 },{  667, 1970 },{  668, 3060 },{  669, 3060 },{  670, 7300 },
	{  671, 7300 },{  672,12800 },{  673, 1970 },{  674, 2360 },{  675,18200 },
	{  676,12800 },{  677,12800 },{  678,24200 },{  679, 2360 },{  680,23700 },
	{  681, 3010 },{  682, 3010 },{  683, 6000 },{  684, 6000 },{  685,12900 },
	{  686,12500 },{  687,23500 },{  688,23600 },{  689,23100 },{  690,23100 },
	{  691, 7090 },{  692,24100 },{  693,24400 },{  694,23600 },{  695,23500 },
	{  696,23500 },{  697,23800 },{  698,21400 },{  699,21300 },{  700,  250 },
	{  701,  250 },{  702,  250 },{  703,  250 },{  704,  250 },{  705,  250 },
	{  706,  250 },{  707,  250 },{  720, 1540 },{  721, 3900 },{  722, 5460 },
	{  723, 4900 },{  724, 6300 },{  725, 1170 },{  726, 1170 },{  727, 1310 },
	{  728, 1390 },{  729, 2000 },{  730, 2400 },{  731, 2500 },{  732, 2700 },
	{  733, 1800 },{  734, 2100 },{  735,25600 },{  736,12800 },{  737,12800 },
	{  738, 2300 },{  739, 2000 },{  740, 2400 },{  800, 3200 },{  801, 3200 },
	{  802, 3200 },{  803, 3200 },{  804, 3200 },{  805, 5450 },{  806, 5450 },
	{  807, 5450 },{  808, 3200 },{  809, 5450 },{  810, 3200 },{  811, 3200 },
	{  812, 3200 },{  813, 3200 },{  814, 3200 },{  815, 3200 },{  816, 3200 },
	{  817, 3200 },{  818, 3200 },{  819, 3200 },{  820, 3250 },{  821, 3200 },
	{  822, 3200 },{  823, 3200 },{  824, 3200 },{  825, 3200 },{  826, 3200 },
	{  827, 3200 },{  828, 3200 },{  829, 3200 },{  830, 3200 },{  831, 3200 },
	{  832, 3200 },{  833, 3200 },{  834, 3200 },{  835, 3200 },{  836, 3200 },
	{  837, 3200 },{  838, 3200 },{  839, 4000 },{  840, 1150 },{  841, 3250 },
	{  842, 3200 },{  843, 3200 },{  844, 1150 },{  845, 3200 },{  846, 3200 },
	{  847, 3200 },{  848, 3200 },{  849, 3200 },{  850, 3200 },{  851, 3500 },
	{  852, 3200 },{  853, 3200 },{  854,15500 },{  855,14100 },{  856,14100 },
	{  857,14100 },{  858,16000 },{  859,16000 },{  860, 3100 },{  861, 3100 },
	{  862, 3100 },{  863, 3100 },{  864,15500 },{  865,15500 },{  866,15500 },
	{  867,15500 },{  868,15000 },{  869,15000 },{  870,15000 },{  871,16400 },
	{  872, 3100 },{  873, 3100 },{  874,15500 },{  875,15500 },{  901,  320 },
	{  902,  500 },{  903,  620 },{  905, 1300 },{  906, 1300 },{  907, 1400 },
	{  908, 1300 },{  909, 4100 },{  910, 3500 },{  911, 6000 },{  912, 6000 },
	{  913, 6500 },{  914, 4100 },{  915, 3700 },{  916, 4100 },{  917, 4100 },
	{  918, 3100 },{  919, 3400 },{  920, 3400 },{  921, 4000 },{  922, 3400 },
	{  923, 4800 },{  924, 4800 },{  925, 3400 },{  926, 4100 },{  927, 9100 },
	{  928, 9100 },{  929,11400 },{  930, 9900 },{  931,10400 },{  932,11000 },
	{  933,11200 },{  934,10700 },{  935, 6800 },{  936,10700 },{  937, 7800 },
	{  938, 7500 },{  939, 9900 },{  940, 1200 },{  941, 4400 },{  942, 2100 },
	{  943, 3300 },{  944, 5200 },{  945, 7800 },{  946,11900 },{  947,17700 },
	{  948, 1700 },{  949, 3800 },{  950, 2700 },{  951, 3600 },{  952, 4900 },
	{  953, 6100 },{  954, 7600 },{  955,10600 },{  956, 4800 },{  957, 4800 },
	{  958, 4800 },{  959, 4800 },{  960, 4800 },{  961, 4800 },{  970,12200 },
	{  971, 8400 },{  972,12200 },{  973, 8400 },{  997, 1000 },{  998, 1000 },
	{ 1001, 4110 },{ 1002, 4110 },{ 1003, 4110 },{ 1004, 4110 },{ 1005, 4110 },
	{ 1006, 5700 },{ 1010, 3620 },{ 1011, 3620 },{ 1012, 5700 },{ 1013, 5800 },
	{ 1014, 3900 },{ 1015, 3900 },{ 1016, 3200 },{ 1017, 3200 },{ 1018, 3900 },
	{ 1019, 3900 },{ 1020, 5140 },{ 1021, 5140 },{ 1022, 5140 },{ 1023, 5140 },
	{ 1024, 5140 },{ 1025, 5140 },{ 1026, 5140 },{ 1027, 5140 },{ 1028, 5140 },
	{ 1029, 5140 },{ 1030, 5140 },{ 1031, 5140 },{ 1032, 5140 },{ 1033, 5140 },
	{ 1034, 5140 },{ 1035, 5140 },{ 1036, 5140 },{ 1037, 5140 },{ 1038, 5140 },
	{ 1039, 5140 },{ 1040, 5140 },{ 1041, 5140 },{ 1042, 5900 },{ 1043, 5900 },
	{ 1044, 5900 },{ 1045, 5900 },{ 1046, 5900 },{ 1047, 5900 },{ 1048, 5900 },
	{ 1049, 5900 },{ 1050, 5900 },{ 1051, 5900 },{ 1052, 5900 },{ 1053, 5900 },
	{ 1054, 5900 },{ 1055, 5900 },{ 1056, 5900 },{ 1057, 5900 },{ 1058, 5900 },
	{ 1059, 5900 },{ 1060, 5900 },{ 1061, 5900 },{ 1062, 5900 },{ 1063, 5900 },
	{ 1064, 5900 },{ 1065, 5900 },{ 1066, 5900 },{ 1067, 5900 },{ 1068, 5900 },
	{ 1069, 5900 },{ 1070, 3900 },{ 1071, 3900 },{ 1072, 3900 },{ 1073, 3900 },
	{ 1074, 3900 },{ 1075, 3900 },{ 1076, 3200 },{ 1077, 3200 },{ 1078, 3200 },
	{ 1079, 3200 },{ 1080, 3200 },{ 1081, 3200 },{ 1082, 3900 },{ 1083, 3900 },
	{ 1084, 3900 },{ 1085, 3900 },{ 1086, 3900 },{ 1087, 3900 },{ 1088, 5700 },
	{ 1089, 5700 },{ 1090, 9100 },{ 1091, 9100 },{ 1092, 9100 },{ 1093, 9100 },
	{ 1094, 9100 },{ 1100, 2400 },{ 1101, 3200 },{ 1102, 4200 },{ 1103, 4500 },
	{ 1104, 4900 },{ 1105, 3600 },{ 1106, 4700 },{ 1107, 3000 },{ 1108, 3700 },
	{ 1109, 2800 },{ 1110,24900 },{ 1111,24900 },{ 1112,24900 },{ 1113, 4000 },
	{ 1114,23100 },{ 1115,23100 },{ 1116,23100 },{ 1117,23100 },{ 1118,23100 },
	{ 1119,23100 },{ 1120,23100 },{ 1121,23100 },{ 1122, 4000 },{ 1123,23700 },
	{ 1124,24100 },{ 1125,24100 },{ 1126,23100 },{ 1127,23100 },{ 1128,23100 },
	{ 1129,23100 },{ 1130,24100 },{ 1131,24100 },{ 1132,24100 },{ 1133,24100 },
	{ 1134,60000 },{ 1135,60000 },{ 1136,24100 },{ 1137,24100 },{ 1138,24100 },
	{ 1139,24100 },{ 1140,60000 },{ 1141,60000 },{ 1142, 2500 },{ 1200, 6300 },
	{ 1201, 6300 },{ 1202, 8800 },{ 1203, 8800 },{ 1204, 6300 },{ 1205, 6300 },
	{ 1206, 8800 },{ 1207, 8800 },{ 1208, 6300 },{ 1209, 6300 },{ 1210, 8800 },
	{ 1211, 8800 },{ 1212, 6300 },{ 1213, 6300 },{ 1214, 8800 },{ 1215, 8800 },
	{ 1216, 6300 },{ 1217, 6300 },{ 1218, 8800 },{ 1219, 8800 },{ 1220, 6300 },
	{ 1221, 6300 },{ 1222, 8800 },{ 1223, 8800 },{ 1224, 6300 },{ 1225, 6300 },
	{ 1226, 8800 },{ 1227, 8800 },{ 1228, 5700 },{ 1229, 5700 },{ 1230, 5700 },
	{ 1231, 5700 },{ 1232, 5700 },{ 1233, 5700 },{ 1234, 5700 },{ 1235, 5700 },
	{ 1236, 5700 },{ 1237, 5700 },{ 1238, 5700 },{ 1239, 5700 },{ 1240, 5700 },
	{ 1241, 5700 },{ 1242, 5700 },{ 1243, 5700 },{ 1244, 5700 },{ 1245, 5700 },
	{ 1246, 5700 },{ 1247, 5700 },{ 1248,15900 },{ 1249,15900 },{ 1250, 7600 },
	{ 1251, 7600 },{ 1252, 7600 },{ 1253, 7600 },{ 1254, 7600 },{ 1255, 7600 },
	{ 1256, 7600 },{ 1257, 7600 },{ 1258, 7600 },{ 1259, 7600 },{ 1260, 7600 },
	{ 1261, 7600 },{ 1262, 7600 },{ 1263, 7600 },{ 1264, 7600 },{ 1265, 7600 },
	{ 1266, 7600 },{ 1267, 7600 },{ 1268, 7600 },{ 1269, 7600 },{ 1270, 7600 },
	{ 1271, 5700 },{ 1272, 5700 },{ 1273, 8300 },{ 1274, 8300 },{ 1275, 4600 },
	{ 1276, 4600 },{ 1277, 5900 },{ 1278, 5900 },{ 1279, 7600 },{ 1280, 7600 },
	{ 1281, 7200 },{ 1282, 7200 },{ 1288, 5900 },{ 1289, 5900 },{ 1290, 5900 },
	{ 1291, 5900 },{ 1292, 5900 },{ 1293, 5900 },{ 1294, 5900 },{ 1295, 5900 },
	{ 1296, 5900 },{ 1297, 5900 },{ 1298, 5900 },{ 1299, 5900 },{ 1300,13900 },
	{ 1301,24200 },{ 1302,24200 },{ 1303,51700 },{ 1304,16200 },{ 1305,63400 },
	{ 1306,32000 },{ 1307, 8000 },{ 1308,32000 },{ 1309,31600 },{ 1310,31600 },
	{ 1311,25400 },{ 1312,25400 },{ 1313,30200 },{ 1314,30200 },{ 1315,30200 },
	{ 1316,34300 },{ 1317,34300 },{ 1318,34300 },{ 1319,34300 },{ 1320,34300 },
	{ 1321,34600 },{ 1322,30200 },{ 1323,30800 },{ 1324,30500 },{ 1325,31000 },
	{ 1400,22800 },{ 1401,24000 },{ 1402,26400 },{ 1403,23000 },{ 1404,25100 },
	{ 1405,23400 },{ 1406,26600 },{ 1407,23500 },{ 1408,26100 },{ 1409,22800 },
	{ 1410,24000 },{ 1411,26400 },{ 1412,23000 },{ 1413,25100 },{ 1415,26600 },
	{ 1475,36400 },{ 1476,36400 },{ 1500, 3900 },{ 1501, 3900 },{ 1502, 3900 },
	{ 1503, 3900 },{ 1504, 3900 },{ 1505, 3900 },{ 1506, 3900 },{ 1507, 3900 },
	{ 1508, 3900 },{ 1509, 3900 },{ 1510, 3900 },{ 1511, 3900 },{ 1512, 3200 },
	{ 1513, 3200 },{ 1514, 3200 },{ 1515, 3200 },{ 1516, 3200 },{ 1517, 3200 },
	{ 1518, 3200 },{ 1519, 3200 },{ 1520, 3200 },{ 1521, 3200 },{ 1522, 3200 },
	{ 1523, 3200 },{ 1534, 5700 },{ 1535, 5700 },{ 1536, 5700 },{ 1537, 5700 },
	{ 1538, 5700 },{ 1539, 5700 },{ 1540, 5700 },{ 1541, 5700 },{ 1542, 5700 },
	{ 1543, 5700 },{ 1544, 5700 },{ 1545, 5700 },{ 1591, 5700 },{ 1592, 5700 },
	{ 1593, 5700 },{ 1594, 5700 },{ 1595, 5700 },{ 1596, 5700 },{ 1597, 5700 },
	{ 1598, 5700 },{ 1599, 5700 },{ 1600,14600 },{ 1601, 4100 },{ 1602, 3800 },
	{ 1603, 3300 },{ 1604, 3200 },{ 1605, 7800 },{ 1800, 7700 },{ 1801, 6600 },
	{ 1802, 7700 },{ 1803, 6900 },{ 1900,12500 },{ 1901,12500 },
	{  180,  560, 0x0818538C },{  182,  560, 0x0818538C },{  184,  900, 0x0818538C },
	{  185,  900, 0x0818538C },{  212,16000, 0x0817020C },{  212, 7500, 0x080CA03C },
	{  212, 3200, 0x08074C2C },{  212,  640, 0x07F76C1C },{  214,13500, 0x08B43E14 },
	{  215,13500, 0x08B43E14 },{  216,13500, 0x08B43E14 },{  217,13500, 0x08B43E14 },
	{  218,13500, 0x08B43E14 },{  219,13500, 0x08B43E14 },{  220,13500, 0x08B43E14 },
	{  221,13500, 0x08B43E14 },{  223,13500, 0x08B43E14 },{  224,13500, 0x08B43E14 },
	{  227,13500, 0x08B43E14 },{  230,13500, 0x08B43E14 },{  251, 2281, 0x083D2694 },
	{  252, 2281, 0x0817020C },{  253, 2281, 0x0817020C },{  254, 5377, 0x0817020C },
	{  255, 5377, 0x0817020C },{  256, 5377, 0x0817020C },{  257, 9200, 0x08398674 },
	{  257,10483, 0x0817020C },{  258, 5761, 0x0817020C },{  259, 7077, 0x0817020C },
	{  261, 5049, 0x088473B4 },{  261,   49, 0x08831424 },{  261,   30, 0x0881DEC4 },
	{  261, 2200, 0x087817A4 },{  262,15100, 0x08874EF4 },{  263,15100, 0x0883BCE4 },
	{  264,15100, 0x088481C4 },{  265,15100, 0x08842D64 },{  266,15100, 0x08874EF4 },
	{  273, 3116, 0x0821AA2C },{  297,23400, 0x08DD383C },{  298,23400, 0x08DFA2FC },
	{  299,23500, 0x08EDDD2C },{  520, 4500, 0x082D5494 },{  520, 3300, 0x0817020C },
	{  521, 3300, 0x082D5494 },{  522, 3300, 0x082D5494 },{  523, 3300, 0x082FBF54 },
	{  524, 3300, 0x082FBF54 },{  525, 4500, 0x082FBF54 },{  525, 3300, 0x0817020C },
	{  526, 3300, 0x082FBF54 },{  530, 1000, 0x085FEC24 },{  538, 3600, 0x081B3CDC },
	{  539, 3300, 0x0817020C },{  542, 3300, 0x081B3CDC },{  543, 3300, 0x0817020C },
	{  544, 4600, 0x08538204 },{  544, 3300, 0x0817020C },{  545, 3300, 0x08538204 },
	{  546, 3300, 0x08538204 },{  548, 1800, 0x083E9434 },{  549, 3300, 0x0817020C },
	{  563, 1800, 0x0817020C },{  568, 1800, 0x0817AACC },{  571, 4700, 0x08402C04 },
	{  572, 4700, 0x08186FAC },{  580,   55, 0x08E664AC },{  582,22000, 0x08E9B06C },
	{  617, 1360, 0x0818538C },{  618, 1040, 0x0818538C },{  619, 1360, 0x0818538C },
	{  622, 1970, 0x0818538C },{  623, 1970, 0x0818538C },{  624, 1970, 0x0818538C },
	{  625, 1970, 0x0818538C },{  626, 7300, 0x0818538C },{  627, 7300, 0x0818538C },
	{  628, 5550, 0x0818538C },{  629, 5550, 0x0818538C },{  630, 4700, 0x0818538C },
	{  631, 4700, 0x0818538C },{  634, 4830, 0x0818538C },{  635, 5990, 0x0818538C },
	{  636, 4830, 0x0818538C },{  637, 5990, 0x0818538C },{  638,12800, 0x0864C1A4 },
	{  638, 7090, 0x0817020C },{  639, 7090, 0x0817020C },{  658, 3730, 0x0817020C },
	{  659, 3730, 0x0817020C },{  660, 1970, 0x0818538C },{  661, 1970, 0x0818538C },
	{  672, 1970, 0x0818538C },{  675, 4060, 0x0817020C },{  676, 1970, 0x0818538C },
	{  677, 1970, 0x0818538C },{  678, 7090, 0x0817020C },{  680, 7090, 0x0817020C },
	{  685, 7090, 0x0817020C },{  686, 7090, 0x0817020C },{  687, 7090, 0x0817020C },
	{  688, 7090, 0x0817020C },{  689, 7090, 0x0817020C },{  690, 7090, 0x0817020C },
	{  692, 7090, 0x0817020C },{  693, 7090, 0x0818538C },{  694,12900, 0x0819267C },
	{  694, 7090, 0x0818538C },{  695, 7090, 0x0818538C },{  696, 7090, 0x0818538C },
	{  697, 7090, 0x0818538C },{  698, 7090, 0x0817020C },{  699, 7090, 0x0817020C },
	{  724, 4900, 0x0817020C },{  729, 1170, 0x0817020C },{  730, 1170, 0x0817020C },
	{  731, 1310, 0x0817020C },{  732, 1390, 0x0817020C },{  733, 1190, 0x0817020C },
	{  734, 1110, 0x0817020C },{  735,10000, 0x0823EFE4 },{  738,12800, 0x08AF0624 },
	{  854, 3200, 0x08D8FD6C },{  855,15500, 0x08FEF29C },{  855, 3200, 0x08FDCB4C },
	{  856,15500, 0x08FEF29C },{  856,16000, 0x08FDCB4C },{  857,15500, 0x08FEF29C },
	{  857,16000, 0x08FDCB4C },{  868,14100, 0x0908493C },{  869,14100, 0x0908493C },
	{  909, 3800, 0x0822993C },{  910, 5700, 0x0822993C },{  914, 2970, 0x0818619C },
	{  915, 3660, 0x0818619C },{  916, 2970, 0x0818619C },{  917, 2970, 0x0818619C },
	{  918, 2300, 0x0818619C },{  919, 3100, 0x0818619C },{  920, 3660, 0x0818619C },
	{  921, 2300, 0x0818619C },{  922, 3100, 0x0818619C },{  929,19900, 0x09A563FC },
	{  930, 4730, 0x0818619C },{  931, 4600, 0x0818619C },{  933, 4960, 0x0818619C },
	{  934, 3800, 0x0818619C },{  935, 2300, 0x0818619C },{  939,16000, 0x09A563FC },
	{  970,13000, 0x09A563FC },{ 1006, 4110, 0x0817020C },{ 1012, 4015, 0x0817020C },
	{ 1013, 4015, 0x0817020C },{ 1016, 3900, 0x08F1DFBC },{ 1017, 3900, 0x08F1DFBC },
	{ 1100, 1000, 0x0817020C },{ 1101, 1400, 0x0817020C },{ 1102, 1640, 0x0817020C },
	{ 1103, 1780, 0x0817020C },{ 1104, 1920, 0x0817020C },{ 1105, 1420, 0x0817020C },
	{ 1106, 1740, 0x0817020C },{ 1107, 1250, 0x0817020C },{ 1108, 1460, 0x0817020C },
	{ 1109, 1100, 0x0817020C },{ 1110,12800, 0x0818619C },{ 1110, 7090, 0x0818538C },
	{ 1111,12900, 0x0819EB5C },{ 1113, 2400, 0x0881DEC4 },{ 1113,24000, 0x087D79C4 },
	{ 1113,20000, 0x08784FE4 },{ 1122,11160, 0x09285DBC },{ 1122,24000, 0x08ABF2A4 },
	{ 1122, 4000, 0x08A5E7C4 },{ 1300,24200, 0x08AABD44 },{ 1300,36600, 0x089BF674 },
	{ 1301,18200, 0x08CB7A0D },{ 1301,13900, 0x08B68CB4 },{ 1301,24200, 0x08AABD44 },
	{ 1302,18200, 0x08CB7A0D },{ 1302,13900, 0x08B68CB4 },{ 1303,24200, 0x08C00D0C },
	{ 1303,18200, 0x08BEC99C },{ 1304,24200, 0x08DA24BC },{ 1305,10000, 0x08DF246C },
	{ 1306, 6300, 0x08E36D4C },{ 1307, 1000, 0x08E7A81C },{ 1308, 8000, 0x08F60C7C },
	{ 1310, 1000, 0x09073E0C },{ 1313,22400, 0x095B1F7C },{ 1314,22400, 0x095B1F7C },
	{ 1315,22400, 0x095B1F7C },{ 1316,25400, 0x095B1F7C },{ 1317,25400, 0x095B1F7C },
	{ 1318,25400, 0x095B1F7C },{ 1319,25400, 0x095B1F7C },{ 1320,25400, 0x095B1F7C },
	{ 1321,25600, 0x095B1F7C },{ 1322,22400, 0x095B1F7C },{ 1323,22800, 0x095B1F7C },
	{ 1324,22600, 0x095B1F7C },{ 1325,22800, 0x095D600C },{ 1400,23500, 0x08EDDD2C },
	{ 1401,23500, 0x08EDDD2C },{ 1402,23500, 0x08EDDD2C },{ 1403,23500, 0x08EDDD2C },
	{ 1404,23500, 0x08EDDD2C },{ 1475,18200, 0x0974C6AC },{ 1900,18500, 0x09A7B29C },
	{ 0 }
 };

#ifndef DATE
# define DATE "FOR TEST ONLY"
#endif
#ifndef FREV
# define FREV "EXPERIMENTAL"
#endif
#ifndef PGEN
# define PGEN 0
#endif

/* Finally, the program! */

int main(int argc, char *argv[])		/* qd */
{
char *argv0;
char *s1;
int f, i, j, k;
unsigned int m, n;
int estat;
bool gf;
float bst, bsp;
unsigned int cl;
unsigned int et, xt;
float fc, fcl, d, g;
int tcl, tcc;
struct ptent *pb;
struct qs *p;
struct qf *bp;
u32 *tp, *dp;
char *q;
int na, nb, nc;
u32 ut, mt, it, pg;
int za;
char zc;
char *pn;
char uf[2];
char emn[100];
int emd;
float emp;
int proj;
struct stat st, st2;

	argv0 = argv[0];
	qfil = "queue.dat";
	nfil = "qdinfo.dat";
	mfil = NULL;			/* Default will try <emprotz.dat> first, then <emprotx.dat> */
	fpm = NULL;
	fdir = "";
	lid = NULL;
	systype = SYSTYPE;		/* Default is native queue type */
	eswap = FALSE;
	qver = DEFQVER;
	tzone = TZONE;
	idnt = "  ";
	flags = 0;

	/* Parse arguments */

	while (--argc > 0)
	{	++argv;
		if (*argv[0] == '-')
		{	s1 = *argv;
			while (*++s1 != '\0')
				switch (*s1)
				{
				default:
us:					fprintf(stderr, "\n\
Usage: %.200s [<flags> <arguments required by flags>]*\n", argv0);
					fprintf(stderr,"\
 -u      Print this usage message (and exit)\n\
 -h      Print an explanation of the status codes (and exit)\n\
 -i      Format with deeper indentation\n\
 -p      Don't look at FAH files other than <queue.dat>\n\
 -f dir  Explicitly specify folding directory\n\
 -q file Explicitly specify queue data file (implies -p)\n\
 -n file Explicitly specify qd info file\n\
 -m file Explicitly specify EM III info file\n");
					fprintf(stderr,"\
 -s {linux, windows, mac}  Specify type of queue data file\n\
 -t zone Override time zone (+HHMM or -HHMM)\n\
 -z      Force UTC (same as -t +0000)\n\
 -v      Just print version information and stop\n\
 -d      Print debug dump\n\
 -e      Print all entries even if they're garbage\n\
 -l      Format for log entry data\n\
 -L      Format for log entry data with specified ID string\n");
#ifdef NOTYET
					fprintf(stderr,"\
 -b      Just print out benchmark number (like \"qbm\")\n\
 -r      Detect and fix errors (like \"qfix\")\n");
#endif
					exit(1);

				case 'h':		/* Print an explanation of the status codes */
					fprintf(stderr, "\n\
The status code for each queue entry may be interpreted as follows:\n\n\
(0) empty\n\
  The queue entry has never been used, or has been completely cleared.\n\
(0) deleted\n\
  The unit was explicitly deleted.\n\
(0) finished\n\
  The unit has been uploaded.  The queue entry is just history.\n\
(0) garbage\n\
  The queue entry is available, but its history is unintelligible.\n");
					fprintf(stderr, "\
(1) folding now\n\
  The unit is in progress.  Presumably the core is running.\n\
(1) queued for processing\n\
  The unit has been downloaded but processing hasn't begun yet.\n\
(2) ready for upload\n\
  The core has finished the unit, but it is still in the queue.\n\
(3) DANGER will be lost if client is restarted!\n\
  Bug before V3b5, neglected to post status (1).\n\
(3) abandoned\n\
  Bug before V3b5, neglected to post status (1), and client was restarted.\n");
					fprintf(stderr, "\
(4) fetching from server\n\
  Client presently contacting the server, or something failed in download.\n\
  If this state persists past the current unit, the queue entry will be\n\
  unusable, but otherwise things will go on as usual.\n\
(?) UNKNOWN STATUS = ??\n\
  Something other than 0 to 4.\n");
					exit(0);

				case 'i':		/* Format with deeper indentation */
					flags |= F_INDT;
					idnt = "   ";
					break;
				case 'q':		/* Explicitly specify queue data file (implies -p) */
					if (--argc <= 0)
					{	q = "Missing queue file name argument";
						goto pe;
					}
					qfil = *++argv;
				case 'p':		/* Don't look at FAH files other than <queue.dat> */
					flags |= F_ONLY;
					break;
				case 'n':		/* Explicitly specify qd info file */
					if (--argc <= 0)
					{	q = "Missing qd info file name argument";
						goto pe;
					}
					nfil = *++argv;
					break;
				case 'm':		/* Explicitly specify EM III info file */
					if (--argc <= 0)
					{	q = "Missing EM III info file name argument";
						goto pe;
					}
					mfil = *++argv;
					break;
				case 's':		/* Specify queue file type */
					if (--argc <= 0)
					{	q = "Missing queue file type argument";
						goto pe;
					}
					if (strcasecmp(*++argv, "linux") == 0)
						systype = 0;
					else if (strcasecmp(*argv, "windows") == 0)
						systype = 1;
					else if (strcasecmp(*argv, "mac") == 0)
						systype = 2;
					else
					{	q = "Invalid queue file type argument";
						goto pe;
					}
					flags |= F_STYP;
					break;
				case 'f':		/* Explicitly specify folding directory */
					if (--argc <= 0)
					{	q = "Missing folding directory name argument";
						goto pe;
					}
					fdir = *++argv;
					break;
				case 't':		/* Override time zone (needs argument) */
					if (--argc <= 0)
					{	q = "Missing time zone argument";
						goto pe;
					}
					q = *++argv;
					if	(	(strlen(q) != 5)
						||	((q[0] != '+') && (q[0] != '-'))
						||	(sscanf(&q[1], "%4d%c", &za, &zc) != 1)
						||	(za < 0)
						||	((za % 100) >= 60)
						||	(za >= 2400)
						)
					{	q = "Bad time zone argument";
pe:						fprintf(stderr,"\n%.200s: %.200s\n", argv0, q);
						goto us;
					}
					tzone = za * 36 + (za % 100) * 24;
					if (q[0] == '-')
						tzone = -tzone;
					goto tz;
				case 'z':		/* Force UTC */
					tzone = 0;
tz:					flags |= F_ZONE;	/* Suppress use of "ctime" */
					break;
				case 'v':		/* Just print version information and stop */
					flags |= F_PVER;
					break;
				case 'd':		/* Print debug dump */
					flags |= F_DBGD;
					break;
				case 'e':		/* Print all entries even if they're garbage */
					flags |= F_PALL;
					break;
				case 'l':		/* Format for log entry data */
					flags |= F_LOGD;
					break;
				case 'L':		/* Format for log entry data, with ID string */
					if (--argc <= 0)
					{	q = "Missing log entry ID string argument";
						goto pe;
					}
					flags |= F_LOGD;
					lid = *++argv;
#ifdef NOTYET
					break;
				case 'b':		/* Just print out benchmark number (like "qbm") */
					flags |= F_PQBM;
					break;
				case 'r':		/* Detect and fix errors (like "qfix") */
					flags |= F_QFIX;
#endif
				}
			continue;
		}
		else goto us;
	}

	/* Set up points table in "pbuf", merge info from info file */

	memset(pbuf, 0, sizeof(pbuf));
	memcpy(pbuf, ptbl, sizeof(ptbl));
	for (pb = pbuf; pb->proj != 0; ++pb)
		if (pb->until == 0) pb->until = 0xFFFFFFFF;

	printf("qd released %s (fr %s)", DATE, FREV);
	cfn(nfil, 0);		/* Try to get data from qd info file */
	if ((fp = fopen(wbuf, "rb")) != NULL)
	{	while (fgets(wbuf, sizeof(wbuf), fp) != NULL)
		{	nbuf[0] = '\0';
			sscanf(wbuf, "%20s%n", nbuf, &za);
			q = wbuf + za;
			if	(	(strcmp(nbuf, "da") == 0)
				||	(strcmp(nbuf, "fr") == 0)
				)
			{	while ((*q == ' ') || (*q == '\t')) ++q;
				for	(	s1 = q + strlen(q) - 1
					;	(	(*s1 == 0x0A)
						||	(*s1 == 0x0D)
						||	(*s1 == ' ')
						||	(*s1 == '\t')
						)
					;	--s1
					) ;
				if (s1 > q)
				{	*++s1 = '\0';
					if (strcmp(nbuf, "da") == 0)
						printf("; qd info %.50s", q);
					else if ((i = strcmp(q, FREV)) > 0)
						printf("\n\
** NOTICE: This version of \"qd\" is out of date (info file is fr %.10s). **", q);
					else if (i < 0)
						flags |= F_OLDI;
				}
			}
			if (strcmp(nbuf, "pg") == 0)
			{	pg = 0;
				sscanf(q, "%x", &pg);
				if (pg < PGEN)
					flags |= F_OLDI;
				else
					flags &= ~F_OLDI;
			}
			else if (strcmp(nbuf, "pt") == 0)
				while (sscanf(q, "%d%u%n", &nb, &cl, &za) >= 2)
				{	q += za;
					for (pb = pbuf; pb->proj != 0; ++pb)
						if ((pb->proj == nb) && (pb->until == 0xFFFFFFFF)) break;
					if ((pb->proj == 0) || ((flags & F_OLDI) == 0))
					{	pb->proj = nb;
						pb->points = cl;
						pb->until = 0xFFFFFFFF;
					}
				}
			else if (strcmp(nbuf, "ph") == 0)
				while (sscanf(q, "%d%u%x%n", &nb, &cl, &ut, &za) >= 3)
				{	q += za;
					for (pb = pbuf; pb->proj != 0; ++pb)
						if ((pb->proj == nb) && (pb->until == ut)) break;
					pb->proj = nb;
					pb->points = cl;
					pb->until = ut;
				}
		}
		fclose(fp);
	}
	if ((flags & F_OLDI) != 0)
		printf("\n\
** NOTICE: The info file is older than this version of \"qd\" **");
	printf("\n");
	if ((flags & F_PVER) != 0)
		exit(0);

	/* Read in the queue data and figure out what version and system it is */

	cfn(qfil, 0);
	if ((fp = fopen(wbuf, "rb")) == NULL)
	{	printf("Can't open <%s> file\n", wbuf);
		exit(1);
	}
	i = fread(&qbuf, 1, sizeof(struct qf), fp);
	fclose(fp);
	if (i < 6844)
	{	printf("Can't read <%s> file\n", wbuf);
		exit(1);
	}
	q = NULL;
	if ((flags & F_STYP) == 0)
	{	gf = (qbuf.version > 0xFFFF)
				&& ((qbuf.current > 0xFFFF) || (qbuf.current == 0));
		qver = 0;
		switch (i)		/* Determine system type, mainly from file length */
		{
		case 6884:		/* 2.15W - 2.17W */
			qver = 217;
			goto tw;
		case 6888:		/* 3.00W - 3.14W */
			qver = 314;
			goto tw;
		case 7048:		/* 3.24W earlier */
		case 7056:		/* 3.24W later */
			qver = 324;
tw:			q = "1Windows";
			break;
		case 6848:		/* 2.19L (3.12M) - 3.14LM */
			qver = 314;
			goto tl;
		case 7008:		/* 3.24LM earlier */
		case 7016:		/* 3.24LM later */
		case 7032:		/* 4.00L */
			qver = 324;
tl:			if (gf)			/* Wrong endianness */
#if (SYSTYPE == 2)
				q = "0Linux";
#else
				q = "2Mac";
			else
				q = "0Linux";
#endif
			break;
		case 7072:		/* 4.00W, 4.01LWM */
			qver = 401;
			goto tt;
		case 7168:		/* 5.00LWM */
			qver = 500;
tt:			if (gf)			/* Wrong endianness */
#if (SYSTYPE == 2)
				q = "1Linux or Windows";
#else
				q = "2Mac";
			else if (qbuf.version == 400)
				q = "1Windows";
#endif
			break;
		}
		if (q != NULL)
			systype = *q++ - '0';
	}
#if (SYSTYPE == 2)
	if (systype != 2)
		eswap = TRUE;
#else
	if (systype == 2)
		eswap = TRUE;
#endif
	bst = 0.0;
	bsp = 0.0;

	i = qbuf.version;
	if (eswap)
		i = es32(i);
	if (i > 9)
	{	bp = &qbuf;
		printf("Queue version %d.%02d", i / 100, i % 100);
		if ((qver == 314) && ((i >= 324) && (i < 400)))
		{	q = "Google";
			i = qver;
		}
		if ((systype != SYSTYPE) && (q != NULL))
			printf(" (%s)", q);
		if (i > MAXQVER)
		{	printf("  WARNING: unknown version number");
			if (qver == 0)
				qver = DEFQVER;
		}
		else
			qver = i;
		printf("\n");
	}
	else
	{	bp = (struct qf *) ((char *) &qbuf - 4);
		qver = 0;
	}
	if (eswap)				/* Endian swap everything if necessary */
		eswp(&qbuf);
	printf("Current index: %d\n", bp->current);

	/* Try to open EM III data file */

	if ((flags & F_ONLY) == 0)
	{	if (mfil == NULL)
		{	cfn("emprotz.dat", 0);
			if ((fpm = fopen(wbuf, "rt")) == NULL)	/* Is EM III installed ? */
				cfn("emprotx.dat", 0);
		}
		else
			cfn(mfil, 0);
		if (fpm == NULL)
			fpm = fopen(wbuf, "rt");
	}

	/* Print data from each entry in the queue */

	for (i = 10; --i >= 0; )
	{	n = ((bp->current & 0xFF) - i + 10) % 10;	/* Print oldest first */
		p = &bp->entry[n];
		if (qver < 324)
			p = (struct qs *) ((char *) p - 16 * n);
		if (qver < 500)
			p = (struct qs *) ((char *) p - 8 * n);
		if ((qver < 401) && (systype != 1))
		{	p = (struct qs *) ((char *) p - 4 * n);
			estat = p->stat;
			p = (struct qs *) ((char *) p - 4);
		}
		else
			estat = p->stat;
		tp = p->tdata;					/* Beginning and ending times */
		dp = p->due;					/* Due date */
		if ((qver <= 9) || (systype == 2))
		{	++tp;			/* Older versions and OS X are 4 bytes higher */
			++dp;
		}
		gf = ((p->core == 0xC9) || (p->core == 0xCA));
		if ((systype == 2) && (!gf))	/* There was never, in fact, any Mac Genome core */
		{	na = (p->wuid.f.run[0] & 0xFE) + (p->wuid.f.clone[0] & 0xFE)
					+ (p->wuid.f.gen[0] & 0xFE);
			nc = (p->wuid.f.run[1] & 0xFE) + (p->wuid.f.clone[1] & 0xFE)
					+ (p->wuid.f.gen[1] & 0xFE);
			if (na <= nc)	/* Test for already endian swapped (probably not needed) */
			{	exch(p->wuid.f.run[0], p->wuid.f.run[1], na);
				exch(p->wuid.f.clone[0], p->wuid.f.clone[1], na);
				exch(p->wuid.f.gen[0], p->wuid.f.gen[1], na);
			}
		}
		proj = gf ? le2(p->wuid.g.proj) : le2(p->wuid.f.proj);
		switch (estat)
		{
		case 0:
			if (proj == 0)
				q = "1empty";
			else if (p->ustat == 0)
				q = "0deleted";
			else if (p->ustat == 1)
				q = "0finished";
			else
				q = "1garbage";
			break;
		case 1:
			if (n == bp->current)
				q = "2folding now";
			else
				q = "3queued for processing";
			break;
		case 2:
			q = "0ready for upload";
			break;
		case 3:				/* Before version 3 beta 5 sometimes */
			if (n == bp->current)
				q = "2DANGER will be lost if client is restarted!";
			else
				q = "2abandoned";
			break;
		case 4:
			q = "1fetching from server";
			break;
		default:
			sprintf(wbuf, "0UNKNOWN STATUS = %d", estat);
			q = wbuf;
		}
		f = *q++ - '0';
		if ((flags & F_INDT) != 0)
			printf("\n");
		if ((flags & F_LOGD) == 0)
			printf(" Index %d: %s", n, q);
		if ((f == 1) && ((flags & F_PALL) == 0))
		{	if ((flags & F_LOGD) == 0)
				printf("\n");			/* Nothing else worth printing */
			continue;
		}
		na = 0;
		nb = -1;
		nc = 0;
		cl = 0;
		fc = 0.0;
		fcl = 0.0;
		tcl = 0;
		tcc = 0;
		vbuf[0] = '\0';
		nbuf[0] = '\0';
		nbuf[3] = '\0';
		cfn("work/logfile_??.txt", n);
		if	(	(stat(wbuf, &st) != 0)
			||	(st.st_size == 0)
			||	(st.st_mtime - TIME_OFS + 60 < tp[0])	/* 1 minute max clock error */
			) st.st_mtime = 0;
		else if	(	((flags & F_ONLY) == 0)
				&&	(f != 3)
				&&	((fp = fopen(wbuf,"rb")) != NULL)	/* Get name and progress */
				)
		{	while (fgets(wbuf, sizeof(wbuf), fp) != NULL)
			{	if ((nbuf[0] == '\0') && (strncmp(wbuf, "Protein: ", 9) == 0))
				{	wbuf[strlen(wbuf) - 1] = '\0';	/* Get rid of the newline */
					sprintf(nbuf, ", \"%.90s\"", &wbuf[9]);	/* Work unit name */
				}
				if	(	(	(sscanf(wbuf, "Version %19s %c", vbufa, &zc) == 2)
						||	(sscanf(wbuf, "Folding@Home Client Core Version %19s %c", vbufa, &zc) == 2)
						)
					&&	(zc == '(')
					) strcpy(vbuf, vbufa);
				if (sscanf(wbuf, "- Frames Completed: %d, Remaining: %d",
						&za, &nb) == 2)
				{	na = za;
					nb += na;		/* Tinker or Genome total frames */
					goto zn;
				}
				if (sscanf(wbuf, "[SP%*c] Designing protein sequence  %d of %d",
						&za, &nb) == 2)
				{	na = za - 1;
					goto zn;
				}
				if	(	(sscanf(wbuf, "[SP%*c]  %d.0 %c", &za, &zc) == 2)
					&&	(zc == '%')
					)
				{	nc = za;
					goto sl;
				}
				if	(	(sscanf(wbuf, "Iterations: %d of %d", &za, &nb) == 2)
					||	(sscanf(wbuf, "Completed %d out of %d", &za, &nb) == 2)
					||	(sscanf(wbuf, "Finished a frame (%d", &za) == 1)
					)
				{	na = za;
zn:					nc = 0;
sl:					fcl = fc;
					fc = (nb > 0) ? ((float) na + (float) nc / 100.0) / (float) nb : 0.0;
					tcl = tcc;
					tcc = 0;
					continue;
				}
				if	(	(strncmp(wbuf, "Timered checkpoint triggered", 28) == 0)
					||	(strncmp(wbuf, "Writing checkpoint files", 24) == 0)
					) ++tcc;
				else if (sscanf(wbuf,
						"[SPG]   %d positions in protei%c", &za, &zc) == 2)
					cl = za;
				else
					sscanf(wbuf, "[SP%*c] Writing current.pdb, chainlength = %u", &cl);
			}
			if (tcc > tcl) tcc = tcl;
			fclose(fp);
		}
		cfn("work/current.xyz", 0);		/* Be careful not to look here too soon */
		if	(	((flags & F_ONLY) == 0)
			&&	(nbuf[0] == '\0')
			&&	(n == bp->current)
			&&	(nb >= 0)
			&&	(stat(wbuf, &st2) == 0)
			&&	(st2.st_size != 0)
			&&	(st2.st_mtime - TIME_OFS + 60 >= tp[0])
			&&	((fp = fopen(wbuf, "rb")) != NULL)
			)
		{	if	(	(fgets(wbuf, sizeof(wbuf), fp) != NULL)
				&&	(sscanf(wbuf, "%*d %*c%n", &za) >= 0)
				)
			{	j = strlen(wbuf) - 1;
				while ((wbuf[j] == '\012') || (wbuf[j] == '\015'))
				{	wbuf[j] = '\0';			/* Get rid of the CR or LF */
					--j;
				}
				sprintf(nbuf, ", \"%s\"", &wbuf[za - 1]);	/* Current unit name */
			}
			fclose(fp);
		}
		if (f == 2)						/* One last chance to get progress */
		{	if (nb <= 0)
			{	cfn("work/wuinfo_??.dat", n);
				if (stat(wbuf, &st) != 0)
					st.st_mtime = 0;
				if	(	((flags & F_ONLY) == 0)
					&&	((fp = fopen(wbuf,"rb")) != NULL)
					)
				{	if (fread(wbuf, 100, 1, fp) == 1)
					{	na = *((u32 *) &wbuf[88]);
						nb = *((u32 *) &wbuf[84]);
						nc = 0;
					}
					fclose(fp);
				}
			}
			fc = (nb > 0) ? ((float) na + (float) nc / 100.0) / (float) nb : 0.0;
			if ((tcl > 0) && (fcl > 0))
				fc += (fc - fcl) * (float) tcc / ((float) tcl + 0.5);
		}
		else
			fc = 1.0;
		xt = (qver >= 324) ? p->expire : 0;
		d = 0.0;
		if	(	((flags & F_ONLY) == 0)
			&&	(fpm != NULL)					/* Is EM III installed ? */
			&&	!gf
			)
		{	rewind(fpm);
			while	(	(fgets(emn, sizeof(emn), fpm) != NULL)
					&&	(fscanf(fpm, "%d%f%d%d", &emd, &emp, &za, &za) >= 2)
					)
			{	q = emn;
				if (q[0] == '"') ++q;
				if ((pn = strchr(q, '"')) == NULL)
					break;
				*++pn = '\0';
				if	(	(	(sscanf(q, "%d", &za) == 1)
						&&	(za == proj)		/* Find project number in <emprotz.dat> */
						)
					||	(strcmp(&nbuf[3], q) == 0)	/* Or find name in <emprotx.dat> */
					)
					goto ed;
				if	(	(nbuf[0] == '\0')		/* We don't know the name, try "pXXX..." */
					&&	(sscanf(q, "%c%d", &zc, &za) == 2)
					&&	((zc == 'p') || (zc == 'P'))
					&&	(za == proj)
					)
				{	*--pn = '\'';					/* Use name from <emprotx.dat> */
					sprintf(nbuf, ", '%s", q);		/* But with single quotes */
ed:					if (xt == 0)
						xt = emd;	/* Use deadline from <emprot?.dat> */
					d = emp;		/* Maybe use points from there too */
					break;
				}
			}
		}
		if	(	((et = (f == 2) ? (int) (st.st_mtime - TIME_OFS) : tp[4]) == 0)
			||	(tp[0] == 0)
			||	((et -= tp[0]) >= 4320000)		/* Elapsed time (max 50 days) */
			||	(et < ((f == 2) ? 30 : 900))	/* min 15 min (30 sec current unit) */
			) et = 0;
		if ((f != 2) && (f != 3))
			ut = tp[4];			/* Ending time */
		else if ((fc > 0) && (et != 0))
			ut = tp[0] + (u32) ((float) et / fc);	/* Projected ending time */
		else
			ut = 0;
		it = (gf ? le4(p->wuid.g.issue[0]) : le4(p->wuid.f.issue[0])) - TIME_OFS;	/* Issue time */
		sscanf(p->teamn, "%d", &za);
		if (gf)
		{	d = (0.05 * (float) cl) * (0.05 * (float) cl + 1.0);
			if (za < 100000)		/* FAH team number */
			{	d *= 5.0 / 12.0;	/* Convert to FAH point scale */
				if (it < 97804800)	/* 0000 6feb03 UTC */
					d /= 2.0;		/* Previously worth only half as much */
			}
			else
				d *= 1.8;			/* Convert to GAH point scale */
		}
		else if (za >= 100000)		/* Genome team number */
			d = 0.0;				/* Don't count FAH points */
		else
		{	mt = 0xFFFFFFFF;
			for (pb = pbuf; pb->proj != 0; ++pb)	/* Look up the points in our tables */
				if	(	(pb->proj == proj)			/* The right project number */
					&&	(pb->until >= it)			/* Not changed before credit was determined */
					&&	(pb->until <= mt)			/* In effect before unit was credited */
					)
				{	d = (float) pb->points / 100.0;
					mt = pb->until;
				}
		}
		j = tp[4];
		uf[0] = ' ';
		if (gf)
			uf[1] = 'N';
		else if (p->core == 0x65)
			uf[1] = 'T';
		else if (p->core == 0x78)
			uf[1] = 'G';
		else if (p->core == 0x79)
			uf[1] = 'D';
		else if (p->core == 0x82)
			uf[1] = 'A';
		else if (p->core == 0x96)
			uf[1] = 'Q';
		else
			uf[1] = ' ';
		if ((xt == 0) && (uf[1] != ' '))
			uf[1] += 'a' - 'A';
		if ((f == 0) && (p->ustat == 0))
		{	j = 0;			/* Deleted */
			uf[0] = 'D';
			et = 0;			/* Don't print score rate if it's deleted */
		}
		else if (f == 2)
		{	j = 1;			/* In progress */
			uf[0] = 'R';
		}
		g = d * fc;
		if ((j != 0) && (g > 0.0) && (et != 0))
		{	bst += (float) et;
			bsp += g;
			g *= 3600.0 / (float) et;
		}
		else
		{	g = 0.0;
			if (uf[0] == ' ')
				uf[0] = 'U';
		}

		if ((flags & F_LOGD) != 0)			/* Print log format data, all on one line */
		{	printf("-%9.08X%9.08X", tp[0], j);
			if (lid != NULL)
				printf("  %s.%u%6u", lid, n, proj);
			else
				printf("%3u%6u", n, proj);
			if (gf)
				printf("%6u%6u%6u", p->wuid.g.miscg1, p->wuid.g.miscg2, p->wuid.g.miscg3);
			else
				printf("%6u%6u%6u", le2(p->wuid.f.run), le2(p->wuid.f.clone), le2(p->wuid.f.gen));
			printf("%6u%8.2f%8.3f%.2s", le4(p->bench), d, g, uf);
			if (nbuf[0] != '\0')
				printf("%.299s", nbuf + 1);
			printf("\n");
			continue;
		}

		if (d > 0.0)
			printf(" %.2f pts", d);
		if (g > 0.0)
			printf(" (%.3f pt/hr)", g);
		if ((et != 0) && (fc > 0.0))
		{	if (xt != 0)
				printf(" %.3g X min speed", (float) xt * fc / (float) et);
			if (f == 2)
				printf("; %.3g%% complete", fc * 100.0);
		}
		printf("\n%s", idnt);
		if	(	(qver >= 324)
			||	(p->svr1 == p->svr2)
			||	(	(p->svr1 == 0)
				&&	(qver >= 300)
				)
			)
			printip("server: ", p->svr2, p->port);
		else
		{	printip("server 1: ", p->svr1, 0);
			printip("; server 2: ", p->svr2, p->port);
		}
		printf("; project: %d%.300s\n", proj, nbuf);
		if (qver < 324)
		{	if (gf)					/* Genome */
				printf("%s\
Genome: unit %u, %u, %u; misc: %u, %u; %u, %u", idnt,
						p->wuid.g.miscg1, p->wuid.g.miscg2, p->wuid.g.miscg3,
						le4(p->bench), le4(p->m476), p->m176, p->m184);
			else					/* Folding */
				printf("%s\
Folding: run %u, clone %u, generation %u; misc: %u, %u; %u, %u", idnt,
						le2(p->wuid.f.run), le2(p->wuid.f.clone), le2(p->wuid.f.gen),
						le4(p->bench), le4(p->m476), p->m176, p->m184);
		}
		else
		{	if (gf)					/* Genome */
				printf("%s\
Genome: unit %u, %u, %u; benchmark %u; misc: %u, %u", idnt,
						p->wuid.g.miscg1, p->wuid.g.miscg2, p->wuid.g.miscg3,
						le4(p->bench), p->m176, p->m184);
			else					/* Folding */
				printf("%s\
Folding: run %u, clone %u, generation %u; benchmark %u; misc: %u, %u", idnt,
						le2(p->wuid.f.run), le2(p->wuid.f.clone), le2(p->wuid.f.gen),
						le4(p->bench), p->m176, p->m184);
		}
		printf("\n%s", idnt);
		prtime("issue: ", it);
		prtime("; begin: ", tp[0]);
		printf("\n");
		za = 0;
		j = 1;
		if ((f != 2) && (f != 3))
			za |= 0x01;
		else if (ut != 0)
			za |= 0x02;
		if (xt != 0)
		{	if	(	(qver >= 324)
				&&	(p->svr1 != 0)
				&&	(dp[0] != 0)
				) za |= 0x04;
			else
				za |= 0x08;
		}
		while ((k = lform(&za)) != 0)
		{	if (k == 0x01)
				prtime("end: ", tp[4]);
			else if (k == 0x02)
				prtime("expect: ", ut);
			else if (k == 0x04)
				prtime("due: ", dp[0]);
			else if (k == 0x08)
				prtime("expire: ", tp[0] + xt);
			if ((k & 0x0C) != 0)
			{	if (xt < 7200)			/* Two hours */
					printf(" (%d minutes)", (xt + 30) / 60);
				else if (xt < 172800)	/* Two days */
					printf(" (%d hours)", (xt + 1800) / 3600);
				else
					printf(" (%d days)", (xt + 43200) / 86400);
			}
		}
		printf("%score URL: ", idnt);
		if (p->url[0] != '\0')
		{	if (strstr(p->url, "google") != NULL)
				printf("http://%.128s", p->url);
			else
			{	q = (qver >= 300) ? "fah" : "exe";
				printf("http://%.128sCore_%02x.%s", p->url, p->core, q);
			}
			if (vbuf[0] != '\0')
				printf(" (V%s)", vbuf);
			printf("\n");
		}
		else printf("MISSING\n");
		if ((qver >= 400) && ((j = le4(p->aiflag)) != 0))
		{	printf("%sassignment info ", idnt);
			if ((unsigned) j > 0xFFFF)		/* Data stored big-endian */
			{	prtime("(be): ", be4(p->aitime));
				printf("; %.08X\n", be4(p->aidata));
			}
			else							/* Data stored little-endian */
			{	prtime("(le): ", le4(p->aitime));
				printf("; %.08X\n", le4(p->aidata));
			}
		}
		if (qver >= 500)
		{	za = 0x08;
			if ((j = le4(p->csip)) != 0)
				za |= 0x01;
			if ((m = be4(p->dstart)) != 0)
				za |= 0x02;
			if	(	(f != 2)			/* Not current unit */
				&&	(	(p->uploads != 0)
					||	(estat == 2)	/* Unit is pending upload */
					)
				) za |= 0x04;
			while ((k = lform(&za)) != 0)
			{	if (k == 0x01)
					printip("CS: ", j, 0);
				else if (k == 0x02)
					prtime("DL: ", m);
				else if (k == 0x04)
					printf("upload failures: %d", p->uploads);
				else if (k == 0x08)
					printf("P limit: %d", p->plimit);
			}
		}
		printf("%.64suser: %s", idnt, p->uname);
		if (p->teamn[0] != '\0')
			printf("; team: %.64s", p->teamn);
		printf("; ID: ");
		for (j = 0; j < 8; ++j) printf("%02X", p->uid[j] & 0xFF);
		if ((j = le4(p->mid)) != 0)
			printf("; mach ID: %d\n", j);
		else
			printf("\n");
		printf("%swork/wudata_%02d.dat file size: %d", idnt, n, p->dsiz);
		if (p->type[0] != '\0')
			printf("; WU type: %.64s\n", p->type);
		else
			printf("\n");
		if ((flags & F_DBGD) != 0)
		{	if ((qver >= 401) || (systype == 1))
				printb(p, p->z004, 4);
			printb(p, p->z192, 16);
			printb(p, p->z224, 36);
			if (qver < 324)
				printb(p, p->z480, 208);
			else
			{	printb(p, p->m476, 20);
				printb(p, p->z500, 8);
				printb(p, p->z528, 160);
			}
		}
	}

	/* Print a few global things from the end of the queue data */

	gf = ((flags & F_INDT) != 0);
	if (qver < 324)
		bp = (struct qf *) ((char *) &qbuf - 160);
	if (qver < 500)
		bp = (struct qf *) ((char *) bp - 80);
	if ((qver >= 401) && (bp->dunits != 0))
	{	if (gf)
		{	printf("\n");
			gf = FALSE;
		}
		printf("Average download rate %d.%03d KB/s (u=%d)",
				bp->drate / 1000, bp->drate % 1000, bp->dunits);
		if (bp->uunits != 0)
			printf("; upload rate %d.%03d KB/s (u=%d)\n",
					bp->urate / 1000, bp->urate % 1000, bp->uunits);
		else
			printf("\n");
	}
	if ((qver >= 324) && (bp->punits != 0))
	{	if (gf)
		{	printf("\n");
			gf = FALSE;
		}
		printf("Performance fraction %.6f (u=%d)\n",
				*(float *)&bp->pfract, bp->punits);
	}
	if ((qver >= 500) && ((flags & F_DBGD) != 0))
		printb(bp, bp->z7152, 16);

	/* Print out our calculated score rates */

	if (bst != 0.0)
	{	if (gf)
		{	printf("\n");
			gf = FALSE;
		}
		d = bsp / bst;
		printf("Average pph: %.3f, ppd: %.2f, ppw: %.1f, ppy: %.0f\n",
				d * 3600.0, d * 86400.0, d * 604800.0, d * 31556736.0);
	}
	if (fpm != NULL)
		fclose(fpm);
	exit(0);
}

/* Construct file name (in wbuf) */

void cfn(char *fn, int n)
{
char *p;
int i;
char w[4];

	if	(	((i = strlen(fdir)) == 0)
		||	(strncmp(fn, "/", 1) == 0)
		||	(strncmp(fn, "./", 2) == 0)
		||	(strncmp(fn, "../", 3) == 0)
#if SYSTYPE == 1
		||	(strncmp(fn, "\\", 1) == 0)
		||	(strncmp(fn, ".\\", 2) == 0)
		||	(strncmp(fn, "..\\", 3) == 0)
		||	(fn[1] == ':')
#endif
		) sprintf(wbuf, "%.200s", fn);
	else if (fdir[i - 1] == '/')
		sprintf(wbuf, "%.200s%.90s", fdir, fn);
	else
		sprintf(wbuf, "%.200s/%.90s", fdir, fn);
	if ((p = strstr(wbuf, "??")) != NULL)
	{	sprintf(w, "%02d", n);
		*p++ = w[0];
		*p = w[1];
	}
#if SYSTYPE == 1
	for (p = wbuf; *p != '\0'; ++p)
		if (*p == '/') *p = '\\';
#endif
}

/* Construct line with variable fields */

int lform(int *p)
{
int i, n;

	n = *p;
	if ((n & 0x7FFF) == 0)
	{	if (n != 0)
			printf("\n");
		return (0);
	}
	if ((n & 0x8000) == 0)
	{	printf("%s", idnt);
		n |= 0x8000;
	}
	else
		printf("; ");
	i = n;
	n &= (n - 1);
	*p = n;
	return (i - n);
}

/* Print IP address */

void printip(char *p, unsigned int ad, unsigned int pt)
{
	printf("%s%d.%d.%d.%d", p,
			ad >> 24, (ad >> 16) & 0xFF, (ad >> 8) & 0xFF, ad & 0xFF);
	if (pt != 0) printf(":%d", pt);
}

/* Print time and date, epoch 0000 1 January 2000 */

void prtime(char *p, unsigned int t)
{
int d, i, y;
char *q, *w;
#if !NO_CTIME
time_t a;
#endif

	if (t == 0)
	{	printf("%sZERO", p);
		return;
	}
#if !NO_CTIME
	if ((flags & F_ZONE) == 0)
	{	a = t + TIME_OFS;	/* Adjust epoch, "ctime" does local time zone */
		if ((q = ctime(&a)) == NULL) q = "BAD DATE";	/* ?? */
		else q[strlen(q) - 1] = '\0';	/* Get rid of the newline */
		printf("%s%s", p, q);
		return;
	}
#endif
	t += tzone;
	i = 1401 + t / 86400;
	w = &"FriSatSunMonTueWedThu"[3 * (i % 7)];
	d = i % 1461;
	d += 60 + d / 365;
	if (d == 1524) --d;
	y = 1996 + ((i / 1461) << 2) + d / 366;
	d %= 366;
	for (q = mtab; (i = d - (int) q[3]) >= 0; q += 4) d = i;
	i = t % 86400;
	printf("%s%3.3s%4.3s%3d %02d:%02d:%02d %d", p,
			w, q, d + 1, i / 3600, (i % 3600) / 60, i % 60, y);
}

/* Print hex bytes */

void printb(void *p, void *q, int n)
{
int i;
int a;
char *fmt;

	a = (int) q - (int) p;
	fmt = ((a + (n & ~0xF)) < 1000) ? " %s%03d:" : "%s%04d:";
	printf(fmt, idnt, a);
	i = 0;
	while (--n >= 0)
	{	if (i >= 16)
		{	printf("\n");
			printf(fmt, idnt, a);
			i = 0;
		}
		if (++i == 9) printf(" ");
		printf(" %02X", ((char *) p)[a++] & 0xFF);
	}
	printf("\n");
}

/* Endian-swap functions */

u32 es32(u32 i)				/* 4-byte endian swap */
{
	return ((i << 24) | ((i & 0xFF00) << 8)
			| ((i & 0xFF0000) >> 8) | ((i & 0xFF000000) >> 24));
}

void eswp(struct qf *bp)	/* Swap endianness of entire queue file */
{
int i, n;
struct qs *p;

	bp->version = es32(bp->version);
	bp->current = es32(bp->current);
	for (n = 10; --n >= 0; )
	{	p = &bp->entry[n];
		if (qver < 324)
			p = (struct qs *) ((char *) p - 16 * n);
		if (qver < 500)
			p = (struct qs *) ((char *) p - 8 * n);
		if ((qver < 401) && (systype != 1))
			p = (struct qs *) ((char *) p - 4 * n);
		p->stat = es32(p->stat);
		if ((qver < 401) && (systype != 1))
			p = (struct qs *) ((char *) p - 4);
		p->tdata[0] = es32(p->tdata[0]);
		p->tdata[1] = es32(p->tdata[1]);
		p->tdata[2] = es32(p->tdata[2]);
		p->tdata[3] = es32(p->tdata[3]);
		p->tdata[4] = es32(p->tdata[4]);
		p->tdata[5] = es32(p->tdata[5]);
		p->tdata[6] = es32(p->tdata[6]);
		p->tdata[7] = es32(p->tdata[7]);
		p->svr1 = es32(p->svr1);
		p->ustat = es32(p->ustat);
		p->m176 = es32(p->m176);
		p->core = es32(p->core);
		p->m184 = es32(p->m184);
		p->dsiz = es32(p->dsiz);
		if (((i = p->core) & 0xFF) == 0)
			i = es32(i);
		p->svr2 = es32(p->svr2);
		p->port = es32(p->port);
		p->expire = es32(p->expire);
		if (qver >= 324)
		{	p->due[0] = es32(p->due[0]);
			p->due[1] = es32(p->due[1]);
			p->due[2] = es32(p->due[2]);
			p->due[3] = es32(p->due[3]);
		}
		if (qver >= 500)
		{	p->uploads = es32(p->uploads);
			p->plimit = es32(p->plimit);
		}
	}
	if (qver < 500)
		bp = (struct qf *) ((char *) bp - 80);
	if (qver >= 324)
	{	bp->pfract = es32(bp->pfract);
		bp->punits = es32(bp->punits);
	}
	if (qver >= 400)
	{	bp->drate = es32(bp->drate);
		bp->dunits = es32(bp->dunits);
		bp->urate = es32(bp->urate);
		bp->uunits = es32(bp->uunits);
	}
}
