/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KXMAME_H_
#define _KXMAME_H_

#define statusBarGameStatId	9
#define statusBarGameTotalId	10

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlabel.h>
#include <qlineedit.h>

#include <kapplication.h>
#include <kmainwindow.h>
#include <kactionclasses.h>
#include <kpopupmenu.h>
#include <klocale.h>

#include "kxmameview.h"
#include "koselectaction.h"

extern bool glocalIsMess;
extern bool isInPrefDialog;
extern class kxmameSplashScreen *mSplashScreen;
extern class kxmamePreferences *mainConfigDialog;
extern class kxmameView *mainView;

/**
 * This class serves as the main window for kxmame.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Nguyen The Toan <nguyenthetoan@gmail.com>
 * @version 1.0.2
 */
class kxmame : public KMainWindow
{
    	Q_OBJECT
public:
	kxmame();
	virtual ~kxmame();
	
protected:
	/**
	* This function is called when it is time for the app to save its
	* properties for session management purposes.
	*/
	//void saveProperties(KConfig *);
	
	/**
	* This function is called when this app is restored.  The KConfig
	* object points to the session management config file that was saved
	* with @ref saveProperties
	*/
	//void readProperties(KConfig *);
	

private slots:

	void exit();
	void romOptionsPreferences();
	void optionsPreferences();
	void directoriesSetup();
	void set_current_executable (XmameExecutable *new_exec);
	void execChanged();
	void gameList();
	void gameRefresh();
	void gameAudit();
	void cloneColor();
	//void quickFilter();
	void changeStatusbar(RomEntry *rom);
	void changeCaption(const QString& text);
	void changeExpandCollapse();
	void changeFavorite(bool);
	
	void setupMameMessUI();
	void select_next_executable();
	
private:
	void setupAccel();
	void setupActions();
	//void setupQuickFilter();
	void setupExecutablesSelection();

	class kxmameView *m_view;
	KAction *mPlayExtAction;
	KAction *mConfigAction,*mAuditAllAction, *mExpandAction, *mCollapseAction;
	KAction *mRefreshAction, *mColumnLayoutAction, *mRebuildAction;
	KoSelectAction *mExecutablesAction;//, *mQuickFilterAction;
	KAction *mAddFavoriteAction;
	KAction *mRemoveFavoriteAction;
	KToggleAction *mShowFolderAction;
	KToggleAction *mShowSideAction, *mShowSearchAction;
	int current_exec_idx;
};

#endif // _KXMAME_H_

