/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include <kdebug.h>

#include <qpixmap.h>
#include <qimage.h>
#include <qtabwidget.h>
#include <klistview.h>
#include <qlabel.h>
#include <qwmatrix.h>
#include <qscrollview.h>
#include <qmetaobject.h>
#include <private/qucomextra_p.h>

#include <kio/netaccess.h>

#include "kxmamelogo.h"
#include "kxmamesnaptab.h"
#include "ColorListViewItem.h"

extern "C" {
#include "unzip.h"
}

static const char *kxmameTemporaryVideoPreview = "/tmp/kxmame_videoPreview";

#define min(a,b)	((a)<(b)?(a):(b))

kxmameSnapTab::kxmameSnapTab(KListView *gamelist, QWidget* parent, const char* name, WFlags fl)
	: MySnapTab(parent,name,fl)
{
	QImage img = QImage( kxmameLogo().convertToImage() );
	kxmamelogo.convertFromImage( img.smoothScale( 320, 240, QImage::ScaleMin ) );

	mGameList = gamelist;
	if(noVideoLabel) noVideoLabel->setPixmap(kxmamelogo);
	videoPreviewFileName = 0;
	currentPreviewedRom = 0;
	mVideoPreviewSlotStop = -1;
	if (mVideoPreview) {
		//use this command to print out lists of kaffeinepart slots
		//kdDebug() << QStringList::fromStrList(mVideoPreview->metaObject()->slotNames()) << endl;
		mVideoPreviewSlotStop = mVideoPreview->metaObject()->findSlot("slotStop()");
	}
	screenPixmap[0] = snapPixmap;
	screenPixmap[1] = flyerPixmap;
	screenPixmap[2] = cabPixmap;
	screenPixmap[3] = marqueePixmap;
	screenPixmap[4] = titlePixmap;
	
	connect (screenshotTab, SIGNAL(currentChanged(QWidget *)),
		 this, SLOT(screenTabChanged(QWidget *)) );
	
	setScaledScreenshot();	
}

kxmameSnapTab::~kxmameSnapTab()
{
	if(videoPreviewFileName) g_free(videoPreviewFileName);
	videoPreviewFileName = 0;
	
	if(KIO::NetAccess::exists(kxmameTemporaryVideoPreview, TRUE, 0))
		  KIO::NetAccess::del(kxmameTemporaryVideoPreview,0);
}

void kxmameSnapTab::setScaledScreenshot()
{
	for(uint i=0; i<5; i++)
		screenPixmap[i]->setScaledContents(gui_prefs.scaledScreenshot);
	if(noVideoLabel)
		noVideoLabel->setScaledContents(gui_prefs.scaledScreenshot);
}

void kxmameSnapTab::screenTabChanged(QWidget *w)
{
	if(!globalIsMess)
		gui_prefs.ShowFlyer = (screenshot_type)screenshotTab->indexOf(w);
	updateScreenTab();
}

void kxmameSnapTab::updateScreenTab()
{
	ColorListViewItem *myGame = (ColorListViewItem *)(mGameList->selectedItem());
	if(!myGame) return;
	
	if(globalIsMess) {
		screenPixmap[2]->setPixmap(get_pix(myGame->mRom,CABINETS));
		return;
	}

	if( (!gui_prefs.showVideoPreview) && (gui_prefs.ShowFlyer == 5) )
		gui_prefs.ShowFlyer = SNAPSHOTS;
	
	if(gui_prefs.ShowFlyer < 5) {
		stopVideo();
		screenPixmap[gui_prefs.ShowFlyer]->setPixmap(
			get_pix(myGame->mRom,gui_prefs.ShowFlyer) );
		return;
	}
	
	if(!mVideoPreview) return;
	
	if(currentPreviewedRom != myGame->mRom) {
		currentPreviewedRom = myGame->mRom;
		get_video(currentPreviewedRom);
	}
	if(videoPreviewFileName) {
		mVideoPreview->openURL(videoPreviewFileName);
		//noVideoLabel->setOnOff(FALSE);
		//mVideoPreview->widget()->show();
	} else {
		//mVideoPreview->widget()->hide();
		//noVideoLabel->setOnOff(TRUE);
		stopVideo();
		//mVideoPreview->closeURL();
	}
}

QPixmap kxmameSnapTab::get_pix (RomEntry *rom, screenshot_type sctype)
{
	QImage pixbuf = QImage();
	gchar *filename;
	gchar *cabDir;
	
	if(globalIsMess)	cabDir=gui_prefs.messSnapDirectory;
	else			cabDir=gui_prefs.CabinetDirectory;

	GXMAME_DEBUG ("width:%i  height:%i", wwidth, wheight);

	if (!rom)
		goto done;

	switch (sctype) {
		case (SNAPSHOTS):
			filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", gui_prefs.SnapshotDirectory, rom->romname);
			break;
		case (FLYERS):
			filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", gui_prefs.FlyerDirectory, rom->romname);
			break;
		case (CABINETS):
			filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", cabDir, rom->romname);
			break;
		case (MARQUEES):
			filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", gui_prefs.MarqueeDirectory, rom->romname);
			break;
		case (TITLES):
			filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", gui_prefs.TitleDirectory, rom->romname);
			break;
		default:
			filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", gui_prefs.SnapshotDirectory, rom->romname);
	}

	pixbuf.load (filename);
	g_free (filename);
	
	/* no picture found try parent game if any*/
	if ( pixbuf.isNull() && (rom->cloneof) && strcmp (rom->cloneof,"-") ) {
		switch (sctype) {
			case (SNAPSHOTS):
				filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", gui_prefs.SnapshotDirectory, rom->cloneof);
				break;
			case (FLYERS):
				filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", gui_prefs.FlyerDirectory, rom->cloneof);
				break;
			case (CABINETS):
				filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", cabDir, rom->cloneof);
				break;
			case (MARQUEES):
				filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", gui_prefs.MarqueeDirectory, rom->cloneof);
				break;
			case (TITLES):
				filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", gui_prefs.TitleDirectory, rom->cloneof);
				break;
			default:
				filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.png", gui_prefs.SnapshotDirectory, rom->cloneof);
		}
		pixbuf.load (filename);
		g_free (filename);
	}

	/* we havent found the picture in the directory, maybe we could try in a zipfile */
	if (pixbuf.isNull()) {
		ZIP *zip;
		struct zipent* zipent;
		gchar *zipfile;
		gchar *tmp_buffer;
		gchar *parent_tmp_buffer = NULL;
		gsize parent_buf_size = 0
				;
		gchar *parent_filename;

		switch (sctype) {
			case (SNAPSHOTS):
				zipfile = g_build_filename (gui_prefs.SnapshotDirectory, "snap.zip", NULL);
				break;
			case (FLYERS):
				zipfile = g_build_filename (gui_prefs.FlyerDirectory, "flyers.zip", NULL);
				break;
			case (CABINETS):
				zipfile = g_build_filename (cabDir, "cabinets.zip", NULL);
				break;
			case (MARQUEES):
				zipfile = g_build_filename (gui_prefs.MarqueeDirectory, "marquees.zip", NULL);
				break;
			case (TITLES):
				zipfile = g_build_filename (gui_prefs.TitleDirectory, "titles.zip", NULL);
				break;
			default:
				zipfile = g_build_filename (gui_prefs.SnapshotDirectory, "snap.zip", NULL);
		}

		zip = openzip (zipfile);

		if (zip) {

			GXMAME_DEBUG ("Succesfully open zip file '%s' !", zipfile);
			filename = g_strdup_printf ("%s.", rom->romname);
			parent_filename = g_strdup_printf ("%s.", rom->cloneof);

			while ( (zipent = readzip (zip)) != 0) {
				/* this should allows to find any format of picture in the zip, not only bmp */
				if (!strncmp (filename,zipent->name, strlen (rom->romname) + 1)) {
					GXMAME_DEBUG ("found file name %s\twith CRC:%i\tsize%i",
							zipent->name,
							zipent->crc32,
							zipent->uncompressed_size);
					tmp_buffer = read_zipentry (zip, zipent);
					if (tmp_buffer) {	
						/* if the file successfully uncompress, try to load it */
						pixbuf.loadFromData ( (guchar *)tmp_buffer, zipent->uncompressed_size,0);
						if (pixbuf.isNull()) {
							GXMAME_DEBUG ("Error while uncompressing %s from %s", zipent->name, zipfile);
						}
						g_free (tmp_buffer);
					}
					/* prevent to read all zip file if we have found the picture's game
					(uncompressed successfuly or not) */
					break;

				} else if (!strncmp (parent_filename, zipent->name, strlen (rom->cloneof) + 1)) {
					parent_tmp_buffer = read_zipentry (zip, zipent);
					parent_buf_size = zipent->uncompressed_size;
				}
			}
			g_free (filename);
			g_free (parent_filename);

			/* no picture found try parent game if any*/
			if (pixbuf.isNull() && parent_tmp_buffer) {
				pixbuf.loadFromData ((guchar *)parent_tmp_buffer, parent_buf_size,0);
				if (pixbuf.isNull()) {
					GXMAME_DEBUG ("Error while uncompressing %s from %s", zipent->name, zipfile);
				}
			}

			g_free (parent_tmp_buffer);
		}

		if (zip)
			closezip (zip);
		else
			GXMAME_DEBUG ("Error, cannot open zip file '%s' !\n", zipfile);

		g_free (zipfile);
		
	}

	
done:
	if (pixbuf.isNull())	return kxmamelogo;
	
	return pixbuf;
}


// void kxmameSnapTab::hideVideo()
// {
// 	if(!mVideoPreview)
// 		return;
// 	
// 	//mVideoPreview->closeURL();
// 	QUObject args[1] = { QUObject() };
// 	//static_QUType_QString.set( &(args[1]), QString("This is a test") );
// 	if(mVideoPreviewSlotStop != -1)
// 		qt_invoke (mVideoPreviewSlotStop,args);
// }
// 
// void kxmameSnapTab::showVideo()
// {
// 	if(!mVideoPreview) return;
// 	mVideoPreview->widget()->show();
// }

void kxmameSnapTab::get_video (RomEntry *rom)
{
	if (videoPreviewFileName) {
		g_free(videoPreviewFileName);
		videoPreviewFileName = NULL;
	}

	if (!rom)	return;

	gchar *filename;
	
	filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.avi", gui_prefs.VideoDirectory, rom->romname);
	if (KIO::NetAccess::exists (filename, TRUE, 0 )) {
		videoPreviewFileName = filename;
		return;
	}
	g_free (filename);
	
	/* no video found try parent game if any*/
	if ( rom->cloneof && strcmp (rom->cloneof,"-")) {
		filename = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.avi", gui_prefs.VideoDirectory, rom->cloneof);
		if (KIO::NetAccess::exists (filename, TRUE, 0 )) {
			videoPreviewFileName = filename;
			return;
		}
		g_free (filename);
	}
	
	/* we havent found the picture in the directory, maybe we could try in a zipfile */
	ZIP *zip;
	struct zipent* zipent;
	gchar *zipfile;
	gchar *tmp_buffer=NULL;
	gchar *parent_tmp_buffer = NULL;
	gsize parent_buf_size = 0, buf_size = 0;
	gchar *parent_filename;

	zipfile = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.zip", gui_prefs.VideoDirectory, rom->romname);
	zip = openzip (zipfile);
	
	if( !zip ) {
		//If we cannot find RomName.zip, we try parentRomName.zip
		g_free(zipfile);
		zipfile = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.zip", gui_prefs.VideoDirectory, rom->cloneof);
		zip = openzip(zipfile);
	}

	if(!zip) {
		g_free(zipfile);
		return;
	}

	if (zip) {
		GXMAME_DEBUG ("Succesfully open zip file '%s' !", zipfile);
		filename = g_strdup_printf ("%s.", rom->romname);
		parent_filename = g_strdup_printf ("%s.", rom->cloneof);

		while ( (zipent = readzip (zip)) != 0) {
			/* this should allows to find any format of picture in the zip, not only bmp */
			if (!strncmp (filename,zipent->name, strlen (rom->romname) + 1)) {
				GXMAME_DEBUG ("found file name %s\twith CRC:%i\tsize%i",
						zipent->name,
						zipent->crc32,
						zipent->uncompressed_size);
				tmp_buffer = read_zipentry (zip, zipent);
				buf_size = zipent->uncompressed_size;
				/* prevent to read all zip file if we have found the video's game */
				break;

			} else if (!strncmp (parent_filename, zipent->name, strlen (rom->cloneof) + 1)) {
				parent_tmp_buffer = read_zipentry (zip, zipent);
				parent_buf_size = zipent->uncompressed_size;
			}
		}
		g_free (filename);
		g_free (parent_filename);

		if(tmp_buffer || parent_tmp_buffer) {
			/* Unzip to /tmp/kxmame_videoPreview */
			FILE *fp = fopen(kxmameTemporaryVideoPreview,"w");
			if(fp) {
				if(tmp_buffer)	fwrite(tmp_buffer, buf_size, 1, fp);
				else		fwrite(parent_tmp_buffer, parent_buf_size, 1 , fp);
				fclose(fp);
				videoPreviewFileName = g_strdup_printf ("%s", kxmameTemporaryVideoPreview);
			}
		}

		if(tmp_buffer) g_free (tmp_buffer);
		if(parent_tmp_buffer) g_free (parent_tmp_buffer);
	}

	if (zip)	closezip (zip);
	g_free (zipfile);
	
	return;
}


#include "kxmamesnaptab.moc"

