/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qregexp.h>
#include <qvaluevector.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qheader.h>
#include <qlistview.h>
#include <qvaluelist.h>
#include <qpoint.h>
#include <qpixmap.h>
#include <qimage.h>
#include <kimageio.h>
#include <qtimer.h>

#include <kglobalsettings.h>
#include <kstandarddirs.h>
#include <kurl.h>
#include <ktrader.h>
#include <klibloader.h>
#include <kmessagebox.h>
#include <krun.h>
#include <klocale.h>
#include <qsplitter.h>
#include <klistbox.h>
#include <klistview.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qpixmap.h>
#include <kfiledialog.h>
#include <kio/netaccess.h>
#include <qtabwidget.h>
#include <kpopupmenu.h>
#include <kprogress.h>
#include <kactionselector.h>
#include <ksplashscreen.h>
#include <ktoolbar.h>
#include <ktoolbarbutton.h>
#include <kuser.h>
#include <kiconloader.h>
#include <kprocess.h>

#include "kxmame.h"
#include "kxmameview.h"
#include "ColorListViewItem.h"
#include "kxmamelogo.h"
#include "kxmamesnaptab.h"
#include "kxmameSplash.h"
#include "katefileselector.h"
#include "kxmame_joy.h"

static folder_filters_list folderType, mameFolderType;//, messFolderType;
static QValueVector<QString> biosList;
static QValueVector<int> biosId;
static gchar *folderValue, *mameFolderValue;//, *messFolderValue;
static QValueVector<ColorListViewItem *> cloneList;
QValueVector<QPixmap> iconlist;

kxmameView::kxmameView(QWidget *parent)
	: QWidget(parent)
{
	mParent = (KMainWindow *)parent;
	
	inDelay = FALSE; 
	mTimer = new QTimer();
	
	mSplashScreen->setMessage(i18n("Loading gamelist"));
	gxmame_init();

	globalIsMess = FALSE;
	if(game_list.name && (!strcmp(game_list.name,"xmess")))
		globalIsMess = TRUE;
	
	KImageIO::registerFormats();

	mSplashScreen->setMessage(i18n("Setting up main window"));
	kapp->processEvents();

	top_layout = new QHBoxLayout(this);

	splitter4 = new QSplitter(this, "splitter4" );
	splitter4->setOrientation( QSplitter::Horizontal );

	/* The game filter column */
	gameFilterList = new KListView( splitter4, "gameFilterList" );
	gameFilterList->addColumn("");
	gameFilterList->setAlternateBackground(QColor());
	gameFilterList->setRootIsDecorated(TRUE);
	gameFilterList->setAllColumnsShowFocus(TRUE);
	gameFilterList->setSorting(-1);
	connect(gameFilterList, SIGNAL(executed(QListViewItem *)),
		this, SLOT(slotFolderFilterChanged(QListViewItem *)));
	connect(gameFilterList, SIGNAL(returnPressed(QListViewItem *)),
		this, SLOT(slotFolderFilterChanged(QListViewItem *)));
	connect(gameFilterList, SIGNAL(spacePressed(QListViewItem *)),
		this, SLOT(slotFolderFilterChanged(QListViewItem *)));
	
	updateFilterList();

	/* The game/system list + search/systemFilter toolbar column */
        QWidget* layoutWidget1 = new QWidget( splitter4, "layout1" );
        QVBoxLayout *gameListLayout = new QVBoxLayout(layoutWidget1);
	
	gameListView = new KListView( layoutWidget1, "gameListView" );
	searchToolBar = new KToolBar( layoutWidget1, "layout2" );
	searchToolBar->setIconSize( 16 );
	
        QWidget *clearButton = new KToolBarButton( "locationbar_erase", 1, searchToolBar );
        QLabel *searchLabel = new QLabel( i18n("S&earch:") + " ", searchToolBar);
 
        KListViewSearchLine *search = new KListViewSearchLine( searchToolBar, "search");
        static_cast<KListViewSearchLine*>(search)->setListView(gameListView);
        searchToolBar->setStretchableWidget( search );
        searchLabel->setBuddy( search );
        connect( clearButton, SIGNAL(clicked()), search, SLOT(clear()) );
	
	gameListView->setShowSortIndicator(TRUE);
	gameListView->setRootIsDecorated(TRUE);
	gameListView->setAllColumnsShowFocus(TRUE);
	gameListView->header()->setMovingEnabled(FALSE);
	
	connect(gameListView, SIGNAL(selectionChanged(QListViewItem *)),
		this, SLOT(slotGameListSelectionChanged()));
	connect(gameListView, SIGNAL(returnPressed(QListViewItem *)),
		this, SLOT(slotGameListDoubleClicked()));
	connect(gameListView, SIGNAL(spacePressed(QListViewItem *)),
		this, SLOT(slotGameListDoubleClicked()));
	connect(gameListView, SIGNAL(doubleClicked(QListViewItem *)),
		this, SLOT(slotGameListDoubleClicked()));
	connect(mTimer,SIGNAL(timeout()), this, SLOT(slotGameListSelectionChangedDelayed()));
	
	gameListContextMenu = new KPopupMenu;
	connect(gameListView, SIGNAL(contextMenu(KListView *, QListViewItem *, const QPoint &)),
		this,SLOT(gameListContext(KListView *, QListViewItem *, const QPoint &)));

	gameListLayout->addWidget(searchToolBar);
	gameListLayout->addWidget(gameListView);

	/* The mess rom file selector column */
	mMessRomSelector = new KateFileSelector(splitter4, "MessRomSelector");
	mMessRomSelector->setupToolbar( 0 );
	mMessRomSelector->setDir(KURL::fromPathOrURL(KUser().homeDir()));
	mMessRomSelector->setFilter( "*.*" );
	connect(mMessRomSelector->dir, SIGNAL(fileSelected(const KFileItem *)),
             this, SLOT(playGame()) );
	
	/* The screenshot + info column */
	splitter3 = new QSplitter( splitter4, "splitter3" );
	splitter3->setOrientation( QSplitter::Vertical );
	
	mScreenTab = new kxmameSnapTab(gameListView, splitter3, "screenTab");
	mScreenTab->screenshotTab->setCurrentPage(gui_prefs.ShowFlyer);
	
	
	gameInfoView = new QTextEdit( splitter3, "gameInfo" );
	gameInfoView->setReadOnly(TRUE);

	top_layout->addWidget( splitter4 );
	
	showSearch = TRUE;
	toggleSearch();
	
}


kxmameView::~kxmameView()
{
	gui_prefs.Splitters[0] = splitter4->sizes()[0];
	gui_prefs.Splitters[2] = splitter4->sizes()[2];
	if(current_exec && current_exec->isMess) {		
		gui_prefs.kxmameGeometry[0] = splitter4->sizes()[1];
		gui_prefs.kxmameGeometry[1] = splitter4->sizes()[2];
		gui_prefs.kxmameGeometry[2] = splitter4->sizes()[3];

	} else {
		gui_prefs.kxmameGeometry[0] = splitter4->sizes()[0];
		gui_prefs.kxmameGeometry[1] = splitter4->sizes()[1];
		gui_prefs.kxmameGeometry[2] = splitter4->sizes()[3];
	}
	gui_prefs.kxmameGeometry[3] = splitter3->sizes()[0];
	gui_prefs.kxmameGeometry[4] = splitter3->sizes()[1];
	
	if ( (gui_prefs.current_mode == DETAILS ) ||(gui_prefs.current_mode == DETAILS_TREE) )
		 saveGameColumnWidth();
	
	gui_prefs.GUIWidth = mParent->size().width();
	gui_prefs.GUIHeight = mParent->size().height();
	
	//gamelist_save();
	exit_gxmame();
	
	biosList.clear();
	biosId.clear();
	cloneList.clear();
	iconlist.clear();
	delete gameFilterList;
	delete gameListView;
	delete mScreenTab;
	delete gameInfoView;
	delete splitter3;
	delete splitter4;
	delete top_layout;
}

void kxmameView::gameListContext(KListView *, QListViewItem *i, const QPoint &p) {
	if(!i) return;
	gameListContextMenu->popup(p);
}

void kxmameView::finalize()
{
	QValueList<int> alist = splitter3->sizes();
	alist[0] = gui_prefs.kxmameGeometry[3];
	alist[1] = gui_prefs.kxmameGeometry[4];
	splitter3->setSizes(alist);
	alist.clear();
	
	if(gui_prefs.ShowFolderList) 	gameFilterList->show();
	else 				gameFilterList->hide();

	if(gui_prefs.ShowScreenShot)	splitter3->show();
	else 				splitter3->hide();

	setupMameMessView();
	
	filterGames();
	setupGameIcons();
	updateGameListView();
	
	if(game_list.name) {
		if ((gui_prefs.current_mode == LIST)||
			(gui_prefs.current_mode == LIST_TREE) || globalIsMess ) {
			int i, id;
			for (i=0; i< gameListView->columns(); i++) {
				id = gui_prefs.ColumnShownId[i];
				if (id == GAMENAME)
					gameListView->setColumnWidth(i,
						gui_prefs.kxmameGeometry[1]);
			}
	#if KDE_IS_VERSION( 3, 3, 90 )
			gameListView->setShadeSortColumn(FALSE);
	#endif
		}
	}
	
	if(currentRom()) {	
		emit signalChangeStatusbar(currentRom());
		emit signalChangeFavorite(currentRom()->favourite);
	}

	/* Hidden code: print out the list of clones to help rom management */
/*	FILE *fp;
	fp = fopen("/home/ntt/clonelist.txt","w");
	GList *listpointer;
	RomEntry *tmprom;
	for (listpointer = g_list_first (game_list.roms);
		(listpointer);
		listpointer= g_list_next (listpointer)) {
			tmprom = (RomEntry *) listpointer->data;
			if((tmprom->cloneof)&&(tmprom->cloneof[0]!='-'))
				fprintf(fp, "%s\n", tmprom->romname);
		}
	fclose(fp);*/
	
}

void kxmameView::setupMameMessView()
{
	globalIsMess = FALSE; /* By default we use mame */
	
	if ( (game_list.name)&&(!strcmp(game_list.name,"xmess")))
		globalIsMess = TRUE;
	else if ( (current_exec) && current_exec->isMess)
		globalIsMess = TRUE;

	if(globalIsMess) {
		folderType = ALL;
		folderValue = NULL;
		gameFilterList->hide();
//		gameListView->setRootDecorated(TRUE);
		mMessRomSelector->show();
		QValueList<int> alist = splitter4->sizes();
		alist[0] = 1;
		alist[1] = gui_prefs.kxmameGeometry[0];
		alist[2] = gui_prefs.kxmameGeometry[1];
		alist[3] = gui_prefs.kxmameGeometry[2];
		splitter4->setSizes(alist);
		alist.clear();
		mScreenTab->removeVideo();
		if(mScreenTab->videoTab)
			mScreenTab->screenshotTab->setTabEnabled(mScreenTab->videoTab,FALSE);
		mScreenTab->screenshotTab->setCurrentPage(2);
		mScreenTab->screenshotTab->setTabEnabled(mScreenTab->flyerTab,FALSE);
		mScreenTab->screenshotTab->setTabEnabled(mScreenTab->snapTab,FALSE);
		mScreenTab->screenshotTab->setTabEnabled(mScreenTab->marqueeTab,FALSE);
		mScreenTab->screenshotTab->setTabEnabled(mScreenTab->titleTab,FALSE);	
	} else {
		folderType = mameFolderType;
		folderValue = mameFolderValue;
		QValueList<int> alist = splitter4->sizes();
		alist[0] = gui_prefs.kxmameGeometry[0];
		alist[1] = gui_prefs.kxmameGeometry[1];
		alist[2] = 1;
		alist[3] = gui_prefs.kxmameGeometry[2];
		splitter4->setSizes(alist);
		alist.clear();
		if(gui_prefs.ShowFolderList) 	gameFilterList->show();
		else 				gameFilterList->hide();
		mMessRomSelector->hide();
		mScreenTab->initVideo();
		if(mScreenTab->videoTab)
			mScreenTab->screenshotTab->setTabEnabled(mScreenTab->videoTab,TRUE);
		mScreenTab->screenshotTab->setTabEnabled(mScreenTab->flyerTab,TRUE);
		mScreenTab->screenshotTab->setTabEnabled(mScreenTab->snapTab,TRUE);
		mScreenTab->screenshotTab->setTabEnabled(mScreenTab->marqueeTab,TRUE);
		mScreenTab->screenshotTab->setTabEnabled(mScreenTab->titleTab,TRUE);
		mScreenTab->screenshotTab->setCurrentPage(gui_prefs.ShowFlyer);
	}
	
	setupJoyEventReceivers();
	emit signalSetupMameMessUI();
}

void kxmameView::updateVideoPreview() {
	/* If we change from showViewPreview on to off, shutdown the video,
	 	otherwise, do nothing */
	if(gui_prefs.showVideoPreview) return;
	
	if(mScreenTab->videoTab) {
		if(mScreenTab->mVideoPreview) {
			delete mScreenTab->mVideoPreview;
			mScreenTab->mVideoPreview = NULL;
		}
	}
}
void kxmameView::stopVideo() { mScreenTab->stopVideo(); }
void kxmameView::setScaledScreenshot() {mScreenTab->setScaledScreenshot();}

#define addGameFilterItem(thisitem,parent,text,id,type,value) \
	(thisitem) = new FilterListViewItem((parent),(text)); \
	(thisitem)->folderID = id; \
	(thisitem)->folderType = type; \
	(thisitem)->folderValue = value;

void kxmameView::updateFilterList() 
{ 
	gameFilterList->clear();
	
	FilterListViewItem *mFilterItem, *mParentFilter, *lastItem = NULL, *lastParentItem=NULL,
		*mUnavailItem;
	
	folderValue = NULL;
	folderType = ALL;
	biosList.clear();
	biosId.clear();	
	
	if(globalIsMess) return;
	
	
	addGameFilterItem(mFilterItem,gameFilterList,i18n("All"), ALL, ALL, NULL);
	lastParentItem = mFilterItem;
	addGameFilterItem(mFilterItem,gameFilterList,i18n("Available"), AVAILABLE, AVAILABLE, NULL);
	mFilterItem->moveItem(lastParentItem);
	lastParentItem = mFilterItem;
	addGameFilterItem(mFilterItem,gameFilterList,i18n("Unavailable"), UNAVAILABLE, UNAVAILABLE, NULL);
	mFilterItem->moveItem(lastParentItem);
	lastParentItem = mFilterItem;
	mUnavailItem = mFilterItem;

	gint folder_ID_selected = NUMBER_FOLDER;
	GList *listpointer;
	
	addGameFilterItem(mParentFilter,gameFilterList,i18n("Manufacturer"), MANUFACTURERS, MANUFACTURERS, NULL);
	mParentFilter->setExpandable(TRUE);
	mParentFilter->setSelectable(FALSE);
	mParentFilter->moveItem(lastParentItem);
	lastParentItem = mParentFilter;
	lastItem = NULL;
	for (listpointer = g_list_first (game_list.manufacturers);
		(listpointer);
		listpointer= g_list_next(listpointer)) {
			addGameFilterItem(mFilterItem,mParentFilter,(gchar *)listpointer->data, \
					folder_ID_selected++,MANUFACTURERS,(gchar *)listpointer->data);
			if (lastItem) mFilterItem->moveItem(lastItem);
			lastItem = mFilterItem;
		}
	
	lastItem = NULL;
	addGameFilterItem(mParentFilter,gameFilterList,i18n("Year"), YEARS, YEARS, NULL);
	mParentFilter->setExpandable(TRUE);
	mParentFilter->setSelectable(FALSE);
	mParentFilter->moveItem(lastParentItem);
	lastParentItem = mParentFilter;
	for (listpointer = g_list_last (game_list.years);
		     (listpointer);
		     listpointer= g_list_previous (listpointer)) {
			     addGameFilterItem(mFilterItem, mParentFilter, (gchar *)listpointer->data, \
					     folder_ID_selected++, YEARS, (gchar *)listpointer->data );
			     if (lastItem) mFilterItem->moveItem(lastItem);
			     lastItem = mFilterItem;
		     }
	
	
	addGameFilterItem(mFilterItem,gameFilterList,i18n("Working"), WORKING, WORKING, NULL);
	mFilterItem->moveItem(lastParentItem);
	lastParentItem = mFilterItem;
	addGameFilterItem(mFilterItem,gameFilterList,i18n("Non-Working"), NONWORKING, NONWORKING, NULL);
	mFilterItem->moveItem(lastParentItem);
	lastParentItem = mFilterItem;

	addGameFilterItem(mParentFilter,gameFilterList,i18n("Custom"), CUSTOMS, CUSTOMS, NULL);
	mParentFilter->moveItem(lastParentItem);
	mParentFilter->setExpandable(TRUE);
	mParentFilter->setSelectable(FALSE);
	lastParentItem = mParentFilter;
	addGameFilterItem(mFilterItem,mParentFilter,i18n("Favorites"), FAVORITES, FAVORITES, NULL);
	addGameFilterItem(mFilterItem,mParentFilter,i18n("Played"), PLAYED, PLAYED, NULL);

	addGameFilterItem(mFilterItem,gameFilterList,i18n("Originals"), ORIGINALS, ORIGINALS, NULL);
	mFilterItem->moveItem(lastParentItem);
	lastParentItem = mFilterItem;
	addGameFilterItem(mFilterItem,gameFilterList,i18n("Clones"), CLONES, CLONES, NULL);
	mFilterItem->moveItem(lastParentItem);
	lastParentItem = mFilterItem;
	addGameFilterItem(mFilterItem,gameFilterList,i18n("Raster"), RASTERS, RASTERS, NULL);
	mFilterItem->moveItem(lastParentItem);
	lastParentItem = mFilterItem;
	addGameFilterItem(mFilterItem,gameFilterList,i18n("Vector"), VECTORS, VECTORS, NULL);
	mFilterItem->moveItem(lastParentItem);
	lastParentItem = mFilterItem;
	addGameFilterItem(mFilterItem,gameFilterList,i18n("Trackball"), TRACKBALL, TRACKBALL, NULL);
	mFilterItem->moveItem(lastParentItem);
	lastParentItem = mFilterItem;
	addGameFilterItem(mFilterItem,gameFilterList,i18n("Stereo"), STEREO, STEREO, NULL);
	mFilterItem->moveItem(lastParentItem);
	lastParentItem = mFilterItem;

	lastItem = NULL;
	addGameFilterItem(mParentFilter,gameFilterList,i18n("Driver"), DRIVERS, DRIVERS, NULL);
	mParentFilter->setExpandable(TRUE);
	mParentFilter->setSelectable(FALSE);
	mParentFilter->moveItem(lastParentItem);
	lastParentItem = mParentFilter;
	for (listpointer = g_list_first (game_list.drivers);
		(listpointer);
		listpointer= g_list_next (listpointer)) {
			addGameFilterItem(mFilterItem, mParentFilter, (gchar *)listpointer->data, \
					folder_ID_selected++, DRIVERS, (gchar *)listpointer->data );
			if (lastItem) mFilterItem->moveItem(lastItem);
			lastItem = mFilterItem;
		}

	lastItem = NULL;
	addGameFilterItem(mParentFilter,gameFilterList,i18n("Category"), CATEGORIES, CATEGORIES, NULL);
	mParentFilter->setExpandable(TRUE);
	mParentFilter->setSelectable(FALSE);
	mParentFilter->moveItem(lastParentItem);
	lastParentItem = mParentFilter;
	for (listpointer = g_list_first (game_list.categories);
		(listpointer);
		listpointer= g_list_next (listpointer)) {
			addGameFilterItem(mFilterItem, mParentFilter, (gchar *)listpointer->data, \
					folder_ID_selected++, CATEGORIES, (gchar *)listpointer->data );
			if (lastItem) mFilterItem->moveItem(lastItem);
			lastItem = mFilterItem;
		}

	lastItem = NULL;
	addGameFilterItem(mParentFilter,gameFilterList,i18n("Version"), VERSIONS, VERSIONS, NULL);
	mParentFilter->setExpandable(TRUE);
	mParentFilter->setSelectable(FALSE);
	mParentFilter->moveItem(lastParentItem);
	lastParentItem = mParentFilter;
	for (listpointer = g_list_first (game_list.versions);
		(listpointer);
		listpointer= g_list_next (listpointer)) {
			addGameFilterItem(mFilterItem, mParentFilter, (gchar *)listpointer->data, \
					folder_ID_selected++, VERSIONS, (gchar *)listpointer->data );
			if (lastItem) mFilterItem->moveItem(lastItem);
			lastItem = mFilterItem;
		}

	addGameFilterItem(mParentFilter,gameFilterList,i18n("Systems"), SYSTEMS, SYSTEMS, NULL);
	mParentFilter->setExpandable(TRUE);
	mParentFilter->setSelectable(FALSE);
	mParentFilter->moveItem(mUnavailItem);
	lastParentItem = mParentFilter;
	
	addGameFilterItem(mFilterItem,mParentFilter,i18n("Neo-Geo"), NEOGEO, NEOGEO, NULL);
	addGameFilterItem(mFilterItem,mParentFilter,i18n("Capcom Play System"), CPS1, CPS1, NULL);
	addGameFilterItem(mFilterItem,mParentFilter,i18n("Capcom Play System II"), CPS2, CPS2, NULL);
	
	//Build the bios filter
	RomEntry *tmprom;
	gchar biosName[1000];
	for (listpointer = g_list_first (game_list.roms);
		(listpointer);
		listpointer= g_list_next (listpointer)) {
			tmprom = (RomEntry *)listpointer->data;
			if( ((!tmprom->cloneof)||(tmprom->cloneof[0]=='-')) &&
						    ((tmprom->romof)&&(tmprom->romof[0]!='-') ))
			{
				bool foundBios = FALSE;
				for(uint i = 0; i<biosList.count(); i++) {
					if(!QString::compare(biosList[i],tmprom->romof)) {
						foundBios = TRUE;
						break;
					}
				}
				//Due to gxmame historical reason, neogeo was implemented
				//as a standalone filter. We, therefore, remove
				//the neogeo bios entry.
				if( (!foundBios) && strcmp(tmprom->romof,"neogeo")){
					biosList.append(tmprom->romof);
					biosId.append(folder_ID_selected);
					strncpy(biosName, rom_entry_get_list_name (rom_entry_by_name(tmprom->romof)),1000);
					if(strlen(biosName)>0) {
						//Chop off the word "BIOS" at the end
						uint l = strlen(biosName)-1;
						while (biosName[l]==' ') { biosName[l]='\0'; l--; }
						if(!strcasecmp(biosName+strlen(biosName)-5, " bios"))
							biosName[strlen(biosName)-5]='\0';
						addGameFilterItem(mFilterItem, mParentFilter, biosName, \
								folder_ID_selected++, SYSTEMS, NULL);
					}
				}
			}
		}
	
	mParentFilter->sortChildItems(0, TRUE);
		
	if(gui_prefs.FolderID == NULL_FOLDER_ID)
		gui_prefs.FolderID = ALL;
	
	/* set filter selection */
	QListViewItemIterator it( gameFilterList );
	while ( it.current() ) {
		mFilterItem = (FilterListViewItem *)(it.current());
		if(mFilterItem->folderID == gui_prefs.FolderID) {
			gameFilterList->setSelected(mFilterItem,TRUE);
			gameFilterList->ensureItemVisible(mFilterItem);
			mameFolderType = folderType = mFilterItem->folderType;
			mameFolderValue = folderValue = mFilterItem->folderValue;
		}
		++it;
	}

	gameFilterList->header()->hide();
}

void kxmameView::toggleFilter()
{
	if(gui_prefs.ShowFolderList) {
		gui_prefs.ShowFolderList = FALSE;
		gameFilterList->hide();
	} else {
		gui_prefs.ShowFolderList = TRUE;
		gameFilterList->show();
	}

}

void kxmameView::toggleSide()
{
	if(gui_prefs.ShowScreenShot) {
		gui_prefs.ShowScreenShot = FALSE;
		splitter3->hide();
	} else {
		gui_prefs.ShowScreenShot = TRUE;
		splitter3->show();
	}
}

// void kxmameView::quickFilter(folder_filters_list mFolderType, gchar *mFolderValue)
// {
// 	messFolderType = folderType = mFolderType;
// 	messFolderValue = folderValue = mFolderValue;
// 	filterGames();
// 	updateGameListView();
// }

void kxmameView::slotFolderFilterChanged(QListViewItem *Item)
{
	FilterListViewItem *item = (FilterListViewItem *)Item;

	if ( 	(item->folderID == MANUFACTURERS) ||
		(item->folderID == CUSTOMS) ||
		(item->folderID == VERSIONS) ||
		(item->folderID == CATEGORIES) ||
		(item->folderID == DRIVERS) ||
		(item->folderID == SYSTEMS) ||
		(item->folderID == YEARS) )
		return;
	
	folder_filters_list currentFolderID = gui_prefs.FolderID;
	gui_prefs.FolderID = (folder_filters_list) item->folderID;
	
	if (gui_prefs.FolderID == currentFolderID)
		return;

	saveGameColumnSort();
	
	mameFolderType = folderType = (folder_filters_list) item->folderType;
	mameFolderValue = folderValue = item->folderValue;
	
	filterGames();
	updateGameListView();
}

void kxmameView::filterGames() {

	if(game_list.num_games <= 0)
		return;

	GList *listpointer;
	RomEntry *tmprom, *tmpParentRom;
	gchar **manufacturer;

	QString bios;
	
	if(folderType == SYSTEMS) {
		for(uint i=0; i<biosId.count(); i++) {
			if (biosId[i] == gui_prefs.FolderID) {
				bios = biosList[i];
				break;
			}
		}
	}

	/* loop through the games list and set is_in_list correspondingly */
	for (listpointer = g_list_first (game_list.roms);
	     (listpointer);
	     listpointer= g_list_next (listpointer)) {
		tmprom = (RomEntry *) listpointer->data;
		if(tmprom) {
			if( (folderType!=CATEGORIES)&&(!strcmp(tmprom->category,"BIOS")) ) {
				tmprom->is_in_list = FALSE;
				continue;
			}
			switch (folderType) {
				case (AVAILABLE):
					tmprom->is_in_list = tmprom->has_roms == 1;
					break;
				case (UNAVAILABLE):
					tmprom->is_in_list = tmprom->has_roms != 1;
					break;
				case (WORKING):
					tmprom->is_in_list = tmprom->status;
					break;
				case (NONWORKING):
					tmprom->is_in_list = !tmprom->status;
					break;
				case (NEOGEO):
					tmprom->is_in_list = (!strncmp(tmprom->driver,"neogeo",6));
					break;
				case (CPS1):
					tmprom->is_in_list = (!strncmp(tmprom->driver,"cps1",4));
					break;
				case (CPS2):
					tmprom->is_in_list = (!strncmp(tmprom->driver,"cps2",4));
					break;
				case (CLONES):
					tmprom->is_in_list = ((tmprom->cloneof) && (tmprom->cloneof[0]!='-'));
					break;
				case (ORIGINALS):
					tmprom->is_in_list = ((!tmprom->cloneof) || (tmprom->cloneof[0]=='-'));
					break;
				case (RASTERS):
					tmprom->is_in_list = !tmprom->vector;
					break;
				case (VECTORS):
					tmprom->is_in_list = tmprom->vector;
					break;
				case (TRACKBALL):
					tmprom->is_in_list = (!strcmp(tmprom->control,"trackball"));
					break;
				case (PLAYED):
					tmprom->is_in_list = (tmprom->timesplayed > 0);
					break;
				case (FAVORITES):
					tmprom->is_in_list = (tmprom->favourite);
					break;
				case DRIVERS:
					tmprom->is_in_list =  ( !g_strcasecmp (tmprom->driver, folderValue));
					break;
				case VERSIONS:
					tmprom->is_in_list = ( ((tmprom->mame_ver_added == folderValue)));
					break;
				case CATEGORIES:
					tmprom->is_in_list = ( ((tmprom->category == folderValue)) );
					break;
				case STEREO:
					tmprom->is_in_list = ( ((tmprom->channels == 2)) );
					break;
				case YEARS:
					tmprom->is_in_list = ( ((tmprom->year == folderValue)) );
					break;
				case SYSTEMS:
					tmprom->is_in_list = FALSE;
					if ( ((!tmprom->cloneof) || (tmprom->cloneof[0]=='-')) &&
						(!QString::compare(bios,tmprom->romof)))
						tmprom->is_in_list = TRUE;
					if ((tmprom->cloneof) && (tmprom->cloneof[0]!='-')) {
						tmpParentRom = rom_entry_by_name(tmprom->cloneof);
						if(!QString::compare(bios,tmpParentRom->romof))
							tmprom->is_in_list = TRUE;
					}
					break;
					/* comparing parsed text and text */
				case MANUFACTURERS:
					tmprom->is_in_list = FALSE;
					manufacturer = rom_entry_get_manufacturers (tmprom);
					if(manufacturer) {
						/* we have now one or two clean manufacturer (s) we still need 
						to differentiates sub companies*/
						if (manufacturer[1] != NULL) {
							if ( (!g_strncasecmp (manufacturer[0], folderValue, 5))  ||
									(!g_strncasecmp (manufacturer[1], folderValue, 5)) )
								tmprom->is_in_list = TRUE;
						} else {
							if ( (!g_strncasecmp (manufacturer[0], folderValue, 5)) )
								tmprom->is_in_list = TRUE;
						}
						g_strfreev (manufacturer);
					}
					break;
				case (NULL_FOLDER_ID):
				case (ALL):
				default:
					tmprom->is_in_list = TRUE;
					break;
			};
		}
	}
}


void kxmameView::changeGameListView(ListMode newMode)
{
	ListMode oldMode = gui_prefs.current_mode;

	if (newMode == oldMode) return;
	
	if  ( ((newMode == LIST_TREE)||(newMode == LIST))&&
		((oldMode == DETAILS_TREE)||(oldMode == DETAILS)) )
	{
		saveGameColumnWidth();
		gameListView->setAlternateBackground(QColor());
		gameListView->header()->hide();
#if KDE_IS_VERSION( 3, 3, 90 )
		gameListView->setShadeSortColumn(FALSE);
#endif
	}

	if  ( ( ((oldMode == LIST_TREE)||(oldMode == LIST))&&
		((newMode == DETAILS_TREE)||(newMode == DETAILS)) ) &&
			 strcmp(game_list.name,"xmess") )
	{
		restoreGameColumnWidth();
		gameListView->header()->show();
		gameListView->setAlternateBackground(KGlobalSettings::alternateBackgroundColor());
#if KDE_IS_VERSION( 3, 3, 90 )
		gameListView->setShadeSortColumn(TRUE);
#endif
	}

	if  ( ((newMode == LIST_TREE)||(newMode == DETAILS_TREE))&&
		((oldMode == LIST)||(oldMode == DETAILS)) )
		tree(TRUE);
	if  ( ((oldMode == LIST_TREE)||(oldMode == DETAILS_TREE))&&
		((newMode == LIST)||(newMode == DETAILS)) )
		tree(FALSE);

	gameListView->triggerUpdate();
	gui_prefs.current_mode = newMode;
	
	emit signalChangeExpandCollapse();
}

void kxmameView::listView() {changeGameListView(LIST);}
void kxmameView::listTreeView(){changeGameListView(LIST_TREE);}
void kxmameView::detailView() {changeGameListView(DETAILS);}
void kxmameView::detailTreeView(){changeGameListView(DETAILS_TREE);}

void kxmameView::tree(bool istree)
{
	gameListView->setRootIsDecorated(istree);
	
	if ( (	(gui_prefs.FolderID == CLONES) ||
			(gui_prefs.FolderID == ORIGINALS) ) && (!globalIsMess)){
		gameListView->setRootIsDecorated(FALSE);
		return;
	}
	
	bool wasUpdatesEnabled = gameListView->isUpdatesEnabled();
	gameListView->setUpdatesEnabled( FALSE );
//	gameListView->clearSelection();

	QListViewItem *curItem = gameListView->currentItem();	

	ColorListViewItem *gameParentItem;
	for(uint i=0; i< cloneList.size(); i++) {
		gameParentItem = (ColorListViewItem *)(cloneList[i]->mParentGameItem);
		if (gameParentItem) {
			if (istree) {
				gameListView->takeItem(cloneList[i]);
				gameParentItem->insertItem(cloneList[i]);
			} else {
				gameParentItem->takeItem(cloneList[i]);
				gameListView->insertItem(cloneList[i]);
			}
		}
	}
	
	if(curItem) {
		gameListView->ensureItemVisible(curItem);
		gameListView->setSelected(curItem,TRUE);
	}
	
	gameListView->setUpdatesEnabled( wasUpdatesEnabled );
//	gameListView->triggerUpdate();
}

void kxmameView::expandGameList()
{
	QListViewItem *mChild = gameListView->firstChild();

	while (mChild) {
		mChild->setOpen(TRUE);
		mChild = mChild->nextSibling();
	}
}

void kxmameView::collapseGameList()
{
	QListViewItem *mChild = gameListView->firstChild();

	while (mChild) {
		mChild->setOpen(FALSE);
		mChild = mChild->nextSibling();
	}
}

void kxmameView::slotGameListSelectionChanged()
{
	// Do not update screen until the user stops movement the list.
	if(!inDelay) {
		inDelay = TRUE;
		mTimer->start(333,TRUE);
	} else {
		mTimer->changeInterval(333);
	}
}

void kxmameView::slotGameListSelectionChangedDelayed()
{	
	ColorListViewItem *curItem = (ColorListViewItem *)gameListView->selectedItem();
	if (!curItem) return;
	
	mScreenTab->updateScreenTab();
	
	//Change game info
	QString infoTextBuffer;
	QString historyTextBuffer, entry_name;
	RomEntry *tmprom;
	bool foundGame;

	tmprom = curItem->mRom;

	entry_name = QString(tmprom->romname);
	foundGame = set_history(entry_name, &historyTextBuffer);
	if ( (!foundGame) && (tmprom->cloneof && (tmprom->cloneof[0] != '-')) ) {
		//Clear the "not found" message for clone
		historyTextBuffer = QString();
		// Try the history for parent game
		entry_name = QString(tmprom->cloneof);
		set_history(entry_name, &historyTextBuffer);
	}
	
	if(globalIsMess) {
		/* set romfile extension filter */
		RomEntry *tmprom;
		tmprom = curItem->mRom;
		QString str;
		GList *listpointer = g_list_first (tmprom->devices);

		while ( (listpointer != NULL))	{
			listpointer = g_list_next (listpointer);
			str = str+" *."+(char *)listpointer->data;
			listpointer = g_list_next (listpointer);
		}
		if(tmprom->devices)
			str = str + " *.zip" ;
		
		mMessRomSelector->clearFilter();
		mMessRomSelector->setFilter(str);

		gameInfoView->setText(historyTextBuffer);
	
	} else {
		entry_name = QString(tmprom->romname);
		foundGame = set_info(entry_name, &infoTextBuffer);
		if ( (!foundGame) && (tmprom->cloneof && (tmprom->cloneof[0] != '-')) ) {
			// Try the info for parent game
			entry_name = QString(tmprom->cloneof);
			set_info(entry_name, &infoTextBuffer);
		}
	
		gameInfoView->setText(historyTextBuffer+"\n\n"+infoTextBuffer);
	}

	emit signalChangeStatusbar(tmprom);
	emit signalChangeFavorite(tmprom->favourite);
	// change current_game
	//gui_prefs.current_game = tmprom;
	if(globalIsMess) {
		if(gui_prefs.currentMess) g_free(gui_prefs.currentMess);
		gui_prefs.currentMess = g_strdup(tmprom->romname);
	} else {
		if(gui_prefs.currentMame) g_free(gui_prefs.currentMame);
		gui_prefs.currentMame = g_strdup(tmprom->romname);
	}
	
	inDelay = FALSE;
	mTimer->stop();
}

bool kxmameView::set_history (const QString  entry_name,
	     QString *text_buffer)
{
	FILE *history_file;
	gchar line[2000];
	gint i, n;
	gchar *tmp, *p;
	gchar **games;
	gboolean found_game = FALSE;
	gboolean pointer_in_info = FALSE;
	gboolean extra_newline = FALSE;
	
	if(current_exec->isMess) {
		history_file = fopen (gui_prefs.sysinfoFile, "r");
	} else {
		history_file = fopen (gui_prefs.HistoryFile, "r");
	}

	if (!history_file) {
		//GXMAME_DEBUG ("History.dat file not found");
		if(current_exec->isMess) 
			text_buffer->append(i18n("Sysinfo.dat file not found"));
		else
			text_buffer->append(i18n("History.dat file not found"));
		return (FALSE);
	}

	/* Scan through the file. First look for '$',then $info=game, $bio and $end */
	while (fgets (line, 500, history_file)) {
		p = line;
		tmp = p;
		if (*tmp == '$' && !found_game) {
			/* Found a line */
			if (!strncmp (p, "$info", 5)) {
				p = tmp = p + 6;
				/* It is an info line */
				if(current_exec->isMess) {
					if(!entry_name.lower().compare(QString(p).stripWhiteSpace().lower())) 
						found_game = TRUE;
				} else {
					i = 0;
					while (*tmp && (*tmp++ != '\n'))
						i++;
					/* Sometimes the list is continued on the next line */
					i--;
					do {
						p[i] = fgetc (history_file);
						if (p[i] == '\n')
							i--;
						if (p[i] == '\r')
							i--;
						i++;
	
					} while ( (p[i - 1] != '$') && i < 2000 /* buffer size */);
					if (p[i - 1] == '$')
						ungetc ('$', history_file);
	
					p[i - 1] = 0;
					games = g_strsplit (p, ",", 20);
					n = 0;
	
					while ( (games[n])) {
						games[n] = g_strchomp (games[n]);
						/* should do a case insensitive comparison here */
						if (!entry_name.compare(games[n])) { 
							/* It is the info for the wanted game */
							found_game = TRUE;
						}
						n++;
					}
					g_strfreev (games);
				}
			}
		} else if (found_game && (*tmp == '$')) {
			if (!strncmp (p, "$bio", 4))
				pointer_in_info = TRUE;
			if (!strncmp (p, "$end", 4)) {
				pointer_in_info = FALSE;
				break;
			}
		} else if (found_game && pointer_in_info) {
			i = 0;
			while (*tmp && (*tmp != '\r') && (*tmp++ != '\n'))
				i++;
			if (i == 0) {/* and a new line but not severals*/
				if (!extra_newline) {
					extra_newline = TRUE;
				} else
					extra_newline = FALSE;
			} else {
				extra_newline = FALSE;
			}

			if (!extra_newline) {

				p[i] = '\n';
				p[i + 1] = '\0';

				text_buffer->append(p);
			}
		}
	}

	if (!found_game) {
		text_buffer->append(i18n("no history info found for %1").
				arg(rom_entry_get_list_name (rom_entry_by_name(entry_name) ) ));
	}

	fclose (history_file);

	return (found_game);
}

bool kxmameView::set_info (const QString entry_name, QString *text_buffer)
{
	
	FILE *mameinfo_dat;
	gchar line[2000];
	gint i;
	gchar *tmp, *p;
	gboolean found_game = FALSE;
	gboolean pointer_in_info = FALSE;
	gboolean extra_newline = FALSE;

	mameinfo_dat = fopen (gui_prefs.MameInfoFile, "r");

	if (!mameinfo_dat) {
		//GXMAME_DEBUG ("mameinfo_dat file not found");
		text_buffer->append(i18n("mameinfo.dat file not found."));
		return (FALSE);
	}

	/* Scan through the file. First look for '$',then $info=game, $mame and $end */
	while (fgets (line, 500, mameinfo_dat)) {
		p = line;
		tmp = p;
		/* Found a line */
		if (*tmp == '$' && !found_game) {
			/* It is an info line */
			if (!strncmp (p, "$info", 5)) {
				p = tmp = p + 6;
				while (*tmp && (*tmp != '\n') && (*tmp++ != '\r'));
				tmp--; *tmp='\0';
				/* it's the god game */
				if (!entry_name.compare(p)) {
					found_game = TRUE;
				}
			}
		} else if (found_game && (*tmp == '$')) {
			if (!strncmp (p, "$mame", 5))
				pointer_in_info = TRUE;
			else if (!strncmp (p, "$end", 4)) {
				pointer_in_info = FALSE;
				break;
			}
		} else if (found_game && pointer_in_info) {
			i = 0;
			while (*tmp && (*tmp != '\r') && (*tmp++ != '\n'))
				i++;
			if (i == 0) { /* and a new line but not severals*/
				if (!extra_newline) {
					extra_newline = TRUE;
				} else
					extra_newline = FALSE;
			} else {
				extra_newline = FALSE;
			}

			if (!extra_newline) {
				//gsize bytes_read, bytes_written;
				p[i] = '\n';
				p[i + 1] = '\0';
				text_buffer->append(p);
		

			}
		}
	}

	if (!found_game) {
		GXMAME_DEBUG ("no MameInfo info found for %s", entry_name);
	}

	fclose (mameinfo_dat);

	return found_game;
}

void kxmameView::saveGameColumnSort()
{
	int i, id;
	for (i=0; i<gameListView->columns(); i++) {
		id = gui_prefs.ColumnShownId[i];
		if (i == gameListView->sortColumn()) {
			// Save the current sort column
			gui_prefs.SortColumn = id;
			gui_prefs.SortReverse = (gameListView->sortOrder() != Qt::Ascending);
		}
	}
}

void kxmameView::saveGameColumnWidth()
{
	if (globalIsMess) return;

	saveGameColumnSort();
	
	int i, id;
	for (i=0; i<gameListView->columns(); i++) {
		id = gui_prefs.ColumnShownId[i];
		gui_prefs.ColumnWidth[id] = gameListView->columnWidth(i);
	}
		
	/* We need to loop twice to avoid column width being self
		adjusted when we hide the columns. */
	for (i=0; i<gameListView->columns(); i++) {
		if(i!= gameNameColumnId)
			gameListView->hideColumn(i);
		else
			gameListView->setColumnWidth(i,gameListView->childrenRect().width());
	}
#if KDE_IS_VERSION( 3, 3, 90 )
	gameListView->setShadeSortColumn(FALSE);
#endif
}

void kxmameView::restoreGameColumnWidth()
{
	if(globalIsMess) {
		sortGameList();
		return;
	}

	int i, id;
	
	for (i=0; i<gameListView->columns(); i++) {
		id = gui_prefs.ColumnShownId[i];
		if(gui_prefs.ColumnWidth[id]) {
			gameListView->setColumnWidth(i,gui_prefs.ColumnWidth[id]);
		} else {
// It rarely happens but if columnwidth is somehow zero, we make it a finite value.
// A possible case is after the user inserts a new column
			gameListView->setColumnWidthMode(i,QListView::Maximum);
		}
	}
#if KDE_IS_VERSION( 3, 3, 90 )
	gameListView->setShadeSortColumn(TRUE);	
#endif
	sortGameList();	
}

void kxmameView::columnsLayout()
{
	KDialogBase *dlg = new KDialogBase(KDialogBase::Plain, 0, KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::NoDefault);
	QHBoxLayout *topLayout = new QHBoxLayout( dlg->plainPage(), 0, KDialog::spacingHint() );
	KActionSelector *colSelector = new KActionSelector(dlg->plainPage());
	
	QStringList strs;
	int i, id;

	colSelector->setSelectedLabel(i18n("Shown columns"));
	colSelector->setAvailableLabel(i18n("Available columns"));
	topLayout->addWidget(colSelector);
	
	dlg->enableButtonSeparator(TRUE);
	dlg->resize(QSize(450,300));
	
restart:
	for(i =0 ; i < NUMBER_COLUMN; i++) {
		id = gui_prefs.ColumnHiddenId[i];
		if(id != -1)
			strs << column_title (id);
	}
	colSelector->availableListBox()->clear();
	colSelector->availableListBox()->insertStringList(strs);
	strs.clear();
	
	colSelector->selectedListBox()->clear();
	for(i =0 ; i < NUMBER_COLUMN; i++) {
		id = gui_prefs.ColumnShownId[i];
		if(id != -1)
			colSelector->selectedListBox()->insertItem(column_title (id),
				gameListView->header()->mapToIndex(i));
	}
	
	if (dlg->exec())
	{
		bool foundGame = FALSE;
		for (uint u=0; u<colSelector->selectedListBox()->count();u++) {
			if(!QString::compare(colSelector->selectedListBox()->item(u)->text(),
				column_title(0)))
			{
				foundGame = TRUE;
				break;
			}
		}
			
		if(!foundGame) {
			gxmame_message(ERROR,NULL,"Sorry, you cannot remove the Game column.");
			goto restart; //it's ugly but it's convenient.
		}

		for (i=0; i< NUMBER_COLUMN; i++)
			gui_prefs.ColumnShown[i] = 0;
		
		for (uint u=0; u<colSelector->selectedListBox()->count();u++) {
			for (id=0; id<NUMBER_COLUMN; id++) {
				if(!QString::compare(colSelector->selectedListBox()->item(u)->text(),
				    column_title(id)))
				{
					gui_prefs.ColumnOrder[id] = u;
					gui_prefs.ColumnShown[id] = 1;
					break;
				}
			}
		}
		id = colSelector->selectedListBox()->count();
		for (i=0; i< NUMBER_COLUMN; i++) {
			if(gui_prefs.ColumnShown[i] == 0) {
				gui_prefs.ColumnOrder[i] = id;
				id++;
			}
		}
		update_columns_tab();
		updateGameListView();
	}
	
	delete colSelector;
	delete dlg;
}

void kxmameView::sortGameList()
{
	if(globalIsMess) {
		gameListView->setSorting(0, gui_prefs.SortReverse == 0);
		return;
	}

	int gameColumn = -1, id, i;
	bool sorted = FALSE;
	
	for (i=0; i<NUMBER_COLUMN; i++) {
		id = gui_prefs.ColumnShownId[i];
		if (id != -1) {
			if(id==gui_prefs.SortColumn) {
				gameListView->setSorting(i, gui_prefs.SortReverse == 0);
				sorted = TRUE;
			}
			
			if(!QString::compare(gameListView->columnText(i), column_title(GAMENAME)))
				gameColumn = i;
		}
		else
			break;
	}

	if(globalIsMess) {
		gameListView->setSorting(gameColumn, gui_prefs.SortReverse == 0);
		return;
	}
	
	if ((!sorted) && (gameColumn != -1)) {
		gui_prefs.SortColumn = GAMENAME;
		gameListView->setSorting(gameColumn, gui_prefs.SortReverse == 0);
	}
}

void kxmameView::updateGameListView()
{
	GList *listpointer;
	RomEntry *tmprom;
	ColorListViewItem *gameItem, *curItem = NULL;
	gchar *curName =globalIsMess?gui_prefs.currentMess:gui_prefs.currentMame;
	uint index;
	int i, id, nameColumn;
	
	visible_games = 0;

	bool wasUpdateEnabled = gameListView->isUpdatesEnabled();
	gameListView->setUpdatesEnabled( FALSE );

	cloneList.clear();

	gameListView->clear();
	id = gameListView->columns();
	for(i= id-1 ; i>=0; i--)
		gameListView->removeColumn(i);
	
	nameColumn = 0;
	if (globalIsMess){
		gameListView->addColumn(column_title( GAMENAME));
		gameNameColumnId = 0;
	} else {
		for (i=0; i<NUMBER_COLUMN; i++) {
			id = gui_prefs.ColumnShownId[i];
			if (id != -1) {
				gameListView->addColumn(column_title(id));
				if(id == GAMENAME)
					gameNameColumnId = nameColumn;
				nameColumn++;
			}
			else
				break;
		}
	}

	if(game_list.num_games <= 0)
		return;

	if(globalIsMess) 
		gameListView->setColumnWidthMode(0, QListView::Maximum);
	else
		for (i=0; i < gameListView->columns(); i++)
			gameListView->setColumnWidthMode(i, QListView::Manual);

	/* fill the game list with originals */
	QValueVector<ColorListViewItem *> parentList = QValueVector<ColorListViewItem *>();
	if ((gui_prefs.FolderID != CLONES ) || globalIsMess ) {
		index = 0;
		for (listpointer = g_list_first (game_list.roms);
		(listpointer);
		listpointer= g_list_next (listpointer)) {
			tmprom = (RomEntry *) listpointer->data;
			if(tmprom->is_in_list && ((!(tmprom->cloneof))||(tmprom->cloneof[0]=='-')) )
			{
				gameItem = new ColorListViewItem(gameListView);
				visible_games++;
				gameItem->setupGameListViewItem(tmprom, index, FALSE, iconlist[index]);
				parentList.append(gameItem);
				if(curName && (!strcmp(tmprom->romname,curName)))
					curItem = gameItem;
			}
			index++;
		}

	}
	/* Now we loop again and insert the clones */
	if ( (gui_prefs.FolderID != ORIGINALS ) || globalIsMess ) {
		index = 0;
		for (listpointer = g_list_first (game_list.roms);
		(listpointer);
		listpointer= g_list_next (listpointer)) {
			tmprom = (RomEntry *) listpointer->data;
			if(tmprom->is_in_list && (tmprom->cloneof) && (tmprom->cloneof[0]!='-')) {
				ColorListViewItem *aParent = NULL;
				if ((gui_prefs.FolderID != CLONES )|| globalIsMess ) {
					/* Let's find the parent gameItem */
					for(uint i=0; i< parentList.size(); i++)
						if ( !strcmp(tmprom->cloneof,parentList[i]->mRom->romname) ) {
							aParent =  parentList[i];
							break;
						}
				}
				
				if ( (aParent && ( (gui_prefs.current_mode == DETAILS_TREE)
						||(gui_prefs.current_mode == LIST_TREE) ) ) )
					gameItem = new ColorListViewItem(aParent);
				else
					gameItem = new ColorListViewItem(gameListView);
				
				gameItem->mParentGameItem = aParent;
				gameItem->setupGameListViewItem(tmprom, index, TRUE, iconlist[index]);
				
				if(curName && (!strcmp(tmprom->romname,curName)))
					curItem = gameItem;
				cloneList.append(gameItem);
				visible_games++;
			}
			index++;
		}
	}
	
	restoreGameColumnWidth();
	sortGameList();
	
	if ( (gui_prefs.current_mode == LIST) ||
		(gui_prefs.current_mode == LIST_TREE) || 
		globalIsMess )
	{
		saveGameColumnWidth();
		gameListView->setAlternateBackground(QColor());
		gameListView->header()->hide();
	} else {
		gameListView->setAlternateBackground(KGlobalSettings::alternateBackgroundColor());
		gameListView->header()->show();
#if KDE_IS_VERSION( 3, 3, 90 )
		gameListView->setShadeSortColumn(TRUE);
#endif
	}
	
	if ( ( ( (gui_prefs.current_mode == DETAILS_TREE)||(gui_prefs.current_mode == LIST_TREE) ) &&
			 (gui_prefs.FolderID != ORIGINALS) && (gui_prefs.FolderID != CLONES) ) || globalIsMess)
		gameListView->setRootIsDecorated(TRUE);
	else
		gameListView->setRootIsDecorated(FALSE);

	
	if (visible_games) {
		if(!curItem) curItem = (ColorListViewItem *)(gameListView->firstChild());
		if(globalIsMess)
			kxmame_replace(gui_prefs.currentMess, g_strdup(curItem->mRom->romname))
		else
			kxmame_replace(gui_prefs.currentMame, g_strdup(curItem->mRom->romname));
		gameListView->ensureItemVisible(curItem);
		gameListView->setSelected(curItem,TRUE);
		emit signalChangeFavorite(curItem->mRom->favourite);
	} else {
		if(globalIsMess) 	kxmame_replace(gui_prefs.currentMess, NULL)
		else 			kxmame_replace(gui_prefs.currentMame, NULL);
	}

	parentList.clear();
	
	gameListView->setUpdatesEnabled(wasUpdateEnabled);
	gameListView->triggerUpdate();
	
	emit signalChangeStatusbar(curItem?curItem->mRom:NULL);
}

void kxmameView::slotGameListDoubleClicked()
{
	/* In mess mode, we are going to play Bios only*/
	if(globalIsMess) mMessRomSelector->dir->setCurrentItem(QString());/* deselect mMessRomSelector */
	playGame();
}

void kxmameView::playGame()
{
	if(gameListView->currentItem()) {
		if(!globalIsMess)
			mScreenTab->removeVideo();
		mParent->hide();
		play_game(((ColorListViewItem *)gameListView->currentItem())->mRom);
		mParent->show();
		if(!globalIsMess) {
			mScreenTab->initVideo();
			mScreenTab->updateScreenTab();
		}
	} else {
		gxmame_message( ERROR, NULL, i18n("Please select a game"));
	}
}

void kxmameView::playGameAlternative()
{
	if (!globalIsMess) return;

#ifdef ENABLE_JOYSTICK
	joystick_close( joydata);
	joydata = NULL;
#endif
	
	if(gameListView->currentItem()) {
		mParent->hide();
		RomEntry *rom =((ColorListViewItem *)gameListView->currentItem())->mRom;
		if(!(rom->external_command))
			gxmame_message( ERROR, NULL, 
				i18n("No alternative emulator defined for the system \"%1\"").
					arg(gameListView->currentItem()->text(0)));
		else {
			//QStringList args=QStringList::split(QRegExp("\\s"),rom->external_command);
			///* Check if executable exists */
			//QString mExec = KStandardDirs::findExe(args[0]);
			//if(mExec.isEmpty()) {
			//	gxmame_message( ERROR, NULL, 
			//		i18n("Could not find alternative executable %1").
			//		arg(args[0]));
			//	mParent->show();
			//} else {
			//	KFileItem *selectedRom = NULL;
			//	if ( mainView->MessRomSelector()->dir->selectedItems() && 
			//		(!mainView->MessRomSelector()->dir->selectedItems()->isEmpty() ) ){
			//		selectedRom = mainView->MessRomSelector()->dir->selectedItems()->getFirst();
			//		if(selectedRom->isFile()) {
			//			KProcess *kproc = new KProcess;
			//			*kproc << mExec;
			//			for(uint i=1; i<args.size(); i++) {
			//				QString str = args[i];
			//				if(str.contains("%1"))
			//					str = str.arg(selectedRom->url().path());
			//				*kproc << str;
			//				//kdDebug() << str << "---" << endl;
			//			}
			//			kproc->start(KProcess::Block);
			//		}
			//	}
			//}
			KFileItem *selectedRom = NULL;
			if ( mainView->MessRomSelector()->dir->selectedItems() && 
				(!mainView->MessRomSelector()->dir->selectedItems()->isEmpty() ) ){
				selectedRom = mainView->MessRomSelector()->dir->selectedItems()->getFirst();
				if(selectedRom->isFile()) {
					KProcess *kproc = new KProcess;
					kproc->setUseShell(TRUE);
					QString str = QString(rom->external_command);
					if(!str.isEmpty()) {
						if(str.contains("%1"))
							str = str.arg(KProcess::quote(selectedRom->url().path()));
						*kproc << str;
						kproc->start(KProcess::Block);
					}
				}
			}
		}
		mParent->show();
	} else {
		gxmame_message( ERROR, NULL, i18n("Please select a game"));
	}
#ifdef ENABLE_JOYSTICK
	if (gui_prefs.gui_joy)
		joydata = joystick_new (gui_prefs.Joystick_in_GUI);
#endif	
}

void kxmameView::playRecordGame()
{
	if(gameListView->currentItem()) {
		joy_focus_off();
//		gchar *inputDirectory = g_build_filename (g_get_home_dir () , 
//				globalIsMess ? ".xmess":".xmame", "inp", NULL);
		QString recordfile = KFileDialog::getSaveFileName(globalIsMess?gui_prefs.messInputDirectory:gui_prefs.mameInputDirectory,
				"*.inp|INP file",
				this, i18n("Choose inp file to record") );
//		g_free(inputDirectory);
		if (recordfile != QString::null) {
			if (KIO::NetAccess::exists(recordfile, false, 0)) {
				if (KMessageBox::warningContinueCancel(0,
				    i18n("File %1 exists. Do you want to replace it?")
					.arg(recordfile), i18n("Save to File"), i18n("&Replace"))
					!= KMessageBox::Continue)
						return;
			}
			if(!globalIsMess)
				mScreenTab->removeVideo();
			mParent->hide();
			record_game(((ColorListViewItem *)gameListView->currentItem())->mRom, recordfile);
			mParent->show();	
			if(!globalIsMess) {
				mScreenTab->initVideo();
				mScreenTab->updateScreenTab();
			}
		}
	} else {
		gxmame_message( ERROR, NULL, i18n("Please select a game"));
	}
}

void kxmameView::playbackGame()
{
	if(gameListView->currentItem()) {
		joy_focus_off();
//		gchar *inputDirectory = g_build_filename (g_get_home_dir () , 
//				globalIsMess ? ".xmess":".xmame", "inp", NULL);
		QString file = KFileDialog::getOpenFileName(globalIsMess?gui_prefs.messInputDirectory:gui_prefs.mameInputDirectory,
				"*.inp|INP file",
				this, i18n("Choose inp file to play") );
//		g_free(inputDirectory);
		if (file != QString::null) {
			if(!globalIsMess)
				mScreenTab->removeVideo();
			mParent->hide();
			playback_game(((ColorListViewItem *)gameListView->currentItem())->mRom, file);
			mParent->show();
			if(!globalIsMess) {
				mScreenTab->initVideo();
				mScreenTab->updateScreenTab();
			}
		}
	} else {
		gxmame_message( ERROR, NULL, i18n("Please select a game"));
	}
}

void kxmameView::addFavorites()
{
	if(gameListView->currentItem()) {
		((ColorListViewItem *)gameListView->currentItem())->
				mRom->favourite = TRUE;
		emit signalChangeFavorite(TRUE);
	} else {
		gxmame_message( ERROR, NULL, i18n("Please select a game"));
	}
}

void kxmameView::removeFavorites()
{
	if(gameListView->currentItem()) {
		((ColorListViewItem *)gameListView->currentItem())->
				mRom->favourite = FALSE;
		emit signalChangeFavorite(FALSE);
	} else {
		gxmame_message( ERROR, NULL, i18n("Please select a game"));
	}
}

void kxmameView::setupGameIcons()
{
	iconlist.clear();

	if(game_list.num_games <=0)
		return;

	if( (gui_prefs.iconSize == 0)|| globalIsMess) {
		iconlist.resize(game_list.num_games);
		return;
	}
	
	ZIP *zip;
	gchar *zipfile;
	KProgressDialog *dlg = NULL;
	
	/* open the zip file only at the begining */
	zipfile = g_build_filename (gui_prefs.IconDirectory, "icons.zip", NULL);
	zip = openzip (zipfile);
	
	if (!mSplashScreen) {
		// We're going to load every icons. This may require a lot of memory.
		dlg = new KProgressDialog(0,0,0,i18n("Loading game icons..."));
		dlg->showCancelButton ( FALSE );
		dlg->show();
	} else
		mSplashScreen->setMessage(i18n("Loading game icons..."));

	kapp->processEvents();

	uint index = 0;
	GList *listpointer;
	RomEntry *tmprom;
	for (listpointer = g_list_first (game_list.roms);
		(listpointer);
		listpointer= g_list_next (listpointer)) {
			tmprom = (RomEntry *) listpointer->data;
			iconlist.append(get_icon_for_rom(tmprom, gui_prefs.iconSize, zip));
			if(!(index % 500)) {
				int val = (int)(100.0*(float)index/(float)game_list.num_games);
				if(!mSplashScreen)
					dlg->progressBar()->setValue(val);
				else
					mSplashScreen->setMessage(i18n("Loading game icons...")+" "+
						QString::number(val)+'%');
				kapp->processEvents();
			}
			index++;
		}
		
	if(!mSplashScreen)	dlg->progressBar()->setValue(100);
	else		mSplashScreen->setMessage(i18n("Loading game icons...")+" 100%");
	kapp->processEvents();
	
	if(!mSplashScreen)	delete dlg;
	if (zip)	closezip (zip);
	g_free (zipfile);
}

/* get an icon for a rom, if not found, try the original game if the game is a clone */
QPixmap kxmameView::get_icon_for_rom (RomEntry *rom, guint size, ZIP *zip)
{
	QImage pixbuf = QImage();
	gchar filename [MAX_ROMNAME + 1], *filename2;
	gchar parent_filename [MAX_ROMNAME + 1];

	if (!rom)
		return QPixmap();

	filename2 = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.ico", gui_prefs.IconDirectory, rom->romname);
	pixbuf.load(filename2);
	g_free (filename2);

	/* no picture found try parent game if any*/
	if ((pixbuf.isNull()) && strcmp (rom->cloneof, "-")) {
		filename2 = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "%s.ico", gui_prefs.IconDirectory, rom->cloneof);
		pixbuf.load(filename2);
		g_free (filename2);
	}

	/* we havent found the picture in the directory, maybe we could try in a zipfile */
	if (pixbuf.isNull()) {
		struct zipent * zipent;
		char *tmp_buffer;
		char *parent_tmp_buffer = NULL;
		gsize parent_buf_size = 0;
		if (zip != 0) {
			rewindzip (zip);
			g_snprintf (filename, MAX_ROMNAME + 1 , "%s.", rom->romname);
			g_snprintf (parent_filename, MAX_ROMNAME + 1, "%s.", rom->cloneof);
					
			while ( (zipent = readzip (zip)) != 0) {
				/* this should allows to find any format of picture in the zip, not only bmp */
				if (!strncmp (filename, zipent->name, strlen (rom->romname) + 1)) {
					tmp_buffer = read_zipentry (zip, zipent);
					if (tmp_buffer) {
						/* if the file successfully uncompress, try to load it in a pixbuf loader */
						pixbuf.loadFromData ( (guchar *)tmp_buffer, zipent->uncompressed_size,0);
						if (pixbuf.isNull()) {
							GXMAME_DEBUG ("Error while uncompressing %s ", zipent->name);
						}
						g_free (tmp_buffer);
						tmp_buffer = NULL;
					}
					/* prevent to read all zip file if we have found the picture's game (uncompressed successfuly or not) */
					break;
				} else if (strcmp (rom->cloneof, "-") && !strncmp (parent_filename, zipent->name, strlen (rom->cloneof) + 1)) {
					parent_tmp_buffer = read_zipentry (zip, zipent);
					parent_buf_size = zipent->uncompressed_size;
				}
			}
			/* no picture found try parent game if any */
			if (pixbuf.isNull()) {
				if (parent_tmp_buffer) {
					pixbuf.loadFromData ((guchar *)parent_tmp_buffer, parent_buf_size,0);
					if (pixbuf.isNull()) {
						GXMAME_DEBUG ("Error while uncompressing %s ",zipent->name);
					}
				}
			}
			if (parent_tmp_buffer)
				g_free (parent_tmp_buffer);
		}
	}
	
	if(pixbuf.isNull()) {
		return QPixmap();
	}
	
	QPixmap mPix;
	mPix.convertFromImage(pixbuf.scale(size, size, QImage::ScaleMin));
	
	return mPix;
}

void kxmameView::toggleSearch()
{
	showSearch = !showSearch;
	if (showSearch)	searchToolBar->show();
	else		searchToolBar->hide();
}

RomEntry *kxmameView::currentRom()
{
	RomEntry *rom = NULL;
	if(gameListView->currentItem()) {
		rom = static_cast<ColorListViewItem*>(gameListView->currentItem())->mRom;
	}
	return rom;
}

#include "kxmameview.moc"
