/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

/*
 * Created on Jul 24, 2005
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.jboss.test.remoting.transport.multiplex.performance;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import org.apache.log4j.Level;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

import junit.framework.TestCase;

/**
 * <p/>
 * Copyright (c) 2005
 * <p/>
 *
 * @author <a href="mailto:r.sigal@computer.org">Ron Sigal</a>
 */
public class SimpleClientTest extends TestCase
{
   private static final Logger log = Logger.getLogger(SimpleClientTest.class);

   private Socket socket1 = null;
   private Socket socket2 = null;

   private ObjectOutputStream oos1 = null;
   private ObjectInputStream ois1 = null;
   private ObjectOutputStream oos2 = null;
   private ObjectInputStream ois2 = null;


   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);

      new SimpleClientTest().testClient();
   }


   public void testClient()
   {
      log.info("Starting client test");

      try
      {
         socket1 = new VirtualSocket("127.0.0.1", 1999);
         oos1 = new ObjectOutputStream(socket1.getOutputStream());
         ois1 = new ObjectInputStream(socket1.getInputStream());

         socket2 = new VirtualSocket("127.0.0.1", 1999);
         oos2 = new ObjectOutputStream(socket2.getOutputStream());
         ois2 = new ObjectInputStream(socket2.getInputStream());
      }
      catch(UnknownHostException e)
      {
         log.error("UnknownHostException for \"localhost\"");
         e.printStackTrace();
      }
      catch(IOException e)
      {
         log.error("i/o exception creating VirtualSocket");
         e.printStackTrace();
      }

      Thread thread1 = new Thread(new Runnable()
      {
         public void run()
         {
            try
            {
               int x = new Random().nextInt(100);
               log.info("x = " + x);

               for(int j = 0; j < 1000; j++)
               {
                  System.out.println("thread 1: writing out value " + x);
                  log.debug("thread 1: writing out value " + x);
                  oos1.writeObject(new Integer(x));
                  oos1.flush();

                  Integer i = (Integer) ois1.readObject();
                  System.out.println((x + 100) + " - " + i.intValue() + " are equal?  " + (((x + 100) == i.intValue()) ? "true" : "FALSE"));
                  log.debug("thread 1: " + (x + 100) + " - " + i.intValue() + " are equal?  " + (((x + 100) == i.intValue()) ? "true" : "FALSE"));
                  assertEquals(x + 100, i.intValue());
                  x++;
               }

               socket1.close();
            }
            catch(IOException e)
            {
               e.printStackTrace();
            }
            catch(ClassNotFoundException e)
            {
               e.printStackTrace();
            }

         }
      });

      thread1.start();

      Thread thread2 = new Thread(new Runnable()
      {
         public void run()
         {
            try
            {
               int x = new Random().nextInt(100);
               log.info("x = " + x);

               for(int j = 0; j < 1000; j++)
               {
                  System.out.println("                                        thread 2: writing out value " + x);
                  log.debug("thread 2: writing out value " + x);
                  oos2.writeObject(new Integer(x));
                  oos2.flush();

                  Integer i = (Integer) ois2.readObject();
                  System.out.println("                                        thread 2: "
                                     + (x + 100) + " - " + i.intValue() + " are equal?  " + (((x + 100) == i.intValue()) ? "true" : "FALSE"));
                  log.debug((x + 100) + " - " + i.intValue() + " are equal?  " + (((x + 100) == i.intValue()) ? "true" : "FALSE"));
                  assertEquals(x + 100, i.intValue());
                  x++;
               }

               socket2.close();
            }
            catch(IOException e)
            {
               e.printStackTrace();
            }
            catch(ClassNotFoundException e)
            {
               e.printStackTrace();
            }

         }
      });

      thread2.start();

      try
      {
         thread1.join();
         thread2.join();
         socket1.close();
         socket2.close();
      }
      catch(IOException ignore)
      {
         log.error("i/o exception closing socket");
      }
      catch(InterruptedException e)
      {
         e.printStackTrace();
      }

      log.info("Ending client test (main thread)");
   }


}
