/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*-
 *
 * nautilus-burn-drive.c: easy to use cd burner software
 *
 * Copyright (C) 2002-2004 Red Hat, Inc.
 * Copyright (C) 2005 William Jon McCann <mccann@jhu.edu>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * Authors: Alexander Larsson <alexl@redhat.com>
 *          Bastien Nocera <hadess@hadess.net>
 *          William Jon McCann <mccann@jhu.edu>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef __FreeBSD__

#include <glib.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <camlib.h>

#include "nautilus-burn-drive-common.h"

GList *
freebsd_scan (gboolean recorder_only)
{
  GList *drives_list = NULL;
  const char *dev_type = "cd";
  int speed = 16;       /* XXX Hardcode the write speed for now. */
  int i = 0;
  int cnode = 1;                /* Use the CD device's 'c' node. */

  while (1)
  {
    NautilusBurnDrive *drive;
    char *cam_path;
    struct cam_device *cam_dev;

    cam_path = g_strdup_printf ("/dev/%s%dc", dev_type, i);

    if (!g_file_test (cam_path, G_FILE_TEST_EXISTS))
    {
      g_free (cam_path);
      cam_path = g_strdup_printf ("/dev/%s%d", dev_type, i);
      cnode = 0;
      if (!g_file_test (cam_path, G_FILE_TEST_EXISTS))
      {
        g_free (cam_path);
        break;
      }
    }

    if ((cam_dev = cam_open_spec_device (dev_type, i, O_RDWR, NULL)) == NULL)
    {
      i++;
      g_free (cam_path);
      continue;
    }

    drive = nautilus_burn_drive_new ();
    drive->display_name = g_strdup_printf ("%s %s", cam_dev->inq_data.vendor, cam_dev->inq_data.revision);
    drive->device = g_strdup (cam_path);
    drive->cdrecord_id = g_strdup_printf ("%d,%d,%d", cam_dev->path_id, cam_dev->target_id, cam_dev->target_lun);
    /*
     * Attempt to get more specific information from
     * * this drive by using cdrecord.
     */
    nautilus_burn_drive_get_cd_properties (drive);
    if (drive->type & NAUTILUS_BURN_DRIVE_TYPE_CD_RECORDER || drive->type & NAUTILUS_BURN_DRIVE_TYPE_CDRW_RECORDER
        || drive->type & NAUTILUS_BURN_DRIVE_TYPE_DVD_RAM_RECORDER || drive->type & NAUTILUS_BURN_DRIVE_TYPE_DVD_RW_RECORDER
        || !recorder_only)
    {
      if (drive->max_speed_read == -1)
        drive->max_speed_read = speed;
      if (drive->max_speed_write == -1)
        drive->max_speed_write = speed;

      if (drive->type & NAUTILUS_BURN_DRIVE_TYPE_DVD_DRIVE)
        nautilus_burn_drive_add_dvd_plus (drive);

      drives_list = g_list_append (drives_list, drive);
    }
    else
      g_object_unref (drive);

    g_free (cam_path);
    free (cam_dev);

    i++;
  }

  return drives_list;
}

#endif /* __FreeBSD__ */

