/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_SRT_H__
#define __OGMRIP_SRT_H__

#include <ogmrip-subp.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_SRT          (ogmrip_srt_get_type ())
#define OGMRIP_SRT(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_SRT, OGMRipSrt))
#define OGMRIP_SRT_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_SRT, OGMRipSrtClass))
#define OGMRIP_IS_SRT(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_SRT))
#define OGMRIP_IS_SRT_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_SRT))

typedef struct _OGMRipSrt      OGMRipSrt;
typedef struct _OGMRipSrtPriv  OGMRipSrtPriv;
typedef struct _OGMRipSrtClass OGMRipSrtClass;

struct _OGMRipSrt
{
  OGMRipSubp parent_instance;

  OGMRipSrtPriv *priv;
};

struct _OGMRipSrtClass
{
  OGMRipSubpClass parent_class;
};

GType         ogmrip_srt_get_type  (void);
OGMJobSpawn * ogmrip_srt_new       (OGMDvdSubpStream *subp,
                                    const gchar      *output);

G_END_DECLS

#endif /* __OGMRIP_SRT_H__ */

