/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_XVID_H__
#define __OGMRIP_XVID_H__

#include <ogmrip-video.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_XVID          (ogmrip_xvid_get_type ())
#define OGMRIP_XVID(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_XVID, OGMRipXvid))
#define OGMRIP_XVID_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_XVID, OGMRipXvidClass))
#define OGMRIP_IS_XVID(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_XVID))
#define OGMRIP_IS_XVID_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_XVID))

typedef struct _OGMRipXvid      OGMRipXvid;
typedef struct _OGMRipXvidPriv  OGMRipXvidPriv;
typedef struct _OGMRipXvidClass OGMRipXvidClass;

struct _OGMRipXvid
{
  OGMRipVideo parent_instance;

  OGMRipXvidPriv *priv;
};

struct _OGMRipXvidClass
{
  OGMRipVideoClass parent_class;
};

GType         ogmrip_xvid_get_type   (void);
OGMJobSpawn * ogmrip_xvid_new        (OGMDvdTitle *title,
                                      const gchar *output);
void          ogmrip_xvid_set_gmc    (OGMRipXvid  *xvid,
                                      gboolean    gmc);
gboolean      ogmrip_xvid_get_gmc    (OGMRipXvid  *xvid);

G_END_DECLS

#endif /* __OGMRIP_XVID_H__ */

