/* OGMRip - A DVD Encoder for GNOME
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "ogmrip-gconf.h"
#include "ogmrip-helper.h"
#include "ogmrip-preferences.h"
#include "ogmrip-plugin.h"

#include <string.h>

typedef struct
{
  gchar *name;
  gint index;
  gint count;
} OGMRipGConfCounter;

static gint
ogmrip_gconf_compare_by_name (GType type, const gchar *name, const gchar *description, const gchar *str)
{
  return strcmp (name, str);
}

static gint
ogmrip_gconf_count (GType type, const gchar *name, const gchar *description, OGMRipGConfCounter *counter)
{
  gint cmp;

  cmp = strcmp (name, counter->name);
  if (cmp)
    counter->count ++;

  return cmp;
}

GType
ogmrip_gconf_get_container_type (const gchar *name)
{
  GType container;
  gchar *str;

  if (name)
    str = g_strdup (name);
  else
    str = ogmrip_preferences_get_string (OGMRIP_GCONF_CONTAINER, OGMRIP_DEFAULT_CONTAINER);
  container = ogmrip_plugin_find_container ((OGMRipPluginCmpFunc) ogmrip_gconf_compare_by_name, str);
  g_free (str);

  return container;
}

gint
ogmrip_gconf_get_container_index (const gchar *name)
{
  OGMRipGConfCounter counter;
  GType container;

  if (name)
    counter.name = g_strdup (name);
  else
    counter.name = ogmrip_preferences_get_string (OGMRIP_GCONF_CONTAINER, OGMRIP_DEFAULT_CONTAINER);
  counter.count = 0;
  counter.index = 0;

  container = ogmrip_plugin_find_container ((OGMRipPluginCmpFunc) ogmrip_gconf_count, &counter);

  g_free (counter.name);

  return container == G_TYPE_NONE ? -1 : counter.count;
}

GType
ogmrip_gconf_get_video_codec_type (const gchar *name)
{
  GType codec;
  gchar *str;

  if (name)
    str = g_strdup (name);
  else
    str = ogmrip_preferences_get_string (OGMRIP_GCONF_VIDEO_CODEC, OGMRIP_DEFAULT_VIDEO_CODEC);
  codec = ogmrip_plugin_find_video_codec ((OGMRipPluginCmpFunc) ogmrip_gconf_compare_by_name, str);
  g_free (str);

  return codec;
}

gint
ogmrip_gconf_get_video_codec_index (const gchar *name)
{
  OGMRipGConfCounter counter;
  GType codec;

  if (name)
    counter.name = g_strdup (name);
  else
    counter.name = ogmrip_preferences_get_string (OGMRIP_GCONF_VIDEO_CODEC, OGMRIP_DEFAULT_VIDEO_CODEC);
  counter.count = 0;

  codec = ogmrip_plugin_find_video_codec ((OGMRipPluginCmpFunc) ogmrip_gconf_count, &counter);

  g_free (counter.name);

  return codec == G_TYPE_NONE ? -1 : counter.count;
}

GType
ogmrip_gconf_get_audio_codec_type (const gchar *name)
{
  GType codec;
  gchar *str;

  if (name)
    str = g_strdup (name);
  else
    str = ogmrip_preferences_get_string (OGMRIP_GCONF_AUDIO_CODEC, OGMRIP_DEFAULT_AUDIO_CODEC);
  codec = ogmrip_plugin_find_audio_codec ((OGMRipPluginCmpFunc) ogmrip_gconf_compare_by_name, str);
  g_free (str);

  return codec;
}

gint
ogmrip_gconf_get_audio_codec_index (const gchar *name)
{
  OGMRipGConfCounter counter;
  GType codec;

  if (name)
    counter.name = g_strdup (name);
  else
    counter.name = ogmrip_preferences_get_string (OGMRIP_GCONF_AUDIO_CODEC, OGMRIP_DEFAULT_AUDIO_CODEC);
  counter.count = 0;

  codec = ogmrip_plugin_find_audio_codec ((OGMRipPluginCmpFunc) ogmrip_gconf_count, &counter);

  g_free (counter.name);

  return codec == G_TYPE_NONE ? -1 : counter.count;
}

GType
ogmrip_gconf_get_subp_codec_type (const gchar *name)
{
  GType codec;
  gchar *str;

  if (name)
    str = g_strdup (name);
  else
    str = ogmrip_preferences_get_string (OGMRIP_GCONF_SUBP_CODEC, OGMRIP_DEFAULT_SUBP_CODEC);
  codec = ogmrip_plugin_find_subp_codec ((OGMRipPluginCmpFunc) ogmrip_gconf_compare_by_name, str);
  g_free (str);

  return codec;
}

gint
ogmrip_gconf_get_subp_codec_index (const gchar *name)
{
  OGMRipGConfCounter counter;
  GType codec;

  if (name)
    counter.name = g_strdup (name);
  else
    counter.name = ogmrip_preferences_get_string (OGMRIP_GCONF_SUBP_CODEC, OGMRIP_DEFAULT_SUBP_CODEC);
  counter.count = 0;

  codec = ogmrip_plugin_find_subp_codec ((OGMRipPluginCmpFunc) ogmrip_gconf_count, &counter);

  g_free (counter.name);

  return codec == G_TYPE_NONE ? -1 : counter.count;
}

