/****************************************************************************
** Form interface for 'dialogfilter.ui'
**
** Created: Fri Apr 9 22:06:50 2004
**      by: Varol Okan using the kate text editor.
**
**
****************************************************************************/

#ifndef SOURCEFILEDIALOG_H
#define SOURCEFILEDIALOG_H

#include "uisourcefiledialog.h"
#include <qvaluelist.h>

// define the tab-position
#define MOVIE_SELECTION_TAB 0
#define SOUND_OPTIONS_TAB   1
#define SOURCE_FILE_TAB     2
#define MOVIE_OPTIONS_TAB   3

class MediaInterface;
class SourceFileEntry;

class SourceFileDialog : public uiSourceFileDialog
{
    Q_OBJECT

public:
	// Constructor / destructor.
	 SourceFileDialog (void *, QWidget* parent = 0, int iTab = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
	 SourceFileDialog (QWidget* parent = 0, int iTab = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
	~SourceFileDialog ();

	void setFileTypes (QStringList);

	void setProjectDir   (QString);
	void setTempDir      (QString);
	void setDocumentsDir (QString);
	void setDesktopDir   (QString);
	void setCurrentDir   (QString);
	void setCurrentDir   ();

	QString getFileName   ();
	// The public members for the Source File Edit tab ...
	void setCurrentSourceFileEntry(SourceFileEntry *);
	void setSourceFileEntries(QValueList<SourceFileEntry *>&, int i=0);

protected:
	void    initMe (int, void *p=NULL);
	void    setQuickDir (int);
	void    addDirectoryHistory (QString);
	void    initDirectoryHistory();
	QString getFileTypes   ();
	QString getPermissions (QString);
	bool    findDesktopDir (QString);
	void    drawStartStopMarker (int, int);
	void    colorMovieButtons (void *);
	virtual void paintEvent (QPaintEvent *);
	QString getAttribute (QString, QString);
	QString formatChapter (QString);
	void    setChapters (uint);
	int     getCurrentSourceItem ();
	void    setCurrentSourceItem (int);

signals:
	void signalFForward ();
	void signalForward ();
	void signalBackward ();
	void signalFBackward ();
	void signalStop ();
	void signalSeek (float);

protected slots:
	virtual void accept ();
	virtual void slotQuickDir ();
	virtual void slotDirectoryBack ();
	virtual void slotDirectoryUp   ();
	virtual void slotDirectoryNew  ();
	virtual void slotFilterChanged (int);
	virtual void slotDirectoryHistoryChanged (const QString &);
	virtual void slotFileNameChanged();
	virtual void slotSourceNameChanged ();
	virtual void slotListViewPressed(QListViewItem *, const QPoint &, int);
	virtual void slotListViewDoubleClicked(QListViewItem *); //, const QPoint &, int);
	virtual void slotFBackward ();
	virtual void slotBackward ();
	virtual void slotStop ();
	virtual void slotForward ();
	virtual void slotFForward ();
	virtual void slotSetAsStart ();
	virtual void slotSetAsEnd ();
	virtual void slotNewFrameNumber ();
	virtual void slotSliderValueChanged (int);

	// The slots for the Source File Edit tab ...
	virtual void slotSourceSelectionChanged (QListViewItem *);
	virtual void slotSourceChaptersSelectionChanged ();
	virtual void slotSourceImportChapter();
	virtual void slotSourceEditChapter  ();
	virtual void slotSourceDeleteChapter();
	virtual void slotSourceAdd ();
	virtual void slotSourceSave();
	virtual void slotSourceDel ();
	virtual void slotSourceUp  ();
	virtual void slotSourceDown();

protected:
	QString m_qsProjectDir;
	QString m_qsHomeDir;
	QString m_qsRootDir;
	QString m_qsDocumentsDir;
	QString m_qsDesktopDir;
	QString m_qsTempDir;
	// A reference to the latest pressed QuickDir - button.
	QPushButton *m_pActiveQuickButton;
	int m_iHistoryMax;
	QStringList m_listFileType;
	QString m_qsManualFilter;
	QGridLayout *m_pVideoLayout;

	SourceFileEntry *m_pCurrentSourceFileEntry;
	SourceFileEntry *m_pOriginalSourceFileEntry;
	// The main XinePreview - class
	MediaInterface *m_pMediaInterface;
};

#endif // SOURCEFILEDIALOG_H
