/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.ui.internal.contentassist.NoRegionContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.provisional.StructuredTextViewerConfigurationXML;
import org.springframework.ide.eclipse.beans.ui.editor.BeansEditorPlugin;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.BeansContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.hover.BeansTextHoverProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.BeansHyperLinkDetector;

public class BeansStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationXML {
    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IContentAssistant ca = super.getContentAssistant(sourceViewer);
        if (ca != null && ca instanceof ContentAssistant) {
            ContentAssistant contentAssistant = (ContentAssistant)ca;
            contentAssistant.enableAutoActivation(true);
            contentAssistant.enableAutoInsert(true);
            contentAssistant.setAutoActivationDelay(0);
            contentAssistant.setProposalSelectorBackground(new Color((Device)BeansEditorPlugin.getActiveWorkbenchShell().getDisplay(), new RGB(255, 255, 255)));
            contentAssistant.setRestoreCompletionProposalSize(BeansEditorPlugin.getDefault().getDialogSettings());
            BeansContentAssistProcessor caProcessor = new BeansContentAssistProcessor(this.getEditorPart());
            this.setContentAssistProcessor(contentAssistant, (IContentAssistProcessor)caProcessor, "org.eclipse.wst.sse.ST_DEFAULT");
            this.setContentAssistProcessor(contentAssistant, (IContentAssistProcessor)caProcessor, "org.eclipse.wst.xml.XML_DEFAULT");
            NoRegionContentAssistProcessor noRegionProcessor = new NoRegionContentAssistProcessor();
            this.setContentAssistProcessor(contentAssistant, (IContentAssistProcessor)noRegionProcessor, "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE");
        }
        return ca;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        ArrayList<IHyperlinkDetector> allDetectors = new ArrayList<IHyperlinkDetector>(0);
        allDetectors.add(new BeansHyperLinkDetector(this.getEditorPart()));
        IHyperlinkDetector[] superDetectors = super.getHyperlinkDetectors(sourceViewer);
        int m = 0;
        while (m < superDetectors.length) {
            IHyperlinkDetector detector = superDetectors[m];
            if (!allDetectors.contains(detector)) {
                allDetectors.add(detector);
            }
            ++m;
        }
        return allDetectors.toArray(new IHyperlinkDetector[0]);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if (contentType == "org.eclipse.wst.sse.ST_DEFAULT" || contentType == "org.eclipse.wst.xml.XML_DEFAULT") {
            TextHoverManager.TextHoverDescriptor[] hoverDescs = this.getTextHovers();
            int i = 0;
            while (i < hoverDescs.length) {
                String hoverType;
                if (hoverDescs[i].isEnabled() && EditorUtility.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask && "combinationHover".equalsIgnoreCase(hoverType = hoverDescs[i].getId())) {
                    return new BeansTextHoverProcessor(this.editorPart);
                }
                ++i;
            }
        }
        return super.getTextHover(sourceViewer, contentType, stateMask);
    }
}

