/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;

public class BeansUIImages {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.beans.ui.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.beans.ui.".length();
    private static URL ICON_BASE_URL = null;
    private static Map imageDescriptors;
    private static ImageRegistry imageRegistry;
    public static final String IMG_OBJS_PROJECT = "org.springframework.ide.eclipse.beans.ui.project_obj.gif";
    public static final String IMG_OBJS_CONFIG = "org.springframework.ide.eclipse.beans.ui.config_obj.gif";
    public static final String IMG_OBJS_CONFIG_SET = "org.springframework.ide.eclipse.beans.ui.configset_obj.gif";
    public static final String IMG_OBJS_ROOT_BEAN = "org.springframework.ide.eclipse.beans.ui.rootbean_obj.gif";
    public static final String IMG_OBJS_CHILD_BEAN = "org.springframework.ide.eclipse.beans.ui.childbean_obj.gif";
    public static final String IMG_OBJS_CONSTRUCTOR = "org.springframework.ide.eclipse.beans.ui.constructor_obj.gif";
    public static final String IMG_OBJS_PROPERTY = "org.springframework.ide.eclipse.beans.ui.property_obj.gif";
    public static final String IMG_OBJS_SPRING = "org.springframework.ide.eclipse.beans.ui.spring_obj.gif";
    public static final String IMG_OBJS_ERROR = "org.springframework.ide.eclipse.beans.ui.error_obj.gif";
    private static final String OBJECT = "obj16/";
    private static final String OVR = "ovr16/";
    public static final ImageDescriptor DESC_OBJS_PROJECT;
    public static final ImageDescriptor DESC_OBJS_CONFIG;
    public static final ImageDescriptor DESC_OBJS_CONFIG_SET;
    public static final ImageDescriptor DESC_OBJS_ROOT_BEAN;
    public static final ImageDescriptor DESC_OBJS_CHILD_BEAN;
    public static final ImageDescriptor DESC_OBJS_CONSTRUCTOR;
    public static final ImageDescriptor DESC_OBJS_PROPERTY;
    public static final ImageDescriptor DESC_OBJS_SPRING;
    public static final ImageDescriptor DESC_OBJS_ERROR;
    public static final ImageDescriptor DESC_OVR_SPRING;
    public static final ImageDescriptor DESC_OVR_ERROR;
    public static final ImageDescriptor DESC_OVR_WARNING;
    public static final ImageDescriptor DESC_OVR_PROTOTYPE;
    public static final ImageDescriptor DESC_OVR_EXTERNAL;
    public static final ImageDescriptor DESC_OVR_ABSTRACT;
    public static final ImageDescriptor DESC_OVR_NO_CLASS;

    static {
        try {
            ICON_BASE_URL = new URL(BeansUIPlugin.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException e) {
            BeansUIPlugin.log(e);
        }
        DESC_OBJS_PROJECT = BeansUIImages.createManaged(OBJECT, IMG_OBJS_PROJECT);
        DESC_OBJS_CONFIG = BeansUIImages.createManaged(OBJECT, IMG_OBJS_CONFIG);
        DESC_OBJS_CONFIG_SET = BeansUIImages.createManaged(OBJECT, IMG_OBJS_CONFIG_SET);
        DESC_OBJS_ROOT_BEAN = BeansUIImages.createManaged(OBJECT, IMG_OBJS_ROOT_BEAN);
        DESC_OBJS_CHILD_BEAN = BeansUIImages.createManaged(OBJECT, IMG_OBJS_CHILD_BEAN);
        DESC_OBJS_CONSTRUCTOR = BeansUIImages.createManaged(OBJECT, IMG_OBJS_CONSTRUCTOR);
        DESC_OBJS_PROPERTY = BeansUIImages.createManaged(OBJECT, IMG_OBJS_PROPERTY);
        DESC_OBJS_SPRING = BeansUIImages.createManaged(OBJECT, IMG_OBJS_SPRING);
        DESC_OBJS_ERROR = BeansUIImages.createManaged(OBJECT, IMG_OBJS_ERROR);
        DESC_OVR_SPRING = BeansUIImages.create(OVR, "spring_ovr.gif");
        DESC_OVR_ERROR = BeansUIImages.create(OVR, "error_ovr.gif");
        DESC_OVR_WARNING = BeansUIImages.create(OVR, "warning_ovr.gif");
        DESC_OVR_PROTOTYPE = BeansUIImages.create(OVR, "prototype_ovr.gif");
        DESC_OVR_EXTERNAL = BeansUIImages.create(OVR, "external_ovr.gif");
        DESC_OVR_ABSTRACT = BeansUIImages.create(OVR, "abstract_ovr.gif");
        DESC_OVR_NO_CLASS = BeansUIImages.create(OVR, "no_class_ovr.gif");
    }

    public static Image getImage(String key) {
        return BeansUIImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        BeansUIImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        BeansUIImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            Iterator iter = imageDescriptors.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                imageRegistry.put(key, (ImageDescriptor)imageDescriptors.get(key));
            }
            imageDescriptors = null;
        }
        return imageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)BeansUIImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            BeansUIPlugin.log(e);
        }
        action.setImageDescriptor(BeansUIImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)BeansUIImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap();
            }
            imageDescriptors.put(name, result);
            if (imageRegistry != null) {
                BeansUIPlugin.log("Image registry already defined", null);
            }
            return result;
        }
        catch (MalformedURLException e) {
            BeansUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)BeansUIImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            BeansUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

