/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;

public class FileFilter
extends ViewerFilter {
    private String[] allowedFileExtensions;

    public FileFilter(String[] allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions;
    }

    public FileFilter() {
        this.allowedFileExtensions = null;
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            return this.hasAllowedFileExtension((IFile)element);
        }
        if (element instanceof IContainer) {
            try {
                IResource[] resources = ((IContainer)element).members();
                int i = 0;
                while (i < resources.length) {
                    if (this.select(viewer, parent, resources[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                BeansUIPlugin.log(e.getStatus());
            }
        }
        return false;
    }

    private boolean hasAllowedFileExtension(IFile file) {
        if (this.allowedFileExtensions == null) {
            return true;
        }
        String extension = file.getFileExtension();
        if (extension != null) {
            int i = 0;
            while (i < this.allowedFileExtensions.length) {
                if (extension.equalsIgnoreCase(this.allowedFileExtensions[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

