/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.springframework.ide.eclipse.core.SpringCore;

public class SpringCoreUtils {
    public static void addProjectNature(IProject project, String nature) {
        if (project != null && nature != null) {
            try {
                if (!project.hasNature(nature)) {
                    IProjectDescription desc = project.getDescription();
                    String[] oldNatures = desc.getNatureIds();
                    String[] newNatures = new String[oldNatures.length + 1];
                    newNatures[0] = nature;
                    if (oldNatures.length > 0) {
                        System.arraycopy(oldNatures, 0, newNatures, 1, oldNatures.length);
                    }
                    desc.setNatureIds(newNatures);
                    project.setDescription(desc, null);
                }
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
    }

    public static void removeProjectNature(IProject project, String nature) {
        if (project != null && nature != null) {
            try {
                if (project.exists() && project.hasNature(nature)) {
                    if (nature.equals("org.springframework.ide.eclipse.core.springnature")) {
                        project.deleteMarkers("org.springframework.ide.eclipse.core.problemmarker", true, 2);
                    }
                    IProjectDescription desc = project.getDescription();
                    String[] oldNatures = desc.getNatureIds();
                    String[] newNatures = new String[oldNatures.length - 1];
                    int newIndex = oldNatures.length - 2;
                    int i = oldNatures.length - 1;
                    while (i >= 0) {
                        if (!oldNatures[i].equals(nature)) {
                            newNatures[newIndex--] = oldNatures[i];
                        }
                        --i;
                    }
                    desc.setNatureIds(newNatures);
                    project.setDescription(desc, null);
                }
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
    }

    public static void removeProjectBuilder(IProject project, String builder) {
        if (project != null && builder != null) {
            try {
                IProjectDescription desc = project.getDescription();
                ICommand[] commands = desc.getBuildSpec();
                int i = commands.length - 1;
                while (i >= 0) {
                    if (commands[i].getBuilderName().equals(builder)) {
                        ICommand[] newCommands = new ICommand[commands.length - 1];
                        System.arraycopy(commands, 0, newCommands, 0, i);
                        System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                        desc.setBuildSpec(newCommands);
                        project.setDescription(desc, null);
                        break;
                    }
                    --i;
                }
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
    }

    public static boolean isJavaProject(IResource resource) {
        if (resource instanceof IProject && resource.isAccessible()) {
            try {
                return ((IProject)resource).hasNature("org.eclipse.jdt.core.javanature");
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
        return false;
    }

    public static boolean isSpringProject(IResource resource) {
        if (resource instanceof IProject && resource.isAccessible()) {
            try {
                return ((IProject)resource).hasNature("org.springframework.ide.eclipse.core.springnature");
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
        return false;
    }

    public static void deleteProblemMarkers(IResource resource) {
        if (resource != null && resource.isAccessible()) {
            try {
                resource.deleteMarkers("org.springframework.ide.eclipse.core.problemmarker", false, 0);
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
    }
}

