/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;

public class XMLWriter
extends PrintWriter {
    public static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    protected int tab = 0;

    public XMLWriter(OutputStream output) throws UnsupportedEncodingException {
        super(new OutputStreamWriter(output, "UTF8"));
        this.println(XML_VERSION);
    }

    public void endTag(String name) {
        --this.tab;
        this.printTag(String.valueOf('/') + name, null);
    }

    public void printSimpleTag(String name, Object value) {
        if (value != null) {
            this.printTag(name, null, true, false);
            this.print(XMLWriter.getEscaped(String.valueOf(value)));
            this.printTag(String.valueOf('/') + name, null, false, true);
        }
    }

    public void printTabulation() {
        int i = 0;
        while (i < this.tab) {
            super.print('\t');
            ++i;
        }
    }

    public void printTag(String name, HashMap parameters) {
        this.printTag(name, parameters, true, true);
    }

    public void printTag(String name, HashMap parameters, boolean tab, boolean newLine) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(name);
        if (parameters != null) {
            Enumeration keys = Collections.enumeration(parameters.keySet());
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                buffer.append(" ");
                buffer.append(key);
                buffer.append("=\"");
                buffer.append(XMLWriter.getEscaped(String.valueOf(parameters.get(key))));
                buffer.append("\"");
            }
        }
        buffer.append(">");
        if (tab) {
            this.printTabulation();
        }
        if (newLine) {
            this.println(buffer.toString());
        } else {
            this.print(buffer.toString());
        }
    }

    public void startTag(String name, HashMap parameters) {
        this.startTag(name, parameters, true);
    }

    public void startTag(String name, HashMap parameters, boolean newLine) {
        this.printTag(name, parameters, true, newLine);
        ++this.tab;
    }

    private static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = XMLWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    public static String getEscaped(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            XMLWriter.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

