/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.resources;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.resources.IBeansResourceChangeEvents;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class BeansResourceChangeListener
implements IResourceChangeListener {
    public static final int LISTENER_FLAGS = 22;
    private static final int VISITOR_FLAGS = 7;
    private IBeansResourceChangeEvents events;

    public BeansResourceChangeListener(IBeansResourceChangeEvents events) {
        this.events = events;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IProject project = (IProject)event.getResource();
            IResourceDelta delta = event.getDelta();
            switch (event.getType()) {
                case 2: {
                    if (!SpringCoreUtils.isSpringProject((IResource)project)) break;
                    this.events.projectClosed(project);
                    break;
                }
                case 4: {
                    if (!SpringCoreUtils.isSpringProject((IResource)project)) break;
                    this.events.projectDeleted(project);
                    break;
                }
                case 16: {
                    if (delta == null) break;
                    try {
                        delta.accept((IResourceDeltaVisitor)new BeansProjectVisitor(), 7);
                        break;
                    }
                    catch (CoreException e) {
                        BeansCorePlugin.log("Error while traversing resource change delta", e);
                    }
                }
            }
        }
    }

    private class BeansProjectVisitor
    implements IResourceDeltaVisitor {
        BeansProjectVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    if (resource instanceof IProject) {
                        if (SpringCoreUtils.isSpringProject((IResource)resource)) {
                            BeansResourceChangeListener.this.events.projectAdded((IProject)resource);
                        }
                        return false;
                    }
                    if (!(resource instanceof IFile)) break;
                    IFile file = (IFile)resource;
                    if (this.isProjectDescriptionFile((IResource)file)) {
                        BeansResourceChangeListener.this.events.projectDescriptionChanged(file);
                    } else if (BeansCoreUtils.isBeansConfig((IResource)file)) {
                        BeansResourceChangeListener.this.events.configAdded(file);
                    }
                    return false;
                }
                case 16384: {
                    if (!(resource instanceof IProject)) break;
                    if (SpringCoreUtils.isSpringProject((IResource)resource)) {
                        BeansResourceChangeListener.this.events.projectOpened((IProject)resource);
                    }
                    return false;
                }
                case 4: {
                    int flags = delta.getFlags();
                    if (resource instanceof IFile) {
                        if ((flags & 0x100) != 0) {
                            IFile file = (IFile)resource;
                            if (this.isProjectDescriptionFile(resource)) {
                                BeansResourceChangeListener.this.events.projectDescriptionChanged(file);
                            } else if (BeansCoreUtils.isBeansConfig((IResource)file)) {
                                BeansResourceChangeListener.this.events.configChanged(file);
                            } else {
                                this.visitChangedFile(file);
                            }
                        }
                        return false;
                    }
                    if (!(resource instanceof IProject)) break;
                    if ((flags & 0x4000) != 0) {
                        if (SpringCoreUtils.isSpringProject((IResource)resource)) {
                            BeansResourceChangeListener.this.events.projectOpened((IProject)resource);
                        }
                        return false;
                    }
                    if ((flags & 0x80000) == 0) break;
                    IProject project = (IProject)resource;
                    if (SpringCoreUtils.isSpringProject((IResource)project)) {
                        if (!BeansResourceChangeListener.this.events.isSpringProject((IProject)resource)) {
                            BeansResourceChangeListener.this.events.springNatureAdded(project);
                        }
                    } else if (BeansResourceChangeListener.this.events.isSpringProject(project)) {
                        BeansResourceChangeListener.this.events.springNatureRemoved(project);
                    }
                    return false;
                }
                case 2: {
                    if (!(resource instanceof IFile)) break;
                    if (BeansCoreUtils.isBeansConfig(resource)) {
                        BeansResourceChangeListener.this.events.configRemoved((IFile)resource);
                    }
                    return false;
                }
            }
            return true;
        }

        private boolean isProjectDescriptionFile(IResource resource) {
            return resource != null && resource.isAccessible() && resource.getType() == 1 && resource.getFullPath().segmentCount() == 2 && resource.getName().equals(".springBeans");
        }

        private void visitChangedFile(IFile file) {
            ICompilationUnit cu;
            String ext = file.getFileExtension();
            if (ext != null && "java".equals(ext) && (cu = JavaCore.createCompilationUnitFrom((IFile)file)) != null && cu.exists()) {
                try {
                    IBeansModel model = BeansCorePlugin.getModel();
                    IType[] types = cu.getTypes();
                    int i = 0;
                    while (i < types.length) {
                        String className = types[i].getFullyQualifiedName();
                        Collection configs = model.getConfigs(className);
                        if (!configs.isEmpty()) {
                            BeansResourceChangeListener.this.events.beanClassChanged(className, configs);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    BeansCorePlugin.log(e);
                }
            }
        }
    }
}

