/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;

public class SpringUIUtils {
    static /* synthetic */ Class class$0;

    public static final Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static final Button createButton(Composite parent, String label, boolean enabled, SelectionListener buttonListener) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.setEnabled(enabled);
        button.addSelectionListener(buttonListener);
        FontMetrics fontMetrics = SpringUIUtils.getFontMetrics((Control)button);
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        data.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)14);
        button.setLayoutData((Object)data);
        return button;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final FontMetrics getFontMetrics(Control control) {
        FontMetrics fontMetrics = null;
        GC gc = new GC((Drawable)control);
        try {
            gc.setFont(control.getFont());
            fontMetrics = gc.getFontMetrics();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            gc.dispose();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        gc.dispose();
        return fontMetrics;
    }

    public static final boolean showPreferencePage(String id, IPreferencePage page, String title) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(SpringUIPlugin.getActiveWorkbenchShell(), manager);
        boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)SpringUIUtils.getStandardDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode, title, result){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            private final /* synthetic */ String val$title;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$targetNode = iPreferenceNode;
                this.val$title = string;
                this.val$result = blArray;
            }

            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                dialog.getShell().setText(this.val$title);
                this.val$result[0] = dialog.open() == 0;
            }
        });
        return result[0];
    }

    public static final IEditorPart getActiveEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = SpringUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static final ITextEditor getTextEditor(IEditorPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        if (part instanceof IAdaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ITextEditor)part.getAdapter((Class)clazz);
        }
        return null;
    }

    public static final IEditorPart openInEditor(IFile file, int line) {
        IEditorPart editor = null;
        IWorkbenchPage page = SpringUIPlugin.getActiveWorkbenchPage();
        try {
            if (line > 0) {
                IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
                marker.setAttribute("lineNumber", line);
                editor = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
            } else {
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
            }
        }
        catch (CoreException e) {
            SpringUIPlugin.log(e);
        }
        return editor;
    }

    public static final IEditorPart openInEditor(IEditorInput input, String editorId) {
        IWorkbenchPage page = SpringUIPlugin.getActiveWorkbenchPage();
        try {
            IEditorPart editPart = page.openEditor(input, editorId);
            if (editPart != null) {
                editPart.setFocus();
                return editPart;
            }
        }
        catch (PartInitException e) {
            SpringUIPlugin.log(e);
        }
        return null;
    }

    public static final IEditorPart openInEditor(IType type) {
        try {
            return JavaUI.openInEditor((IJavaElement)type);
        }
        catch (PartInitException e) {
            SpringUIPlugin.log(e);
        }
        catch (JavaModelException e) {
            SpringUIPlugin.log(e);
        }
        return null;
    }

    public static final int getCaretOffset(ITextEditor editor) {
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getOffset();
        }
        return -1;
    }

    public static final String getSelectedText(ITextEditor editor) {
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getText().trim();
        }
        return null;
    }
}

