/* =======================================
 * JFreeChart : a Java Chart Class Library
 * =======================================
 *
 * Project Info:  http://www.object-refinery.com/jfreechart/index.html
 * Project Lead:  David Gilbert (david.gilbert@object-refinery.com);
 *
 * (C) Copyright 2000-2002, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * -------------
 * TickUnit.java
 * -------------
 * (C) Copyright 2001, 2002, by Simba Management Limited.
 *
 * Original Author:  David Gilbert (for Simba Management Limited);
 * Contributor(s):   -;
 *
 * $Id: TickUnit.java,v 1.4 2002/05/01 14:32:26 mungady Exp $
 *
 * Changes (from 19-Dec-2001)
 * --------------------------
 * 19-Dec-2001 : Added standard header (DG);
 * 01-May-2002 : Changed the unit size from Number to double (DG);
 *
 */

package com.jrefinery.chart;

/**
 * Base class representing a tick unit.  This determines the spacing of the tick marks on an axis.
 * <P>
 * This class (and subclasses) should be immutable, the reason being that ordered collections of
 * tick units are maintained and if one instance can be changed, it may destroy the order of the
 * collection that it belongs to.  In addition, if the implementations are immutable, they can
 * belong to multiple collections.
 *
 */
public abstract class TickUnit implements Comparable {

    /** The size of the tick unit. */
    protected double size;

    /**
     * Constructs a new tick unit.
     *
     * @param size The tick unit size.
     */
    public TickUnit(double size) {
        this.size = size;
    }

    /**
     * Returns the size of the tick unit.
     */
    public double getSize() {
        return this.size;
    }

    /**
     * Converts the supplied value to a string.
     * <P>
     * Subclasses of TickUnit may implement special formatting by overriding this method.
     *
     * @param The data value.
     */
    public String valueToString(double value) {
        return String.valueOf(value);
    }

    /**
     * Compares this tick unit to an arbitrary object.
     *
     * @param object The object to compare against.
     */
    public int compareTo(Object object) {

        if (object instanceof TickUnit) {
            TickUnit other = (TickUnit)object;
            if (this.size>other.getSize()) {
                return 1;
            }
            else if (this.size<other.getSize()) {
                return -1;
            }
            else return 0;
        }
        else return -1;

    }

}