/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public final class UTF8Util {
    private static final int CHAR_COUNT = 0;
    private static final int BYTE_COUNT = 1;

    private UTF8Util() {
    }

    public static final long skipUntilEOF(InputStream inputStream) throws IOException {
        return UTF8Util.internalSkip(inputStream, Long.MAX_VALUE)[0];
    }

    public static final long skipFully(InputStream inputStream, long l) throws EOFException, IOException {
        long[] lArray = UTF8Util.internalSkip(inputStream, l);
        if (lArray[0] != l) {
            throw new EOFException("Reached end-of-stream prematurely at character/byte position " + lArray[0] + "/" + lArray[1] + ", trying to skip " + l);
        }
        return lArray[1];
    }

    private static final long[] internalSkip(InputStream inputStream, long l) throws IOException {
        int n;
        long l2 = 0L;
        long l3 = 0L;
        while (l2 < l && (n = inputStream.read()) != -1) {
            ++l2;
            if ((n & 0x80) == 0) {
                ++l3;
                continue;
            }
            if ((n & 0x60) == 64) {
                if (UTF8Util.skipPersistent(inputStream, 1L) != 1L) {
                    throw new UTFDataFormatException("Second byte in two byte character missing; byte pos " + l3 + " ; char pos " + l2);
                }
                l3 += 2L;
                continue;
            }
            if ((n & 0x70) == 96) {
                int n2 = 0;
                if (n == 224) {
                    int n3 = inputStream.read();
                    int n4 = inputStream.read();
                    if (n3 == 0 && n4 == 0) break;
                    if (n3 != -1 && n4 != -1) {
                        n2 = 2;
                    }
                } else {
                    n2 = (int)UTF8Util.skipPersistent(inputStream, 2L);
                }
                if (n2 != 2) {
                    throw new UTFDataFormatException("Second or third byte in three byte character missing; byte pos " + l3 + " ; char pos " + l2);
                }
                l3 += 3L;
                continue;
            }
            throw new UTFDataFormatException("Invalid UTF-8 encoding encountered: (decimal) " + n);
        }
        return new long[]{--l2, l3};
    }

    private static final long skipPersistent(InputStream inputStream, long l) throws IOException {
        long l2;
        long l3;
        for (l2 = 0L; l2 < l; l2 += l3) {
            l3 = inputStream.skip(l - l2);
            if (l3 > 0L) continue;
            if (inputStream.read() == -1) break;
            l3 = 1L;
        }
        return l2;
    }
}

