#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* changemode.c:
 *
 * handles everything involved in changing the editing mode.  This involves
 * installing various event handlers, and possibly redrawing all of the
 * trees (if you're moving in or out of Move Tree Mode, then all of the trees
 * must be redrawn because there are boxes around the trees that appear only
 * during this mode) */

#include "interface.h"

#include "treedata.h"

int change_editing_mode(m)
mouse_mode m;
{
	if(m==globals->mode)
		return(1);

	canvas_remove_all_event_functions();

	if(globals->mode==MouseMove || m==MouseMove)
		/* redraw everything to take care of boxes for move mode */
		canvas_add_all_trees();
	set_tool_cursor(m);
	switch(m)
	{
		case MouseTree:
			install(do_drag_node, NULL);
			install(do_drag_branch, do_drag_node);
			install(do_drag_text, do_drag_branch);
			install(do_drag_scale, do_drag_text);
			install(do_move_selection, do_drag_scale);
			install(do_scroll, do_move_selection);
			install(do_clip, do_scroll);
			install(do_drag_box, do_scroll);
            globals->mode=MouseTree;
            break;
        case MouseFlip:
			install(do_flip_node, NULL);
			install(do_scroll, do_flip_node);
			install(do_clip, do_scroll);
			install(do_background, do_clip);
            globals->mode=MouseFlip;
            break;
        case MouseMove:
			install(do_drag_tree, NULL);
			install(do_scroll, do_drag_tree);
			install(do_clip, do_scroll);
			install(do_background, do_clip);
            globals->mode=MouseMove;
            break;
        case MouseText:
			install(do_pick_text, NULL);
			install(do_pick_node, do_pick_text);
			install(do_scroll, do_pick_node);
			install(do_clip, do_scroll);
			install(do_background, do_clip);
            globals->mode=MouseText;
            break;
		case MouseHide:
			install(do_hide_node, NULL);
			install(do_scroll, do_hide_node);
			install(do_clip, do_scroll);
			install(do_background, do_clip);
            globals->mode=MouseHide;
			break;
		default:
			break;
	}
}

void install_dragging_function(f)
	/* add the dragging function while dragging is being performed */
int (*f)();
{
	canvas_add_event_function(f, NULL);
}

void uninstall_dragging_function(f)
	/* remove the dragging function when dragging is done */
int (*f)();
{
	canvas_remove_event_function(f);
}
