#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

/* draw.c:
 *
 * code for drawing various parts of the tree */

#include "interface.h"
#include "treedata.h"

draw_branch(b, c)
treebranch b;
tcanvas c;
{
	nodetypedata ud;
	nodetypedata dd;
	treetypedata ttd;
	branchtypedata td;
	int ux, uy, dx, dy;
	int lr, lw, lh;
	
	/* don't draw a branch if it has no parent */
	if(b->up==NULL)
		return;
	/* get the node types for the nodes on either side of the branch */
	ud=ndta(b->up)->td;
	dd=ndta(b->down)->td;
	/* don't draw a branch to a hidden node */
	if(dd->hidden)
		return;
	/* get the branch and tree type data */
	td=bdta(b)->td;
	ttd=tdta(tree_get_tree(b))->td;

	/* get the coordinates */
	ux=nodex(ud, ttd);
	uy=nodey(ud, ttd);
	dx=nodex(dd, ttd);
	dy=nodey(dd, ttd);
	/* adjust for thickness of the line */
	lr=(td->thickness-(td->thickness%2))/2;
	lh=(td->thickness-(td->thickness%2))/2;
	lh=lr*2;
	lw=lh-1;
	switch(ttd->bt)
	{
		case FlowerBranch:
			/* draw a diagonal line */
			draw_line(c, td->gc, ux, uy, dx, dy);
			/* round out the ends if the width of the line is more than 1 */
			if(td->thickness>1)
			{
				tcontext_set_linewidth(td->gc, 0);
				draw_arc(c, td->gc, ux-lr, uy-lr,
					lw, lh,
					0, 23040);
				draw_arc(c, td->gc, dx-lr, dy-lr,
					lw, lh,
					0, 23040);
				tcontext_set_linewidth(td->gc, td->thickness);
			}
			break;
		case Midway:
		case RoomForGroup:
		case OnScreen:
		default:
			/* draw horizontal and vertical components */
			draw_line(c, td->gc, ux, uy, ux, dy);
			draw_line(c, td->gc, ux, dy, dx, dy);
			/* round out the ends if the width is more than 1 */
			if(td->thickness>1)
			{
				tcontext_set_linewidth(td->gc, 0);
				draw_arc(c, td->gc, ux-lr, uy-lr,
					lw, lh,
					0, 23040);
				draw_arc(c, td->gc, dx-lr, dy-lr,
					lw, lh,
					0, 23040);
				draw_arc(c, td->gc, ux-lr, dy-lr,
					lw, lh,
					0, 23040);
				tcontext_set_linewidth(td->gc, td->thickness);
			}
			break;
	}
}

drag_node(n, x, y, c)
	/* draws a node while it is being dragged (in XOR mode) */
treenode n;
double x, y;
tcanvas c;
{
	int ix, iy;
	/* in comments, code for drawing branch while dragging */
	/*int px, py;*/
	/*nodetypedata nd;*/
	/*treetypedata td;*/

	/*nd=tndta(parent(n), NoTreeType);*/
	/*td=ttdta(tree_get_tree(n), NoTreeType);*/
	/*px=nodex(nd, td);*/
	/*py=nodey(nd, td);*/

	ix=x;
	iy=y;
	drag_circle_handle(c, ix, iy, NCHOOSERADIUS);
	/*if(tdta(tree_get_tree(n))==Flower)*/
		/*drag_line(c, px, py, x, y);*/
	/*else*/
	/*{*/
		/*drag_line(c, px, py, px, y);*/
		/*drag_line(c, px, y, x, y);*/
	/*}*/
}

drag_scale_bar(t, x, y, c)
	/* draws a the scale_bar handle while it is being dragged (in XOR mode) */
tree t;
int x, y;
tcanvas c;
{
	drag_circle_handle(c, x, y, PCHOOSERADIUS);
}

drag_branch_point_selection(b, p, c)
	/* draws a the branch point X while it is being dragged */
treebranch b;
double p;
tcanvas c;
{
	nodetypedata ud;
	nodetypedata dd;
	branchtypedata td;
	treetypedata ttd;
	int px, py;
	double ux, uy, dx, dy;
	
	/* only drag on branches with a node on either side */
	if(b->up==NULL)
		return;
	ud=ndta(b->up)->td;
	dd=ndta(b->down)->td;
	td=bdta(b)->td;
	ttd=tdta(tree_get_tree(b))->td;

	/* get ends of branch */
	ux=nodex(ud, ttd);
	uy=nodey(ud, ttd);
	dx=nodex(dd, ttd);
	dy=nodey(dd, ttd);

	/* calculate position on branch */
	switch(ttd->bt)
	{
		case FlowerBranch:
			px=ux+(dx-ux)*p;
			py=uy+(dy-uy)*p;
			break;
		case Midway:
		case RoomForGroup:
		case OnScreen:
		default:
			px=ux+(dx-ux)*p;
			py=dy;
			break;
	}
	/* draw with XOR on */
	drag_x_handle(c, px, py, BPICKDISTANCE);
}

draw_branch_point_selection(b, p, c)
	/* draw the branch point X, at the given percentage */
treebranch b;
double p;
tcanvas c;
{
	nodetypedata ud;
	nodetypedata dd;
	branchtypedata td;
	treetypedata ttd;
	int px, py;
	double ux, uy, dx, dy;
	
	if(b->up==NULL)
		return;
	ud=ndta(b->up)->td;
	dd=ndta(b->down)->td;
	td=bdta(b)->td;
	ttd=tdta(tree_get_tree(b))->td;

	/* get both ends of the branch */
	ux=nodex(ud, ttd);
	uy=nodey(ud, ttd);
	dx=nodex(dd, ttd);
	dy=nodey(dd, ttd);

	/* calculate position of X */
	switch(ttd->bt)
	{
		case FlowerBranch:
			px=ux+(dx-ux)*p;
			py=uy+(dy-uy)*p;
			break;
		case Midway:
		case RoomForGroup:
		case OnScreen:
		default:
			px=ux+(dx-ux)*p;
			py=dy;
			break;
	}
	/* draw */
	draw_x_handle(c, globals->handle_gc, px, py, BPICKDISTANCE);
}

draw_node(n, c)
	/* draw a node, with a label if necessary.  If it's a root node,
	 * then it's a square handle, otherwise it's a round handle.  If its
	 * children are hidden, then it's a double handle */
treenode n;
tcanvas c;
{
	int x, y;
	nodetypedata nd;
	treetypedata td;
	

	nd=ndta(n)->td;
	/* don't draw hidden nodes */
	if(nd->hidden)
		return;
	/* draw the label */
    if(showlabel(n, NoTreeType))
		ttext_repaint(nd->label);
	/* draw handles only if that preference is on */
	if(globals->handles)
	{
		/* get x,y position */
		td=tdta(tree_get_tree(n))->td;
		x=nodex(nd, td);
		y=nodey(nd, td);
		if(n==treeroot(tree_get_tree(n)))
			/* square for root, in root_gc (green) */
			draw_square_handle(c, globals->root_gc, x, y, NCHOOSERADIUS);
		else
			/* round otherwise, in handle_gc (red) */
			draw_circle_handle(c, globals->handle_gc, x, y, NCHOOSERADIUS);
		if(nd->childrenhidden)
		{
			/* children are hidden, so this should be double handle */
			if(n==treeroot(tree_get_tree(n)))
				draw_square_handle(c, globals->root_gc, x, y, NHIDDENRADIUS);
			else
				draw_circle_handle(c, globals->handle_gc, x, y, NHIDDENRADIUS);
		}
	}
}

draw_node_sel(n, c, nodeonly)
	/* draw selected node.  As above, but with filled circle or square */
treenode n;
tcanvas c;
int nodeonly;
{
	int x, y;
	nodetypedata nd;
	treetypedata td;
	
	nd=ndta(n)->td;
	if(nd->hidden)
		return;
	td=tdta(tree_get_tree(n))->td;
	x=nodex(nd, td);
	y=nodey(nd, td);

	/*if(nodeonly)
	{
		if(n==treeroot(tree_get_tree(n)))
		{
			draw_square_handle(c,
				globals->root_gc, x, y, NCHOOSERADIUS);
			draw_filled_square_handle(c,
				globals->root_gc, x, y, NCHOOSERADIUS-2);
		}
		else
		{
			draw_circle_handle(c,
				globals->handle_gc, x, y, NCHOOSERADIUS);
			draw_filled_circle_handle(c,
				globals->handle_gc, x, y, NCHOOSERADIUS-2);
		}
	}
	else*/
	{
		if(n==treeroot(tree_get_tree(n)))
			draw_filled_square_handle(c,
				globals->root_gc, x, y, NCHOOSERADIUS);
		else
			draw_filled_circle_handle(c,
				globals->handle_gc, x, y, NCHOOSERADIUS);
	}
}

draw_node_selection(n, c)
treenode n;
tcanvas c;
{
	draw_node_sel(n, c, 0);
}

draw_subtree_selection1(n, c)
treenode n;
tcanvas c;
{
	list t;

	draw_node_sel(n, c, 0);
	tforsubtree(n, t)
		draw_subtree_selection1(subtree(t), c);
}

draw_subtree_selection(n, c)
	/* draw an entire subtree selection.  Draws all the descendants of n
	 * (including n) selected */
treenode n;
tcanvas c;
{
	list t;

#ifdef DEBUG
	draw_node_sel(n, c, 1);
#endif
#ifndef DEBUG
	draw_node_sel(n, c, 0);
#endif
	tforsubtree(n, t)
		draw_subtree_selection1(subtree(t), c);
}

draw_tree_boundary(t, c)
tree t;
tcanvas c;
{
	treetypedata td;

	td=tdta(t)->td;
	/* draw box and handles around tree */
	draw_rect(c, globals->handle_gc, td->x, td->y, td->w, td->h);
	draw_square_handle(c, globals->handle_gc,
		td->x, td->y, TRESIZERADIUS);
	draw_square_handle(c, globals->handle_gc,
		td->x+td->w, td->y, TRESIZERADIUS);
	draw_square_handle(c, globals->handle_gc,
		td->x, td->y+td->h, TRESIZERADIUS);
	draw_square_handle(c, globals->handle_gc,
		td->x+td->w, td->y+td->h, TRESIZERADIUS);
}

draw_tree_scale_bar(t, c)
	/* draw the scale bar, a line which is basically a ruler to give an
	 * indication of the scaling of the tree */
tree t;
tcanvas c;
{
	treetypedata td;
	int x, y, w;

	td=tdta(t)->td;
	if(td->showpct)
	{
		ttext_repaint(td->percent);
		x=td->plx;
		y=td->ply;
		w=td->plw;
		draw_line(c, td->gc, x, y, x+w, y);
		if(globals->handles && !globals->autoformat)
		{
			x=td->px;
			y=td->py;
			draw_circle_handle(c, globals->handle_gc, x, y, PCHOOSERADIUS);
		}
	}
}

draw_tree(t, c)
tree t;
tcanvas c;
{
	list n;

	/* draw all branches */
	lfor(t->branches, n)
		draw_branch(nodeobj(n), c);
	/* draw all nodes */
	lfor(t->nodes, n)
		draw_node(nodeobj(n), c);
	/* draw the scale bar */
	draw_tree_scale_bar(t, c);
}
