#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* help.c:
 *
 * manages the help frame.  Displays the help text in helpdata.h in a scrolling
 * window with an index to the right */

#include "interface.h"

#include "treedata.h"

#include "helpdata.h"

#define TEXTWIDTH 300

static tframe help;
static tcanvas textc;
static tlist helplist;
static ttext helptext;
static int listwidth;

int resize_help_frame(f, e)
	/* when the help frame is resized, the sizes of the various components
	 * need to be changed (the canvas and the index list). */
tframe f;
tevent e;
{
	int w, h;

	if(tevent_type(e)==te_resize)
	{
		tevent_size(e, &w, &h);
		tcanvas_resize(textc, 0, 0, w-listwidth, h, NULL, NULL);
		tlist_resize(helplist, 0, 0, listwidth, h, textc, NULL);
		return(1);
	}
	else
		return(0);
}

int help_do_events(c, e)
	/* handle events on the help canvas, just redraw the text field */
tcanvas c;
tevent e;
{
	if(tevent_type(e)==te_repaint)
	{
		ttext_repaint(helptext);
	}
}

int pick_topic(l, item, e)
	/* callback for the index list.  When the mouse is released, the
	 * help topic selected is shown */
tlist l;
int item;
tevent e;
{
	switch(tevent_type(e))
	{
		case te_mouseup:
			/* select the whole helptext */
			ttext_set_selection(helptext, -1, -1);
			/* replace with the new helptext */
			ttext_insert_string(helptext, helptopic[item]);
			/* scroll to top and redraw */
			tcanvas_scroll_to_top(textc);
			tcanvas_add_all(textc);
			tcanvas_paint_area(textc);
			break;
		default:
			break;
	}
}

int create_help_frame(parent, args)
tframe parent;
targs args;
{
	tpanel p;
	int i;
	int height;
	int tmp;

	/* calculate width of widest topic, for width of list */
	listwidth=0;
	for(i=1;i<=NUMTOPICS;i++)
	{
		tmp=tfont_text_width(globals->cfont,
			topicnames[i], strlen(topicnames[i]));
		if(tmp>listwidth)
			listwidth=tmp;
	}
	listwidth+=50;

	/* create the frame */
    help=tframe_new(parent, 50,50,500,600,0,1,0, "Treetool Help", args);
    if(help==NULL)
		return(0);
	p=tframe_dialog_panel(help);
	tpanel_fit(p);
	tframe_set_event_procedure(help, resize_help_frame);
	tframe_push_pin(help);

	height=20*tfont_height(globals->cfont);

	/* create a canvas for showing the help text, with a vertical scrollbar */
	textc=(tcanvas)tcanvas_new2(help, 0, 0, TEXTWIDTH, height, NULL, NULL,
		TEXTWIDTH, height, 1, 4, 1,
		tfont_height(globals->cfont), 0, 0, 1, args);
	tcanvas_resize(textc, 0, 0, TEXTWIDTH, height, NULL, NULL);
	tcanvas_set_event_procedure(textc, help_do_events);
	tcanvas_pages(textc, 0);
	tcanvas_scroll_to_top(textc);

	/* create the text field on the canvas */
	helptext=ttext_new(textc, 5, 5, tcanvas_width(textc), 10, globals->cfont,
		"", globals->b, globals->w, args, 0);
	ttext_set_selection(helptext, -1, -1);
	ttext_insert_string(helptext, helptopic[1]);

	/* create a scrolling list to the right of the canvas */
	helplist=(tlist)tlist_new(help, 0,0,listwidth,height,textc,NULL,
		globals->cfont, 0, args);
	
	/* add the topic names to the scrolling list */
	for(i=1;i<=NUMTOPICS;i++)
		tlist_add(helplist, topicnames[i], -1, 0, 0);
	tlist_set_event_procedure(helplist, pick_topic);

    tframe_fit(help);
    tframe_hide(help);
	tframe_pull_pin(help);
    return(1);
}

int show_help_frame(topic)
int topic;
{
	moveframetoloc(help);
	/* show the topic if one is selected */
	if(topic!=0)
		tlist_select(helplist, topic);
	tframe_push_pin(help);
	tframe_show(help);
}

int hide_help_frame()
{
    tframe_hide(help);
}

help_busy()
{
	if(help!=NULL)
		tframe_set_busy(help);
}

help_notbusy()
{
	if(help!=NULL)
		tframe_set_notbusy(help);
}
