/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.effects.TremoloPickingEditor;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.TremoloPickingEffect;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTremoloPickingAction extends Action{
    public static final String NAME = "action.note.effect.change-tremolo-picking";
    
    public ChangeTremoloPickingAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {    	
    	Note note = getEditor().getTablature().getCaret().getSelectedNote();
    	if(note != null){
    		changeTremoloPicking(new TremoloPickingEditor().show(note));
    	}
    	return true;
    }
    	
	private void changeTremoloPicking(TremoloPickingEffect effect){
        //comienza el undoable
    	UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo();    	
    	
        Caret caret = getEditor().getTablature().getCaret();
        getSongManager().getMeasureManager().changeTremoloPicking(caret.getMeasureCoords().getMeasure(),caret.getPosition(),caret.getSelectedString().getNumber(),effect);
        updateTablature();	   
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo());
	}    
	
    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        redraw();
    }  	
	
}
